/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.external.GlyphTracker;
import org.jpedal.external.ShapeTracker;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.structuredtext.StructuredContentHandler;

public class ParserOptions {
    public boolean hasYCCKimages;
    public boolean imagesProcessedFully;
    private boolean isLayerVisible = true;
    private int layerLevel;
    private Set<Integer> layerVisibility = new HashSet<Integer>(50);
    public final Set<Integer> layerClips = new HashSet<Integer>(50);
    public PdfLayerList layers;
    protected boolean isPageContent;
    protected boolean renderPage;
    private boolean isFlattenedForm;
    private float flattenX;
    private float flattenY;
    private boolean isPrinting;
    protected float samplingUsed = -1.0f;
    protected StructuredContentHandler contentHandler;
    private int textPrint;
    public Shape defaultClip;
    protected boolean generateGlyphOnRender;
    private boolean textExtracted = true;
    private boolean renderText;
    private boolean renderClipText;
    private boolean textColorExtracted;
    int renderMode;
    int pageNum;
    int extractionMode;
    boolean useJavaFX;
    private boolean isXFA;
    protected GlyphTracker customGlyphTracker;
    private boolean renderDirectly;
    ShapeTracker customShapeTracker;
    String fileName = "";
    boolean tooManyShapes;

    public void setName(String name) {
        if (name != null) {
            this.fileName = name.toLowerCase();
            int sep = this.fileName.lastIndexOf(47);
            if (sep != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, sep);
            }
        }
    }

    public GlyphTracker getCustomGlyphTracker() {
        return this.customGlyphTracker;
    }

    public void setCustomGlyphTracker(GlyphTracker customGlyphTracker) {
        this.customGlyphTracker = customGlyphTracker;
    }

    public void setXFA(boolean isXFA) {
        this.isXFA = isXFA;
    }

    public boolean isPageContent() {
        return this.isPageContent;
    }

    public boolean isRenderPage() {
        return this.renderPage;
    }

    public void init(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting, boolean useJavaFX) {
        this.isPageContent = isPageContent;
        this.renderPage = renderPage;
        this.renderMode = renderMode;
        this.extractionMode = extractionMode;
        this.isPrinting = isPrinting;
        this.useJavaFX = useJavaFX;
        this.textExtracted = (extractionMode & 1) == 1;
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
    }

    public boolean isRenderClipText() {
        return this.renderClipText;
    }

    public boolean isRenderText() {
        return this.renderText;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public boolean isTextColorExtracted() {
        return this.textColorExtracted;
    }

    public boolean isTextExtracted() {
        return this.textExtracted;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public int getExtractionMode() {
        return this.extractionMode;
    }

    public boolean useJavaFX() {
        return this.useJavaFX;
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    public boolean generateGlyphOnRender() {
        return this.generateGlyphOnRender;
    }

    public void setGenerateGlyphOnRender(boolean value) {
        this.generateGlyphOnRender = value;
    }

    public int getTextPrint() {
        return this.textPrint;
    }

    public void setTextPrint(int value) {
        this.textPrint = value;
    }

    public StructuredContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(StructuredContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public boolean renderDirectly() {
        return this.renderDirectly;
    }

    void setRenderDirectly(boolean b) {
        this.renderDirectly = b;
    }

    public void setSamplingUsed(float scaleY) {
        this.samplingUsed = scaleY;
    }

    float getSamplingUsed() {
        return this.samplingUsed;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getPageNumber() {
        return this.pageNum;
    }

    public void setPageNumber(int value) {
        this.pageNum = value;
    }

    public void setCustomShapeTracker(ShapeTracker obj) {
        this.customShapeTracker = obj;
    }

    public ShapeTracker getCustomShapeTraker() {
        return this.customShapeTracker;
    }

    public void setFlattenedForm(boolean b) {
        this.isFlattenedForm = b;
    }

    public boolean isFlattenedForm() {
        return this.isFlattenedForm;
    }

    public void setOffsets(float x, float y) {
        this.flattenX = x;
        this.flattenY = y;
    }

    public float getflattenX() {
        return this.flattenX;
    }

    public float getflattenY() {
        return this.flattenY;
    }

    public boolean isLayerVisible() {
        return this.isLayerVisible;
    }

    public void setPdfLayerList(PdfLayerList layers) {
        this.layers = layers;
    }

    boolean hasContentHandler() {
        return this.contentHandler != null;
    }

    public int getLayerLevel() {
        return this.layerLevel;
    }

    public void setLayerLevel(int layerLevel) {
        this.layerLevel = layerLevel;
    }

    public Set<Integer> getLayerVisibility() {
        return this.layerVisibility;
    }

    public void setLayerVisibility(Set<Integer> layerVisibility) {
        this.layerVisibility = layerVisibility;
    }

    public void setIsLayerVisible(boolean isLayerVisible) {
        this.isLayerVisible = isLayerVisible;
    }
}

