/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.MaskUtils;
import org.jpedal.parser.image.XForm;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class XFormDecoder {
    static void processXForm(PdfStreamDecoder pdfStreamDecoder, int dataPointer, PdfObject XObject2, Shape defaultClip, CommandParser parser) {
        boolean debug = false;
        String oldFormName = pdfStreamDecoder.formName;
        String name = parser.generateOpAsString(0, true);
        try {
            if (ImageCommands.trackImages) {
                pdfStreamDecoder.imagesInFile = pdfStreamDecoder.imagesInFile == null ? name + " Form" : name + " Form\n" + pdfStreamDecoder.imagesInFile;
            }
            parser.reset();
            byte[] objectData = pdfStreamDecoder.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(pdfStreamDecoder.currentPdfFile.getObjectReader()));
            if (objectData != null) {
                boolean isIdentity;
                String oldIndent = PdfStreamDecoder.indent;
                PdfStreamDecoder.indent = PdfStreamDecoder.indent + "   ";
                float[] transformMatrix = new float[6];
                float[] matrix = XObject2.getFloatArray(1145198201);
                float[] formBBox = XObject2.getFloatArray(303185736);
                if (matrix != null && pdfStreamDecoder.BBox != null && formBBox != null) {
                    float Bheight;
                    float Bwidth;
                    if (pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                        Bwidth = pdfStreamDecoder.BBox[2] - pdfStreamDecoder.BBox[0];
                        Bheight = pdfStreamDecoder.BBox[3] - pdfStreamDecoder.BBox[1];
                    } else {
                        Bwidth = (pdfStreamDecoder.BBox[2] - pdfStreamDecoder.BBox[0]) / matrix[0];
                        Bheight = (pdfStreamDecoder.BBox[3] - pdfStreamDecoder.BBox[1]) / matrix[3];
                    }
                    if (Bwidth == formBBox[2] - formBBox[0] && Bheight == formBBox[3] - formBBox[1] && matrix[4] == 0.0f && matrix[5] == 0.0f) {
                        matrix = null;
                    }
                }
                boolean bl = isIdentity = matrix == null || XForm.isIdentity(matrix);
                if (matrix != null) {
                    transformMatrix = matrix;
                }
                int currentDepth = pdfStreamDecoder.graphicsStates.getDepth();
                float lineWidthInForm = -1.0f;
                float[][] currentCTM = new float[3][3];
                for (int i = 0; i < 3; ++i) {
                    System.arraycopy(pdfStreamDecoder.gs.CTM[i], 0, currentCTM[i], 0, 3);
                }
                float[][] oldCTM = currentCTM;
                float[][] CTM = pdfStreamDecoder.gs.CTM;
                Object scaleF = pdfStreamDecoder.gs.scaleFactor;
                if (matrix != null && !isIdentity) {
                    float[][] scaleFactor = new float[][]{{transformMatrix[0], transformMatrix[1], 0.0f}, {transformMatrix[2], transformMatrix[3], 0.0f}, {transformMatrix[4], transformMatrix[5], 1.0f}};
                    scaleF = scaleFactor;
                    pdfStreamDecoder.gs.CTM = Matrix.multiply(scaleFactor, CTM);
                    lineWidthInForm = transformMatrix[0] * pdfStreamDecoder.gs.getLineWidth();
                    if (lineWidthInForm == 0.0f) {
                        lineWidthInForm = transformMatrix[1] * pdfStreamDecoder.gs.getLineWidth();
                    }
                    if (lineWidthInForm < 0.0f) {
                        lineWidthInForm = -lineWidthInForm;
                    }
                }
                ++pdfStreamDecoder.formLevel;
                if (pdfStreamDecoder.formLevel == 1) {
                    pdfStreamDecoder.formName = name;
                } else if (pdfStreamDecoder.formLevel < 20) {
                    pdfStreamDecoder.formName = pdfStreamDecoder.formName + '_' + name;
                }
                GenericColorSpace mainStrokeColorData = (GenericColorSpace)pdfStreamDecoder.gs.strokeColorSpace.clone();
                GenericColorSpace mainnonStrokeColorData = (GenericColorSpace)pdfStreamDecoder.gs.nonstrokeColorSpace.clone();
                if (lineWidthInForm > 0.0f) {
                    pdfStreamDecoder.gs.setLineWidth(lineWidthInForm);
                }
                float maxStrokeValue = pdfStreamDecoder.gs.getAlphaMax(1);
                float maxFillValue = pdfStreamDecoder.gs.getAlphaMax(2);
                float currentFillValue = pdfStreamDecoder.gs.getAlpha(2);
                pdfStreamDecoder.gs.setMaxAlpha(1, pdfStreamDecoder.gs.getAlpha(1));
                if (pdfStreamDecoder.formLevel < 3 && currentFillValue < maxFillValue) {
                    pdfStreamDecoder.gs.setMaxAlpha(2, currentFillValue);
                }
                PdfObjectCache mainCache = pdfStreamDecoder.cache.copy();
                pdfStreamDecoder.cache.reset(mainCache);
                PdfObject Resources = XObject2.getDictionary(2004251818);
                pdfStreamDecoder.readResources(Resources, false);
                pdfStreamDecoder.cache.groupObj = XObject2.getDictionary(1111442775);
                pdfStreamDecoder.currentPdfFile.checkResolved(pdfStreamDecoder.cache.groupObj);
                float[] BBox = XObject2.getFloatArray(303185736);
                Area clip = null;
                boolean clipChanged = false;
                if (BBox != null && BBox[2] > 1.0f && BBox[3] > 1.0f && pdfStreamDecoder.gs.getClippingShape() == null && pdfStreamDecoder.gs.CTM[0][1] == 0.0f && pdfStreamDecoder.gs.CTM[1][0] == 0.0f && pdfStreamDecoder.gs.CTM[2][1] != 0.0f && pdfStreamDecoder.gs.CTM[2][0] < 0.0f) {
                    clip = XForm.setClip(defaultClip, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    clipChanged = true;
                } else if (BBox != null && BBox[0] == 0.0f && BBox[1] == 0.0f && BBox[2] > 1.0f && BBox[3] > 1.0f && BBox[2] != BBox[3] && ((double)pdfStreamDecoder.gs.CTM[0][0] > 0.99 || pdfStreamDecoder.gs.CTM[2][1] < -1.0f) && (pdfStreamDecoder.gs.CTM[2][0] < -1.0f || pdfStreamDecoder.gs.CTM[2][0] > 1.0f) && pdfStreamDecoder.gs.CTM[2][1] != 0.0f) {
                    clip = XForm.setClip(defaultClip, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    clipChanged = true;
                } else if (BBox != null && BBox[0] == 0.0f && BBox[1] == 0.0f && BBox[2] > 1.0f && BBox[3] > 1.0f && !(pdfStreamDecoder.gs.CTM[2][0] < 0.0f) && (pdfStreamDecoder.formLevel > 0 || pdfStreamDecoder.gs.getClippingShape() != null)) {
                    clip = XForm.setClip(defaultClip, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    clipChanged = true;
                } else if (pdfStreamDecoder.formLevel > 1 && BBox != null && BBox[0] > 50.0f && BBox[1] > 50.0f && pdfStreamDecoder.gs.getClippingShape() != null && BBox[0] - 1.0f > (float)pdfStreamDecoder.gs.getClippingShape().getBounds().x && BBox[1] - 1.0f > (float)pdfStreamDecoder.gs.getClippingShape().getBounds().y) {
                    clip = XForm.setClip(defaultClip, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    clipChanged = true;
                } else if (BBox != null && BBox[2] > 1.0f && BBox[3] > 1.0f && pdfStreamDecoder.gs.getClippingShape() == null && pdfStreamDecoder.gs.CTM[0][1] > 0.0f && pdfStreamDecoder.gs.CTM[1][0] < 0.0f && pdfStreamDecoder.gs.CTM[0][0] == 0.0f && pdfStreamDecoder.gs.CTM[1][1] == 0.0f) {
                    clip = XForm.setClip(defaultClip, BBox, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    clipChanged = true;
                }
                if (objectData.length > 0) {
                    PdfObject newSMask = XForm.getSMask(BBox, pdfStreamDecoder.gs, pdfStreamDecoder.currentPdfFile);
                    int blendMode = pdfStreamDecoder.gs.getBMValue();
                    if ((pdfStreamDecoder.parserOptions.getExtractionMode() & 0x400) == 1024) {
                        XFormDecoder.processXFormAsImage(XObject2, pdfStreamDecoder);
                    }
                    if (newSMask != null || blendMode != 1111314299) {
                        XFormDecoder.processXFormWithMaskOrBlend(false, newSMask, pdfStreamDecoder, blendMode, XObject2, name);
                    } else {
                        int BM = pdfStreamDecoder.gs.getBMValue();
                        pdfStreamDecoder.decodeStreamIntoObjects(objectData, false);
                        pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), BM);
                        pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), BM);
                    }
                }
                if (clipChanged) {
                    pdfStreamDecoder.gs.setClippingShape(clip);
                    pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, clip, false);
                }
                --pdfStreamDecoder.formLevel;
                pdfStreamDecoder.graphicsStates.correctDepth(currentDepth, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                if (oldCTM != null) {
                    pdfStreamDecoder.gs.CTM = oldCTM;
                } else if (pdfStreamDecoder.gs.CTM[0][0] == 1.0f && pdfStreamDecoder.gs.CTM[1][1] == 1.0f) {
                    pdfStreamDecoder.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                }
                pdfStreamDecoder.gs.scaleFactor = scaleF;
                pdfStreamDecoder.gs.strokeColorSpace = mainStrokeColorData;
                pdfStreamDecoder.gs.nonstrokeColorSpace = mainnonStrokeColorData;
                pdfStreamDecoder.cache.restore(mainCache);
                pdfStreamDecoder.gs.setMaxAlpha(1, maxStrokeValue);
                pdfStreamDecoder.gs.setMaxAlpha(2, maxFillValue);
                PdfStreamDecoder.indent = oldIndent;
            }
        }
        catch (Error e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            pdfStreamDecoder.parserOptions.imagesProcessedFully = false;
            pdfStreamDecoder.errorTracker.addPageFailureMessage("Error " + e + " in DO");
            if (ExternalHandlers.throwMissingCIDError && e.getMessage() != null && e.getMessage().contains("kochi")) {
                throw e;
            }
        }
        catch (PdfException e) {
            LogWriter.writeLog("Exception " + e);
            pdfStreamDecoder.parserOptions.imagesProcessedFully = false;
            pdfStreamDecoder.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        pdfStreamDecoder.formName = oldFormName;
    }

    static void processXFormWithMaskOrBlend(boolean debug, PdfObject newSMask, PdfStreamDecoder pdfStreamDecoder, int blendMode, PdfObject XObject2, String name) {
        if (debug) {
            System.out.println("createMaskForm " + newSMask);
        }
        if (newSMask == null && pdfStreamDecoder.current.getType() == 9) {
            pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), 1111314299);
            pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), 1111314299);
        }
        boolean useTransparancy = newSMask != null || blendMode != 1111314299 || pdfStreamDecoder.gs.getAlpha(2) == 1.0f;
        MaskUtils.createMaskForm(XObject2, name, newSMask, pdfStreamDecoder.gs, pdfStreamDecoder.current, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer, useTransparancy);
        if (newSMask == null && pdfStreamDecoder.current.getType() == 9) {
            pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), blendMode);
            pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), blendMode);
        }
    }

    static void processXFormAsImage(PdfObject XObject2, PdfStreamDecoder pdfStreamDecoder) {
        float[] BBox = XObject2.getFloatArray(303185736);
        int fy = (int)BBox[1];
        int fw = (int)BBox[2];
        int fh = (int)BBox[3];
        BufferedImage currentImage = MaskUtils.createTransparentForm(XObject2, fy, fw, fh, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
        String imgName = 'R' + pdfStreamDecoder.formName;
        pdfStreamDecoder.pdfImages.setImageInfo(imgName, pdfStreamDecoder.parserOptions.getPageNumber(), pdfStreamDecoder.gs.CTM[2][0], pdfStreamDecoder.gs.CTM[2][1], fw, fh);
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImage('R' + imgName, currentImage, false, false, "jpg");
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImage(imgName, currentImage, false, false, "jpg");
    }
}

