/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.color;

import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.utils.StringUtils;

public class CS {
    public static void execute(boolean isLowerCase, String colorspaceObject, GraphicsState gs, PdfObjectCache cache, PdfObjectReader currentPdfFile, boolean isPrinting, int pageNum, PdfPageData pageData, boolean alreadyUsed) {
        GenericColorSpace newColorSpace;
        boolean isStroke = !isLowerCase;
        PdfObject ColorSpace2 = (PdfObject)cache.get(2, colorspaceObject);
        if (ColorSpace2 == null) {
            ColorSpace2 = new ColorSpaceObject(StringUtils.toBytes(colorspaceObject));
        }
        String ref = ColorSpace2.getObjectRefAsString();
        String ref2 = ref + '-' + isLowerCase;
        if (ColorSpace2.getParameterConstant(2087749783) == 1146450818 && colorspaceObject.equals("Pattern")) {
            newColorSpace = new PatternColorSpace(currentPdfFile, new DeviceRGBColorSpace());
        } else if (!alreadyUsed && cache.containsKey(3)) {
            newColorSpace = (GenericColorSpace)cache.get(3, ref);
            newColorSpace.reset();
        } else if (alreadyUsed && cache.containsKey(3)) {
            newColorSpace = (GenericColorSpace)cache.get(3, ref2);
            newColorSpace.reset();
        } else {
            newColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, ColorSpace2);
            newColorSpace.setPrinting(isPrinting);
            if (!(newColorSpace.getID() != 1247168582 && newColorSpace.getID() != -2073385820 || ref.contains("-1"))) {
                if (!alreadyUsed) {
                    cache.put(3, ref, (Object)newColorSpace);
                } else {
                    cache.put(3, ref2, (Object)newColorSpace);
                }
            }
        }
        if (newColorSpace.getID() == 1146450818) {
            newColorSpace.setPattern(cache.patterns, pageData.getMediaBoxWidth(pageNum), pageData.getMediaBoxHeight(pageNum), gs.CTM);
            newColorSpace.setGS(gs);
        }
        cache.put(1, newColorSpace.getID(), (Object)"x");
        if (isStroke) {
            gs.strokeColorSpace = newColorSpace;
        } else {
            gs.nonstrokeColorSpace = newColorSpace;
        }
    }
}

