/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.parser.image.data.ImageData;

class EightBitDownSampler {
    EightBitDownSampler() {
    }

    static GenericColorSpace downSample(ImageData imageData, GenericColorSpace decodeColorData, int sampling, byte[] index) {
        int origLineLength;
        byte[] newData;
        int comp;
        boolean hasIndex = decodeColorData.getIndexedMap() != null && (decodeColorData.getID() == 1785221209 || decodeColorData.getID() == 1008872003 || decodeColorData.getID() == 1498837125 || decodeColorData.getID() == 1247168582 || decodeColorData.getID() == 960981604);
        int indexCount = 1;
        if (hasIndex) {
            comp = 1;
            imageData.setCompCount(3);
            indexCount = 3;
            index = decodeColorData.convertIndexToRGB(index);
            decodeColorData = new DeviceRGBColorSpace();
        } else {
            comp = decodeColorData.getColorComponentCount();
        }
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        byte[] data = imageData.getObjectData();
        int oldSize = data.length;
        if (imageData.getWidth() * imageData.getHeight() == oldSize || decodeColorData.getID() == 1568372915) {
            comp = 1;
        }
        if (hasIndex) {
            newData = new byte[newW * newH * indexCount];
            origLineLength = imageData.getWidth();
        } else {
            newData = new byte[newW * newH * comp];
            origLineLength = imageData.getWidth() * comp;
        }
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = imageData.getWidth() - x;
                int hGapLeft = imageData.getHeight() - y;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                for (int jj = 0; jj < comp; ++jj) {
                    int newPtr;
                    int aa;
                    int byteTotal = 0;
                    int count = 0;
                    int[] indexAv = new int[indexCount];
                    for (int yy = 0; yy < hCount; ++yy) {
                        for (int xx = 0; xx < wCount; ++xx) {
                            int ptr = (yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj);
                            if (ptr >= oldSize) continue;
                            if (!hasIndex) {
                                byteTotal += data[ptr] & 0xFF;
                            } else {
                                for (aa = 0; aa < indexCount; ++aa) {
                                    int n = aa;
                                    indexAv[n] = indexAv[n] + (index[(data[ptr] & 0xFF) * indexCount + aa] & 0xFF);
                                }
                            }
                            ++count;
                        }
                    }
                    if (hasIndex) {
                        newPtr = jj + x * indexCount + newW * y * indexCount;
                        for (aa = 0; aa < indexCount; ++aa) {
                            newData[newPtr + aa] = (byte)(indexAv[aa] / count);
                        }
                        continue;
                    }
                    if (count <= 0) continue;
                    newPtr = jj + x * comp + newW * y * comp;
                    newData[newPtr] = (byte)(byteTotal / count);
                }
            }
        }
        imageData.setObjectData(newData);
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        return decodeColorData;
    }
}

