/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    static boolean sharpenDownsampledImages;
    public static boolean trackImages;
    public static boolean rejectSuperimposedImages;

    static BufferedImage makeBlackandWhiteTransparent(BufferedImage image) {
        WritableRaster ras = image.getRaster();
        int w = ras.getWidth();
        int h = ras.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 2);
        boolean validPixelsFound = false;
        int[] values = new int[3];
        int[] transparentPixel = new int[]{255, 0, 0, 0};
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean isBlack;
                ras.getPixels(x, y, 1, 1, values);
                boolean transparent = values[0] > 245 && values[1] > 245 && values[2] > 245;
                boolean bl = isBlack = values[0] < 10 && values[1] < 10 && values[2] < 10;
                if (transparent || isBlack) {
                    newImage.getRaster().setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                validPixelsFound = true;
                int[] newPixel = new int[4];
                newPixel[3] = 255;
                newPixel[0] = values[0];
                newPixel[1] = values[1];
                newPixel[2] = values[2];
                newImage.getRaster().setPixels(x, y, 1, 1, newPixel);
            }
        }
        if (validPixelsFound) {
            return newImage;
        }
        return null;
    }

    static BufferedImage simulateOP(BufferedImage image, boolean whiteIs255) {
        WritableRaster ras = image.getRaster();
        image = ColorSpaceConvertor.convertToARGB(image);
        int w = image.getWidth();
        int h = image.getHeight();
        boolean hasNoTransparent = false;
        int[] transparentPixel = new int[]{255, 0, 0, 0};
        int[] values = new int[4];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean transparent;
                ras.getPixel(x, y, values);
                if (whiteIs255) {
                    transparent = values[0] > 243 && values[1] > 243 && values[2] > 243;
                } else {
                    boolean bl = transparent = values[1] < 3 && values[2] < 3 && values[3] < 3;
                }
                if (transparent) {
                    image.getRaster().setPixel(x, y, transparentPixel);
                    continue;
                }
                hasNoTransparent = true;
            }
        }
        if (hasNoTransparent) {
            return image;
        }
        return null;
    }

    static void getMaskColor(byte[] maskCol, GraphicsState gs) {
        int foreground = gs.nonstrokeColorSpace.getColor().getRGB();
        maskCol[0] = (byte)(foreground >> 16 & 0xFF);
        maskCol[1] = (byte)(foreground >> 8 & 0xFF);
        maskCol[2] = (byte)(foreground & 0xFF);
    }

    static boolean isRepeatingLine(byte[] lineData, int height) {
        if (lineData.length % height != 0) {
            return false;
        }
        int step = lineData.length / height;
        for (int x = 0; x < lineData.length / height - 1; ++x) {
            for (int targetIndex = step; targetIndex < lineData.length - 1; targetIndex += step) {
                if (lineData[x] == lineData[targetIndex]) continue;
                return false;
            }
        }
        return true;
    }

    static BufferedImage simulateOverprint(GenericColorSpace decodeColorData, byte[] data, boolean isDCT, boolean isJPX, BufferedImage image, int colorspaceID, DynamicVectorRenderer current, GraphicsState gs) {
        if ((colorspaceID == 1498837125 || colorspaceID == 1247168582) && gs.getOPM() == 1.0f) {
            boolean isBlank = false;
            byte[] index = decodeColorData.getIndexedMap();
            if (index == null && current.hasObjectsBehind(gs.CTM)) {
                isBlank = true;
                for (int ii = 0; ii < data.length; ++ii) {
                    if (data[ii] == 0) continue;
                    ii = data.length;
                    isBlank = false;
                }
            }
            if (isBlank) {
                image.flush();
                image = null;
            } else if (gs.getNonStrokeOP()) {
                if (isDCT || isJPX) {
                    image = ImageCommands.simulateOP(image, false);
                } else if (gs.getNonStrokeOP()) {
                    image = colorspaceID == 1498837125 ? ImageCommands.simulateOP(image, false) : ImageCommands.simulateOP(image, image.getType() == 1);
                }
            }
        }
        return image;
    }

    static BufferedImage addBackgroundToMask(BufferedImage image, boolean isMask) {
        if (isMask) {
            int cw = image.getWidth();
            int ch = image.getHeight();
            BufferedImage background = new BufferedImage(cw, ch, 1);
            Graphics2D g2 = background.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cw, ch);
            g2.drawImage((Image)image, 0, 0, null);
            image = background;
        }
        return image;
    }

    static BufferedImage applyTR(BufferedImage image, PdfObject TR2, PdfObjectReader currentPdfFile) {
        PDFFunction[] functions = new PDFFunction[4];
        boolean hasFunction = false;
        int total = 0;
        byte[][] kidList = TR2.getKeyArray(9250);
        if (kidList != null) {
            total = kidList.length;
        }
        for (int count = 0; count < total; ++count) {
            if (kidList[count] == null) continue;
            String ref = new String(kidList[count]);
            FunctionObject Function2 = new FunctionObject(ref);
            byte[] possIdent = kidList[count];
            if (possIdent != null && possIdent.length > 4 && possIdent[0] == 47 && possIdent[1] == 73 && possIdent[2] == 100 && possIdent[3] == 101) {
                Function2 = null;
            } else {
                currentPdfFile.readObject(Function2);
            }
            if (Function2 == null) continue;
            functions[count] = FunctionFactory.getFunction(Function2, currentPdfFile);
            hasFunction = true;
        }
        if (!hasFunction) {
            return image;
        }
        WritableRaster ras = image.getRaster();
        int[] values = new int[4];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                ras.getPixels(x, y, 1, 1, values);
                for (int a = 0; a < 3; ++a) {
                    float[] raw = new float[]{(float)values[a] / 255.0f};
                    if (functions[a] == null) continue;
                    float[] processed = functions[a].compute(raw);
                    values[a] = (int)(255.0f * processed[0]);
                }
                image.getRaster().setPixels(x, y, 1, 1, values);
            }
        }
        return image;
    }

    static void applyDecodeArray(byte[] data, int d, float[] decodeArray, int type) {
        block17: {
            int maxValue;
            int count;
            block16: {
                count = decodeArray.length;
                maxValue = 0;
                for (float aDecodeArray : decodeArray) {
                    if (!((float)maxValue < aDecodeArray)) continue;
                    maxValue = (int)aDecodeArray;
                }
                boolean isIdentify = true;
                int compCount = decodeArray.length;
                for (int comp = 0; comp < compCount; comp += 2) {
                    if (decodeArray[comp] == 0.0f && (decodeArray[comp + 1] == 1.0f || decodeArray[comp + 1] == 255.0f)) continue;
                    isIdentify = false;
                    comp = compCount;
                }
                if (isIdentify) {
                    return;
                }
                if (d != 1) break block16;
                if (!(decodeArray[0] > decodeArray[1])) break block17;
                int byteCount = data.length;
                for (int ii = 0; ii < byteCount; ++ii) {
                    data[ii] = ~data[ii];
                }
                break block17;
            }
            if (d == 8 && maxValue > 1 && (type == 1785221209 || type == 1008872003 || type == 1498837125)) {
                int j = 0;
                for (int ii = 0; ii < data.length; ++ii) {
                    int currentByte = data[ii] & 0xFF;
                    if ((float)currentByte < decodeArray[j]) {
                        currentByte = (int)decodeArray[j];
                    } else if ((float)currentByte > decodeArray[j + 1]) {
                        currentByte = (int)decodeArray[j + 1];
                    }
                    if ((j += 2) == decodeArray.length) {
                        j = 0;
                    }
                    data[ii] = (byte)currentByte;
                }
            } else {
                maxValue = d << 1;
                int divisor = maxValue - 1;
                for (int ii = 0; ii < data.length; ++ii) {
                    byte currentByte = data[ii];
                    int dd = 0;
                    int newByte = 0;
                    int min = 0;
                    int max = 1;
                    for (int bits = 7; bits > -1; --bits) {
                        int current = currentByte >> bits & 1;
                        if ((current = (int)(decodeArray[min] + (float)current * ((decodeArray[max] - decodeArray[min]) / (float)divisor))) > maxValue) {
                            current = maxValue;
                        }
                        if (current < 0) {
                            current = 0;
                        }
                        current = (current & 1) << bits;
                        newByte += current;
                        if ((dd += 2) == count) {
                            dd = 0;
                            min = 0;
                            max = 1;
                            continue;
                        }
                        min += 2;
                        max += 2;
                    }
                    data[ii] = (byte)newByte;
                }
            }
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader currentPdfFile) {
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        return decryption == null || decryption.getBooleanValue(103);
    }

    static {
        String nodownsamplesharpen;
        String imgSetting;
        rejectSuperimposedImages = true;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (operlapValue != null) {
            rejectSuperimposedImages = operlapValue.toLowerCase().contains("true");
        }
        if ((imgSetting = System.getProperty("org.jpedal.trackImages")) != null) {
            trackImages = imgSetting.toLowerCase().contains("true");
        }
        if ((nodownsamplesharpen = System.getProperty("org.jpedal.sharpendownsampledimages")) != null) {
            sharpenDownsampledImages = nodownsamplesharpen.toLowerCase().contains("true");
        }
    }
}

