/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import org.jpedal.JDeliHelper;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public class JPeg2000ImageDecoder {
    public static BufferedImage decode(String name, int w, int h, GenericColorSpace decodeColorData, byte[] data, float[] decodeArray, ImageData imageData, int d) throws RuntimeException, PdfException {
        LogWriter.writeLog("JPeg 2000 Image " + name + ' ' + w + "W * " + h + 'H');
        BufferedImage image = decodeColorData.JPEG2000ToRGBImage(data, w, h, decodeArray, imageData.getpX(), imageData.getpY(), d);
        return image;
    }

    public static byte[] getBytesFromJPEG2000(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        try {
            return JDeliHelper.getBytesFromJPEG(data);
        }
        catch (Exception ex) {
            LogWriter.writeLog("Exception with JPeg Image " + ex);
            return null;
        }
    }
}

