/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.JDeliHelper;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.data.ImageData;

class MaskDataDecoder {
    MaskDataDecoder() {
    }

    static byte[] applyMask(ImageData imageData, GenericColorSpace decodeColorData, PdfObject newMask, PdfObject XObject2, byte[] maskDataSream) {
        int[] maskArray = newMask.getIntArray(489767739);
        byte[] objectData = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        objectData = MaskDataDecoder.convertData(decodeColorData, objectData, w, h, imageData, d, 1, null);
        XObject2.setIntNumber(-1344207655, 8);
        objectData = maskArray != null ? MaskDataDecoder.applyMaskArray(w, h, objectData, maskArray) : MaskDataDecoder.applyMaskStream(maskDataSream, imageData, newMask, XObject2);
        float[] maskDecodeArray = newMask.getFloatArray(859785322);
        if (maskDecodeArray != null) {
            ImageCommands.applyDecodeArray(objectData, maskDecodeArray.length / 2, maskDecodeArray, 1785221209);
        }
        return objectData;
    }

    static BufferedImage applyMaskArray(ImageData imageData, int[] maskArray) {
        int bitDepth = imageData.getDepth();
        int nComp = maskArray.length / 2;
        int dim = imageData.getWidth() * imageData.getHeight();
        BufferedImage img = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] output = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        byte[] data = imageData.getObjectData();
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                BitReader reader = new BitReader(data, true);
                for (int i = 0; i < dim; ++i) {
                    boolean isMask;
                    if (nComp == 1) {
                        int t = reader.getPositive(bitDepth);
                        boolean bl = isMask = t >= maskArray[0] && t <= maskArray[1];
                        if (isMask) continue;
                        output[i] = 0xFF000000 | (t ^= 0xFF) << 16 | t << 8 | t;
                        continue;
                    }
                    int r = reader.getPositive(bitDepth);
                    int g = reader.getPositive(bitDepth);
                    int b = reader.getPositive(bitDepth);
                    boolean bl = isMask = r >= maskArray[0] && r <= maskArray[1] && g >= maskArray[2] && g <= maskArray[3] && b >= maskArray[4] && b <= maskArray[5];
                    if (isMask) continue;
                    output[i] = 0xFF000000 | (r ^= 0xFF) << 16 | (g ^= 0xFF) << 8 | (b ^= 0xFF);
                }
                break;
            }
            case 8: {
                int p = 0;
                if (nComp == 1) {
                    for (int i = 0; i < dim; ++i) {
                        int t;
                        boolean isMask;
                        boolean bl = isMask = (t = data[p++] & 0xFF) >= maskArray[0] && t <= maskArray[1];
                        if (isMask) continue;
                        output[i] = 0xFF000000 | t << 16 | t << 8 | t;
                    }
                    break;
                }
                if (nComp == 3) {
                    for (int i = 0; i < dim; ++i) {
                        boolean isMask;
                        int r = data[p++] & 0xFF;
                        int g = data[p++] & 0xFF;
                        int b = data[p++] & 0xFF;
                        boolean bl = isMask = r >= maskArray[0] && r <= maskArray[1] && g >= maskArray[2] && g <= maskArray[3] && b >= maskArray[4] && b <= maskArray[5];
                        if (isMask) continue;
                        output[i] = 0xFF000000 | r << 16 | g << 8 | b;
                    }
                    break;
                }
                if (nComp != 4) break;
                JDeliHelper.processJPEG(dim, data, p, maskArray, output);
            }
        }
        return img;
    }

    static byte[] applySMask(byte[] maskData, ImageData imageData, GenericColorSpace decodeColorData, PdfObject newSMask, PdfObject XObject2) {
        byte[] objectData = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        int maskW = newSMask.getInt(959726687);
        int maskH = newSMask.getInt(959926393);
        int maskD = newSMask.getInt(-1344207655);
        objectData = MaskDataDecoder.convertData(decodeColorData, objectData, w, h, imageData, d, maskD, maskData);
        if (maskD != 8) {
            maskData = ColorSpaceConvertor.normaliseTo8Bit(maskD, maskW, maskH, maskData);
        }
        if (w == maskW && h == maskH) {
            objectData = MaskDataDecoder.buildUnscaledByteArray(w, h, objectData, maskData);
        } else if (w < maskW) {
            objectData = MaskDataDecoder.upScaleImageToMask(w, h, maskW, maskH, objectData, maskData);
            XObject2.setIntNumber(959726687, maskW);
            XObject2.setIntNumber(959926393, maskH);
        } else {
            objectData = MaskDataDecoder.upScaleMaskToImage(w, h, maskW, maskH, objectData, maskData);
        }
        XObject2.setIntNumber(-1344207655, 8);
        return objectData;
    }

    static byte[] applyMaskStream(byte[] maskData, ImageData imageData, PdfObject newMask, PdfObject XObject2) {
        byte[] objectData = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int maskW = newMask.getInt(959726687);
        int maskH = newMask.getInt(959926393);
        int maskD = newMask.getInt(-1344207655);
        if (maskD != 8) {
            maskData = ColorSpaceConvertor.normaliseTo8Bit(maskD, maskW, maskH, maskData);
        }
        if (w == maskW && h == maskH) {
            objectData = MaskDataDecoder.buildUnscaledByteArray(w, h, objectData, maskData);
        } else if (w < maskW) {
            objectData = MaskDataDecoder.upScaleImageToMask(w, h, maskW, maskH, objectData, maskData);
            XObject2.setIntNumber(959726687, maskW);
            XObject2.setIntNumber(959926393, maskH);
        } else {
            objectData = MaskDataDecoder.upScaleMaskToImage(w, h, maskW, maskH, objectData, maskData);
        }
        XObject2.setIntNumber(-1344207655, 8);
        return objectData;
    }

    static byte[] convertSmaskData(GenericColorSpace decodeColorData, byte[] objectData, int w, int h, ImageData imageData, int d, int maskD, byte[] maskData, PdfObject smask) {
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, w, h, imageData.getCompCount(), imageData.getDepth(), objectData, false, false);
        } else if (decodeColorData.getID() != 1008872003) {
            if (decodeColorData.getID() == 1785221209) {
                float[] decodeArr;
                if (d == 8) {
                    MaskDataDecoder.check4BitData(objectData);
                }
                if ((decodeArr = smask.getFloatArray(859785322)) != null && decodeArr[0] == 1.0f && decodeArr[1] == 0.0f) {
                    int i = 0;
                    while (i < maskData.length) {
                        int n = i++;
                        maskData[n] = (byte)(maskData[n] ^ 0xFF);
                    }
                }
            } else if (decodeColorData.getID() == 1568372915 && imageData.isJPX()) {
                if (maskData != null && maskD == 1) {
                    for (int ii = 0; ii < maskData.length; ++ii) {
                        maskData[ii] = (byte)(maskData[ii] ^ 0xFF);
                    }
                }
            } else if (!imageData.isDCT() && !imageData.isJPX()) {
                objectData = decodeColorData.dataToRGBByteArray(objectData, w, h, false);
            }
        }
        return objectData;
    }

    static byte[] convertData(GenericColorSpace decodeColorData, byte[] objectData, int w, int h, ImageData imageData, int d, int maskD, byte[] maskData) {
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            index = decodeColorData.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, w, h, imageData.getCompCount(), imageData.getDepth(), objectData, false, false);
        } else if (decodeColorData.getID() != 1008872003) {
            if (decodeColorData.getID() == 1785221209) {
                if (d == 8) {
                    MaskDataDecoder.check4BitData(objectData);
                }
                if (maskData != null && maskD == 1) {
                    for (int ii = 0; ii < maskData.length; ++ii) {
                        maskData[ii] = (byte)(maskData[ii] ^ 0xFF);
                    }
                }
            } else if (decodeColorData.getID() == 1568372915 && imageData.isJPX()) {
                if (maskData != null && maskD == 1) {
                    for (int ii = 0; ii < maskData.length; ++ii) {
                        maskData[ii] = (byte)(maskData[ii] ^ 0xFF);
                    }
                }
            } else if (!imageData.isDCT() && !imageData.isJPX() && d != 1) {
                objectData = decodeColorData.dataToRGBByteArray(objectData, w, h, false);
            }
        }
        return objectData;
    }

    static void check4BitData(byte[] objectData) {
        int size = objectData.length;
        boolean is4Bit = true;
        for (byte b : objectData) {
            if (b >= 0 && b <= 15) continue;
            is4Bit = false;
            break;
        }
        if (is4Bit) {
            for (int ii = 0; ii < size; ++ii) {
                objectData[ii] = (byte)(objectData[ii] << 4);
            }
        }
    }

    private static byte[] upScaleMaskToImage(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int rgbPtr = 0;
        int i = 0;
        float ratioW = (float)maskW / (float)w;
        float ratioH = (float)maskH / (float)h;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        try {
            for (int iY = 0; iY < h; ++iY) {
                for (int iX = 0; iX < w; ++iX) {
                    for (int comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = objectData[rgbPtr];
                        }
                        ++rgbPtr;
                    }
                    int aPtr = (int)((float)iX * ratioW) + (int)((float)iY * ratioH) * w;
                    combinedData[i + 3] = maskData[aPtr];
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] upScaleImageToMask(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int aPtr = 0;
        int i = 0;
        float ratioW = (float)w / (float)maskW;
        float ratioH = (float)h / (float)maskH;
        byte[] combinedData = new byte[maskW * maskH * 4];
        int rawDataSize = objectData.length;
        int maskSize = maskData.length;
        try {
            for (int mY = 0; mY < maskH; ++mY) {
                for (int mX = 0; mX < maskW; ++mX) {
                    int rgbPtr = (int)((float)mX * ratioW) * 3 + (int)((float)mY * ratioH) * w * 3;
                    for (int comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = objectData[rgbPtr];
                        }
                        ++rgbPtr;
                    }
                    if (aPtr < maskSize) {
                        combinedData[i + 3] = maskData[aPtr];
                        ++aPtr;
                    }
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    static byte[] getSMaskData(byte[] maskData, ImageData smaskData, PdfObject newSMask, GenericColorSpace maskColorData) {
        smaskData.getFilter(newSMask);
        if (smaskData.isDCT()) {
            maskData = JPEGDecoder.getBytesFromJPEG(maskData, maskColorData, newSMask);
            newSMask.setMixedArray(1011108731, null);
            newSMask.setDecodedStream(maskData);
        } else if (smaskData.isJPX()) {
            maskData = JPeg2000ImageDecoder.getBytesFromJPEG2000(maskData, maskColorData, newSMask);
            newSMask.setMixedArray(1011108731, null);
            newSMask.setDecodedStream(maskData);
        }
        return maskData;
    }

    private static byte[] applyMaskArray(int w, int h, byte[] objectData, int[] maskArray) {
        int pixels = w * h * 4;
        int rgbPtr = 0;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        float diff = 0.0f;
        if (maskArray != null && (diff = (float)(maskArray[1] - maskArray[0])) > 1.0f) {
            diff /= 255.0f;
        }
        try {
            for (int i = 0; i < pixels; i += 4) {
                for (int comp = 0; comp < 3; ++comp) {
                    if (rgbPtr < rawDataSize) {
                        combinedData[i + comp] = diff > 0.0f ? (byte)((float)objectData[rgbPtr] * diff) : objectData[rgbPtr];
                    }
                    ++rgbPtr;
                }
                combinedData[i + 3] = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] buildUnscaledByteArray(int w, int h, byte[] objectData, byte[] maskData) {
        int pixels = w * h * 4;
        int rgbPtr = 0;
        int aPtr = 0;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        int maskSize = maskData.length;
        try {
            for (int i = 0; i < pixels; i += 4) {
                for (int comp = 0; comp < 3; ++comp) {
                    if (rgbPtr < rawDataSize) {
                        combinedData[i + comp] = objectData[rgbPtr];
                    }
                    ++rgbPtr;
                }
                if (aPtr >= maskSize) continue;
                combinedData[i + 3] = maskData[aPtr];
                ++aPtr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }
}

