/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.PDFObjectToImage;
import org.jpedal.parser.image.SMask;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class MaskUtils {
    public static void createMaskForm(PdfObject XObject2, String name, PdfObject newSMask, GraphicsState gs, DynamicVectorRenderer current, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer, boolean useTransparancy) {
        GraphicsState gs1;
        float[] BBox = XObject2.getFloatArray(303185736);
        int fx = (int)BBox[0];
        int fw = (int)BBox[2];
        int fy = (int)BBox[1];
        int fh = (int)BBox[3];
        float scaling = 4.0f;
        BufferedImage image = PDFObjectToImage.getImageFromPdfObject(XObject2, fx, fw, fy, fh, currentPdfFile, parserOptions, formLevel, multiplyer, newSMask == null && useTransparancy, 4.0f);
        if (newSMask != null) {
            BufferedImage smaskImage = PDFObjectToImage.getImageFromPdfObject(newSMask, fx, fw, fy, fh, currentPdfFile, parserOptions, formLevel, multiplyer, false, 4.0f);
            image = SMask.applySmask(image, smaskImage, true);
            if (smaskImage != null) {
                smaskImage.flush();
            }
        }
        int iw = image.getWidth() / 4;
        int ih = image.getHeight() / 4;
        boolean isChanged = false;
        if (newSMask == null && gs.getAlphaMax(2) < 1.0f) {
            isChanged = true;
            gs1 = new GraphicsState();
            gs1.setMaxAlpha(2, gs.getAlphaMax(2));
            gs1.setMaxAlpha(1, gs.getAlphaMax(1));
            current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
            current.setGraphicsState(2, gs.getAlpha(2), 1111314299);
        } else {
            gs1 = formLevel == 1 ? new GraphicsState(gs) : new GraphicsState();
        }
        gs1.CTM = new float[][]{{iw, 0.0f, 1.0f}, {0.0f, ih, 1.0f}, {0.0f, 0.0f, 0.0f}};
        if (parserOptions.isFlattenedForm()) {
            gs1.x = parserOptions.getflattenX();
            gs1.y = parserOptions.getflattenY();
        } else {
            gs1.x = fx;
            gs1.y = fy < fh ? (float)fy : (float)(fy - ih);
        }
        gs1.CTM[2][0] = gs1.x * gs.CTM[0][0] + gs.CTM[2][0];
        gs1.CTM[2][1] = gs1.y * gs.CTM[1][1] + gs.CTM[2][1];
        gs1.CTM[0][0] = gs1.CTM[0][0] * gs.CTM[0][0];
        gs1.CTM[1][1] = -gs1.CTM[1][1] * gs.CTM[1][1];
        float[] fArray = gs1.CTM[2];
        fArray[1] = fArray[1] - gs1.CTM[1][1];
        if (current.isHTMLorSVG()) {
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -3);
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -2);
        } else {
            gs1.x = gs1.CTM[2][0];
            gs1.y = gs1.CTM[2][1];
            current.drawImage(parserOptions.getPageNumber(), image, gs1, false, name, -1);
        }
        if (isChanged) {
            current.setGraphicsState(1, gs.getAlpha(1), gs.getBMValue());
            current.setGraphicsState(2, gs.getAlpha(2), gs.getBMValue());
        }
    }

    public static BufferedImage createTransparentForm(PdfObject XObject2, int fy, int fw, int fh, PdfObjectReader currentPdfFile, ParserOptions parserOptions, int formLevel, float multiplyer) {
        byte[] objectData1 = currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(currentPdfFile.getObjectReader()));
        ObjectStore localStore = new ObjectStore();
        SwingDisplay glyphDisplay = new SwingDisplay(0, false, 20, localStore);
        glyphDisplay.setHiResImageForDisplayMode(true);
        PdfStreamDecoder glyphDecoder = new PdfStreamDecoder(currentPdfFile, true, null);
        glyphDecoder.setParameters(true, true, 3, 65, false, parserOptions.useJavaFX());
        glyphDecoder.setObjectValue(-8, localStore);
        glyphDecoder.setFormLevel(formLevel);
        glyphDecoder.setMultiplyer(multiplyer);
        glyphDecoder.setRenderer(glyphDisplay);
        try {
            PdfObject SMaskResources = XObject2.getDictionary(2004251818);
            if (SMaskResources != null) {
                glyphDecoder.readResources(SMaskResources, false);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        if (objectData1 != null) {
            glyphDecoder.decodeStreamIntoObjects(objectData1, false);
        }
        int hh = fh;
        if (fy > fh) {
            hh = fy - fh;
        }
        int scaling = 4;
        BufferedImage image = new BufferedImage(4 * fw, 4 * hh, 2);
        Graphics2D formG2 = image.createGraphics();
        formG2.setColor(Color.WHITE);
        formG2.fillRect(0, 0, 4 * fw, 4 * hh);
        formG2.translate(0, 4 * hh);
        formG2.scale(1.0, -1.0);
        formG2.scale(4.0, 4.0);
        glyphDisplay.setG2(formG2);
        glyphDisplay.paint(null, null, null);
        localStore.flush();
        return image;
    }
}

