/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.parser.image.data.ImageData;

class OneBitDownSampler {
    OneBitDownSampler() {
    }

    static GenericColorSpace resetSeparationColorSpace(byte[] index, ImageData imageData, byte[] data) {
        if (index == null && imageData.getDepth() == 1) {
            imageData.setCompCount(1);
            int count = data.length;
            for (int aa = 0; aa < count; ++aa) {
                data[aa] = (byte)(data[aa] ^ 0xFF);
            }
        }
        return new DeviceRGBColorSpace();
    }

    public static GenericColorSpace downSample(int sampling, ImageData imageData, boolean imageMask, boolean arrayInverted, byte[] maskCol, byte[] index, GenericColorSpace decodeColorData) {
        byte[] data = imageData.getObjectData();
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        int size = newW * newH;
        if (imageMask) {
            size *= 4;
            maskCol[3] = -1;
        } else if (index != null) {
            size *= 3;
        }
        byte[] newData = new byte[size];
        int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int origLineLength = imageData.getWidth() + 7 >> 3;
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int ii;
                int bytes = 0;
                int count = 0;
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = imageData.getWidth() - x;
                int hGapLeft = imageData.getHeight() - y;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                for (int yy = 0; yy < hCount; ++yy) {
                    for (int xx = 0; xx < wCount; ++xx) {
                        int bit;
                        int ptr = (yy + y * sampling) * origLineLength + (x * sampling + xx >> 3);
                        byte currentByte = ptr < data.length ? data[ptr] : (byte)0;
                        if (imageMask && !arrayInverted) {
                            currentByte = (byte)(currentByte ^ 0xFF);
                        }
                        if ((bit = currentByte & flag[7 - (x * sampling + xx & 7)]) != 0) {
                            ++bytes;
                        }
                        ++count;
                    }
                }
                int offset = x + newW * y;
                if (count > 0) {
                    if (imageMask) {
                        for (ii = 0; ii < 4; ++ii) {
                            newData[offset * 4 + ii] = arrayInverted ? (byte)(255 - (maskCol[ii] & 0xFF) * bytes / count) : (byte)((maskCol[ii] & 0xFF) * bytes / count);
                        }
                        continue;
                    }
                    if (index != null && imageData.getDepth() == 1) {
                        for (int ii2 = 0; ii2 < 3; ++ii2) {
                            if (index[0] == -1 && index[1] == -1 && index[2] == -1) {
                                int av = (index[ii2] & 0xFF) + (index[ii2 + 3] & 0xFF);
                                newData[offset * 3 + ii2] = (byte)(255 - av * bytes / count);
                                continue;
                            }
                            float ratio = bytes / count;
                            newData[offset * 3 + ii2] = (double)ratio > 0.5 ? index[ii2 + 3] : index[ii2];
                        }
                        continue;
                    }
                    if (index != null) {
                        for (ii = 0; ii < 3; ++ii) {
                            newData[offset * 3 + ii] = (byte)((index[ii] & 0xFF) * bytes / count);
                        }
                        continue;
                    }
                    newData[offset] = (byte)(255 * bytes / count);
                    continue;
                }
                if (imageMask) {
                    for (ii = 0; ii < 3; ++ii) {
                        newData[offset * 4 + ii] = 0;
                    }
                    continue;
                }
                if (index != null) {
                    for (ii = 0; ii < 3; ++ii) {
                        newData[offset * 3 + ii] = 0;
                    }
                    continue;
                }
                newData[offset] = -1;
            }
        }
        data = newData;
        if (index != null) {
            imageData.setCompCount(3);
        }
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        decodeColorData.setIndex(null, 0);
        if (decodeColorData.getID() == -2073385820 || decodeColorData.getID() == 960981604) {
            decodeColorData = new DeviceRGBColorSpace();
            if (index == null && imageData.getDepth() == 1) {
                imageData.setCompCount(1);
                int count = data.length;
                for (int aa = 0; aa < count; ++aa) {
                    data[aa] = (byte)(data[aa] ^ 0xFF);
                }
            }
        }
        imageData.setObjectData(data);
        imageData.setDepth(8);
        return decodeColorData;
    }
}

