/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.MaskDataDecoder;
import org.jpedal.parser.image.data.ImageData;

class SMaskDecoder {
    SMaskDecoder() {
    }

    public static byte[] applyJPX_JBIG_Smask(ImageData imageData, ImageData smaskData, byte[] maskData, PdfObject imageObject, PdfObject maskObject, GenericColorSpace colorSpace, GenericColorSpace maskCS) {
        byte[] index;
        byte[] objectData = imageData.getObjectData();
        int iw = imageData.getWidth();
        int ih = imageData.getHeight();
        int id = imageData.getDepth();
        float[] matte = maskObject.getFloatArray(826557522);
        smaskData.getFilter(maskObject);
        if (smaskData.isDCT()) {
            maskData = JPEGDecoder.getBytesFromJPEG(maskData, maskCS, maskObject);
            maskObject.setMixedArray(1011108731, null);
            maskObject.setDecodedStream(maskData);
        } else if (smaskData.isJPX()) {
            maskData = JPeg2000ImageDecoder.getBytesFromJPEG2000(maskData, maskCS, maskObject);
            maskObject.setMixedArray(1011108731, null);
            maskObject.setDecodedStream(maskData);
        } else {
            objectData = ColorSpaceConvertor.normaliseTo8Bit(id, iw, ih, objectData);
        }
        int sw = smaskData.getWidth();
        int sh = smaskData.getHeight();
        int sd = smaskData.getDepth();
        float[] decodeArr = maskObject.getFloatArray(859785322);
        if (decodeArr != null && decodeArr[0] == 1.0f && decodeArr[1] == 0.0f) {
            int i = 0;
            while (i < maskData.length) {
                int n = i++;
                maskData[n] = (byte)(maskData[n] ^ 0xFF);
            }
        }
        if ((index = colorSpace.getIndexedMap()) != null) {
            index = colorSpace.convertIndexToRGB(index);
            objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, iw, ih, imageData.getCompCount(), id, objectData, false, false);
        } else if (!(imageData.isDCT() || imageData.isJPX() || imageData.isJBIG())) {
            if (colorSpace.getID() == 1568372915) {
                objectData = colorSpace.dataToRGBByteArray(objectData, iw, ih, false);
                if (matte != null) {
                    matte = new float[]{matte[0], matte[0], matte[0]};
                }
            } else if (colorSpace.getID() != 1008872003 && colorSpace.getID() != 1785221209) {
                objectData = colorSpace.dataToRGBByteArray(objectData, iw, ih, false);
            }
        }
        maskData = ColorSpaceConvertor.normaliseTo8Bit(sd, sw, sh, maskData);
        int imageDim = iw * ih;
        int maskDim = sw * sh;
        if (imageDim > maskDim) {
            maskData = SMaskDecoder.getScaledBytes(maskData, sw, sh, iw, ih);
        } else if (maskDim > imageDim) {
            objectData = SMaskDecoder.getScaledBytes(objectData, iw, ih, sw, sh);
            imageDim = maskDim;
            iw = sw;
            ih = sh;
        }
        int p = 0;
        ByteBuffer buffer = ByteBuffer.allocate(iw * ih * 4);
        if (imageDim == objectData.length) {
            int aa = 0;
            for (int i = 0; i < imageDim; ++i) {
                byte r = objectData[i];
                for (int j = 0; j < 3; ++j) {
                    buffer.put(r);
                }
                buffer.put(maskData[aa++]);
            }
        } else if (matte != null) {
            for (int i = 0; i < maskData.length; ++i) {
                int a = maskData[i] & 0xFF;
                int r = objectData[p++] & 0xFF;
                int g = objectData[p++] & 0xFF;
                int b = objectData[p++] & 0xFF;
                if (a != 0) {
                    double k = 255.0 / (double)a;
                    r = (int)((double)((float)r - matte[0]) * k + (double)matte[0]);
                    g = (int)((double)((float)g - matte[1]) * k + (double)matte[1]);
                    b = (int)((double)((float)b - matte[2]) * k + (double)matte[2]);
                    int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                    int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                    b = b < 0 ? 0 : (b > 255 ? 255 : b);
                }
                byte[] bb = new byte[]{(byte)r, (byte)g, (byte)b, (byte)a};
                buffer.put(bb);
            }
        } else {
            int expected = imageDim * 3;
            if (objectData.length < expected) {
                byte[] temp = new byte[expected];
                System.arraycopy(objectData, 0, temp, 0, objectData.length);
                objectData = temp;
            }
            int iter = Math.min(maskData.length, iw * ih);
            for (int i = 0; i < iter; ++i) {
                buffer.put(new byte[]{objectData[p++], objectData[p++], objectData[p++], maskData[i]});
            }
        }
        imageObject.setIntNumber(959726687, iw);
        imageObject.setIntNumber(959926393, ih);
        imageObject.setIntNumber(-1344207655, 8);
        return buffer.array();
    }

    private static byte[] getScaledBytes(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == sw * sh) {
            return SMaskDecoder.rescaleComponent(data, sw, sh, dw, dh);
        }
        int dim = sw * sh;
        byte[] rr = new byte[dim];
        byte[] gg = new byte[dim];
        byte[] bb = new byte[dim];
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            rr[i] = data[p++];
            gg[i] = data[p++];
            bb[i] = data[p++];
        }
        rr = SMaskDecoder.rescaleComponent(rr, sw, sh, dw, dh);
        gg = SMaskDecoder.rescaleComponent(gg, sw, sh, dw, dh);
        bb = SMaskDecoder.rescaleComponent(bb, sw, sh, dw, dh);
        p = 0;
        dim = dw * dh;
        byte[] temp = new byte[dim * 3];
        for (int i = 0; i < dim; ++i) {
            temp[p++] = rr[i];
            temp[p++] = gg[i];
            temp[p++] = bb[i];
        }
        return temp;
    }

    private static byte[] rescaleComponent(byte[] data, int sw, int sh, int dw, int dh) {
        if (data.length == 1) {
            byte a = data[0];
            data = new byte[dw * dh];
            Arrays.fill(data, a);
            return data;
        }
        if (sh == 1) {
            byte[] temp = new byte[2 * sw];
            System.arraycopy(data, 0, temp, 0, sw);
            System.arraycopy(data, 0, temp, sw, sw);
            sh = 2;
            data = temp;
        }
        float ratioW = (float)sw / (float)dw;
        float ratioH = (float)sh / (float)dh;
        byte[] combinedData = new byte[dw * dh];
        int rawDataSize = data.length;
        int i = 0;
        try {
            for (int mY = 0; mY < dh; ++mY) {
                for (int mX = 0; mX < dw; ++mX) {
                    int rgbPtr = (int)((float)mX * ratioW) + (int)((float)mY * ratioH) * sw;
                    if (rgbPtr < rawDataSize) {
                        combinedData[i] = data[rgbPtr];
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    static byte[] applySMask(byte[] maskData, ImageData imageData, GenericColorSpace decodeColorData, PdfObject newSMask, PdfObject XObject2) {
        byte[] objectData = imageData.getObjectData();
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        int maskW = newSMask.getInt(959726687);
        int maskH = newSMask.getInt(959926393);
        int maskD = newSMask.getInt(-1344207655);
        objectData = MaskDataDecoder.convertSmaskData(decodeColorData, objectData, w, h, imageData, d, maskD, maskData, newSMask);
        if (maskD != 8) {
            maskData = ColorSpaceConvertor.normaliseTo8Bit(maskD, maskW, maskH, maskData);
        }
        if (w == maskW && h == maskH) {
            objectData = SMaskDecoder.buildUnscaledByteArray(w, h, objectData, maskData);
        } else if (w < maskW) {
            objectData = SMaskDecoder.upScaleImageToMask(w, h, maskW, maskH, objectData, maskData);
            XObject2.setIntNumber(959726687, maskW);
            XObject2.setIntNumber(959926393, maskH);
        } else {
            objectData = SMaskDecoder.upScaleMaskToImage(w, h, maskW, maskH, objectData, maskData);
        }
        XObject2.setIntNumber(-1344207655, 8);
        return objectData;
    }

    static void check4BitData(byte[] objectData) {
        int size = objectData.length;
        boolean is4Bit = true;
        for (byte b : objectData) {
            if (b >= 0 && b <= 15) continue;
            is4Bit = false;
            break;
        }
        if (is4Bit) {
            for (int ii = 0; ii < size; ++ii) {
                objectData[ii] = (byte)(objectData[ii] << 4);
            }
        }
    }

    private static byte[] upScaleMaskToImage(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int rgbPtr = 0;
        int i = 0;
        float ratioW = (float)maskW / (float)w;
        float ratioH = (float)maskH / (float)h;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        try {
            for (int iY = 0; iY < h; ++iY) {
                for (int iX = 0; iX < w; ++iX) {
                    for (int comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = objectData[rgbPtr];
                        }
                        ++rgbPtr;
                    }
                    int aPtr = (int)((float)iX * ratioW) + (int)((float)iY * ratioH) * w;
                    combinedData[i + 3] = maskData[aPtr];
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    private static byte[] upScaleImageToMask(int w, int h, int maskW, int maskH, byte[] objectData, byte[] maskData) {
        int aPtr = 0;
        int i = 0;
        float ratioW = (float)w / (float)maskW;
        float ratioH = (float)h / (float)maskH;
        byte[] combinedData = new byte[maskW * maskH * 4];
        int rawDataSize = objectData.length;
        int maskSize = maskData.length;
        try {
            for (int mY = 0; mY < maskH; ++mY) {
                for (int mX = 0; mX < maskW; ++mX) {
                    int rgbPtr = (int)((float)mX * ratioW) * 3 + (int)((float)mY * ratioH) * w * 3;
                    for (int comp = 0; comp < 3; ++comp) {
                        if (rgbPtr < rawDataSize) {
                            combinedData[i + comp] = objectData[rgbPtr];
                        }
                        ++rgbPtr;
                    }
                    if (aPtr < maskSize) {
                        combinedData[i + 3] = maskData[aPtr];
                        ++aPtr;
                    }
                    i += 4;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }

    static byte[] getSMaskData(byte[] maskData, ImageData smaskData, PdfObject newSMask, GenericColorSpace maskColorData) {
        smaskData.getFilter(newSMask);
        if (smaskData.isDCT()) {
            maskData = JPEGDecoder.getBytesFromJPEG(maskData, maskColorData, newSMask);
            newSMask.setMixedArray(1011108731, null);
            newSMask.setDecodedStream(maskData);
        } else if (smaskData.isJPX()) {
            maskData = JPeg2000ImageDecoder.getBytesFromJPEG2000(maskData, maskColorData, newSMask);
            newSMask.setMixedArray(1011108731, null);
            newSMask.setDecodedStream(maskData);
        }
        return maskData;
    }

    private static byte[] buildUnscaledByteArray(int w, int h, byte[] objectData, byte[] maskData) {
        int pixels = w * h * 4;
        int rgbPtr = 0;
        int aPtr = 0;
        byte[] combinedData = new byte[w * h * 4];
        int rawDataSize = objectData.length;
        int maskSize = maskData.length;
        try {
            for (int i = 0; i < pixels; i += 4) {
                for (int comp = 0; comp < 3; ++comp) {
                    if (rgbPtr < rawDataSize) {
                        combinedData[i + comp] = objectData[rgbPtr];
                    }
                    ++rgbPtr;
                }
                if (aPtr >= maskSize) continue;
                combinedData[i + 3] = maskData[aPtr];
                ++aPtr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return combinedData;
    }
}

