/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

class ThreeComponentImage {
    ThreeComponentImage() {
    }

    public static BufferedImage make(int d, byte[] data, byte[] index, int w, int h) {
        BufferedImage image;
        if (d == 16) {
            int origSize = data.length;
            int newSize = origSize / 2;
            byte[] newData = new byte[newSize];
            for (int ptr = 0; ptr < newSize; ++ptr) {
                newData[ptr] = data[ptr * 2];
            }
            data = newData;
            d = 8;
        }
        LogWriter.writeLog("Converting 3 comp colorspace to sRGB index=" + Arrays.toString(index));
        if (w * h == data.length) {
            image = ThreeComponentImage.makeIndexImage(d, index, w, h, data);
        } else {
            LogWriter.writeLog("Converting data to sRGB " + data.length + " depth=" + d);
            image = ThreeComponentImage.makeImage(d, data, w, h);
        }
        return image;
    }

    static BufferedImage makeImage(int d, byte[] data, int w, int h) {
        if (d == 4) {
            data = ThreeComponentImage.expand4bitData(data, w, h);
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        data = ThreeComponentImage.checkSize(data, w, h, 3);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(data, w, h);
        image.setData(raster);
        return image;
    }

    static byte[] expand4bitData(byte[] data, int w, int h) {
        int origSize = data.length;
        int newSize = w * h * 3;
        boolean isOdd = (w & 1) == 1;
        int scanLine = w * 3 + 1 >> 1;
        byte[] newData = new byte[newSize];
        int ptr = 0;
        int currentLine = 0;
        for (int ii = 0; ii < origSize; ++ii) {
            byte rawByte = data[ii];
            ++currentLine;
            newData[ptr] = (byte)(rawByte & 0xF0);
            if (newData[ptr] == -16) {
                newData[ptr] = -1;
            }
            ++ptr;
            if (currentLine == scanLine && isOdd) {
                currentLine = 0;
            } else {
                newData[ptr] = (byte)((rawByte & 0xF) << 4);
                if (newData[ptr] == -16) {
                    newData[ptr] = -1;
                }
                ++ptr;
            }
            if (ptr != newSize) continue;
            ii = origSize;
        }
        data = newData;
        return data;
    }

    static BufferedImage makeIndexImage(int d, byte[] index, int w, int h, byte[] data) {
        BufferedImage image;
        if (d == 8 && index != null) {
            image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
        } else {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] bands = new int[]{0};
            image = new BufferedImage(w, h, 10);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
            image.setData(raster);
        }
        return image;
    }

    private static byte[] checkSize(byte[] data, int w, int h, int comp) {
        int correctSize = w * h * comp;
        if (data.length < correctSize) {
            byte[] newData = new byte[correctSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        return data;
    }
}

