/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public class XForm {
    private static final float[] matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    private static boolean hasEmptySMask(GraphicsState gs) {
        return gs.SMask != null && gs.SMask.getGeneralType(489767774) == 507461173;
    }

    public static PdfObject getSMask(float[] BBox, GraphicsState gs, PdfObjectReader currentPdfFile) {
        PdfObject newSMask = null;
        if (XForm.hasEmptySMask(gs)) {
            return null;
        }
        if (gs.SMask != null && BBox != null) {
            newSMask = gs.SMask.getDictionary(23);
            currentPdfFile.checkResolved(newSMask);
        }
        return newSMask;
    }

    public static boolean isIdentity(float[] matrix) {
        boolean isIdentity = true;
        if (matrix != null) {
            for (int ii = 0; ii < 6; ++ii) {
                if (matrix[ii] == matches[ii]) continue;
                isIdentity = false;
                break;
            }
        }
        return isIdentity;
    }

    public static Area setClip(Shape defaultClip, float[] BBox, GraphicsState gs, DynamicVectorRenderer current) {
        int h;
        int w;
        int y;
        int x;
        float scalingH;
        float scalingW = gs.CTM[0][0];
        if (scalingW == 0.0f) {
            scalingW = gs.CTM[0][1];
        }
        if ((scalingH = gs.CTM[1][1]) == 0.0f) {
            scalingH = gs.CTM[1][0];
        }
        if (scalingH < 0.0f) {
            scalingH = -scalingH;
        }
        if (gs.CTM[0][0] != 0.0f && gs.CTM[0][1] != 0.0f && gs.CTM[1][0] != 0.0f && gs.CTM[1][1] != 0.0f || gs.CTM[0][1] > 0.0f && gs.CTM[1][0] < 0.0f) {
            Object rect = new float[][]{{BBox[2], 0.0f, 0.0f}, {0.0f, BBox[3], 0.0f}, {BBox[0], BBox[1], 1.0f}};
            rect = Matrix.multiply(rect, gs.CTM);
            x = (int)rect[2][0];
            y = (int)rect[2][1];
            w = (int)(rect[0][0] + Math.abs(rect[1][0]));
            h = (int)(rect[1][1] + Math.abs(rect[0][1]));
            if (rect[1][0] < 0.0f) {
                x = (int)((float)x + rect[1][0]);
            }
        } else if (gs.CTM[0][1] < 0.0f && gs.CTM[1][0] > 0.0f) {
            x = (int)(gs.CTM[2][0] + BBox[1] * scalingW);
            y = (int)(gs.CTM[2][1] - BBox[2] * scalingH);
            w = (int)((BBox[3] - BBox[1]) * -scalingW);
            h = (int)Math.abs((BBox[2] - BBox[0]) * -scalingH);
        } else {
            int pw = (int)Math.abs(BBox[2] - BBox[0]);
            int ph = (int)Math.abs(BBox[3] - BBox[1]);
            int px = (int)Math.min(BBox[0], BBox[2]);
            int py = (int)Math.min(BBox[1], BBox[3]);
            Rectangle properRect = new Rectangle(px, py, pw, ph);
            Area properArea = new Area(properRect);
            AffineTransform affine = new AffineTransform(gs.CTM[0][0], gs.CTM[0][1], gs.CTM[1][0], gs.CTM[1][1], gs.CTM[2][0], gs.CTM[2][1]);
            properArea = properArea.createTransformedArea(affine);
            properRect = properArea.getBounds();
            x = (int)properRect.getX();
            y = (int)properRect.getY();
            w = (int)properRect.getWidth();
            h = (int)properRect.getHeight();
        }
        Area clip = gs.getClippingShape() == null ? null : (Area)gs.getClippingShape().clone();
        Area newClip = new Area(new Rectangle(x, y, w, h));
        gs.updateClip(new Area(newClip));
        current.drawClip(gs, defaultClip, false);
        return clip;
    }
}

