/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;

public class BlankMaskToImage {
    public static boolean convert(byte[] objectData, ImageData imageData, GenericColorSpace decodeColorData, PdfObject newSMask, PdfObjectReader currentPdfFile) throws PdfException {
        newSMask.setFloatArray(859785322, new float[]{1.0f, 0.0f});
        PdfArrayIterator Filters = newSMask.getMixedArray(1011108731);
        boolean isMaskJPX = false;
        if (Filters != null && Filters.hasMoreTokens()) {
            while (Filters.hasMoreTokens()) {
                int firstValue = Filters.getNextValueAsConstant(true);
                isMaskJPX = firstValue == 1399277700;
            }
        }
        byte[] objData = currentPdfFile.readStream(newSMask, true, true, false, false, false, null);
        imageData.setObjectData(objData);
        imageData.setDepth(1);
        imageData.setWidth(newSMask.getInt(959726687));
        imageData.setHeight(newSMask.getInt(959926393));
        int newDepth = newSMask.getInt(-1344207655);
        if (isMaskJPX) {
            BufferedImage img = decodeColorData.JPEG2000ToRGBImage(imageData.getObjectData(), imageData.getWidth(), imageData.getHeight(), null, -1, -1, 8);
            img = ColorSpaceConvertor.convertColorspace(img, 10);
            objData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            imageData.setObjectData(objData);
            boolean isEmptyMask = true;
            for (byte b : objectData) {
                if (b == 0) continue;
                isEmptyMask = false;
                break;
            }
            if (isEmptyMask) {
                imageData.setObjectData(null);
            }
            newSMask.setMixedArray(1011108731, null);
        }
        if (newDepth != -1) {
            imageData.setDepth(newDepth);
        }
        return objData == null;
    }
}

