/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.geom.GeneralPath;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;

public class ConvertMaskToShape {
    public static void convert(GraphicsState gs, DynamicVectorRenderer current, ParserOptions parserOptions) {
        float iw;
        float ix = gs.CTM[2][0];
        float iy = gs.CTM[2][1];
        float ih = gs.CTM[1][1];
        if (ih == 0.0f) {
            ih = gs.CTM[1][0];
        }
        if (ih < 0.0f) {
            iy += ih;
            ih = -ih;
        }
        if ((iw = gs.CTM[0][0]) == 0.0f) {
            iw = gs.CTM[0][1];
        }
        if (iw < 0.0f) {
            ix += iw;
            iw = -iw;
        }
        if (gs.CTM[0][0] == 0.0f && gs.CTM[0][1] > 0.0f && gs.CTM[1][0] != 0.0f && gs.CTM[1][1] == 0.0f) {
            float tmp = ih;
            ih = iw;
            iw = tmp;
        }
        if (iw < 1.0f) {
            iw = 1.0f;
        }
        if (ih < 1.0f) {
            ih = 1.0f;
        }
        int lwidth = -1;
        if (ih < 3.0f) {
            lwidth = (int)ih;
            ih = 1.0f;
        } else if (iw < 3.0f) {
            lwidth = (int)iw;
            iw = 1.0f;
        }
        GeneralPath currentShape = new GeneralPath(1);
        currentShape.moveTo(ix, iy);
        currentShape.lineTo(ix, iy + ih);
        currentShape.lineTo(ix + iw, iy + ih);
        currentShape.lineTo(ix + iw, iy);
        currentShape.closePath();
        if (parserOptions.isRenderPage() && currentShape != null) {
            float lastLineWidth = gs.getLineWidth();
            if (lwidth > 0) {
                gs.setLineWidth(lwidth);
            }
            gs.setNonstrokeColor(gs.nonstrokeColorSpace.getColor());
            gs.setFillType(2);
            current.drawShape(currentShape, gs, 70);
            if (lwidth > 0) {
                gs.setLineWidth(lastLineWidth);
            }
        }
    }
}

