/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.image.BufferedImage;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ErrorTracker;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public class JPegImageDecoder {
    public static BufferedImage decode(String name, int w, int h, boolean arrayInverted, GenericColorSpace decodeColorData, byte[] data, float[] decodeArray, ImageData imageData, PdfObject XObject2, ErrorTracker errorTracker, ParserOptions parserOptions) {
        GenericColorSpace jpegDecodeColorData = decodeColorData;
        BufferedImage image = null;
        LogWriter.writeLog("JPeg Image " + name + ' ' + w + "W * " + h + 'H' + " arrayInverted=" + arrayInverted);
        boolean decodedOnAltColorspace = false;
        if (decodeColorData.getID() == 1247168582) {
            int alt = decodeColorData.getAlternateColorSpace();
            GenericColorSpace altDecodeColorData = null;
            if (alt == 1785221209) {
                altDecodeColorData = new DeviceRGBColorSpace();
            } else if (alt == 1498837125) {
                altDecodeColorData = new DeviceCMYKColorSpace();
            }
            if (altDecodeColorData != null) {
                try {
                    image = altDecodeColorData.JPEGToRGBImage(data, w, h, decodeArray, imageData.getpX(), imageData.getpY(), arrayInverted, XObject2);
                    if (image != null) {
                        decodedOnAltColorspace = true;
                        jpegDecodeColorData = altDecodeColorData;
                        if (jpegDecodeColorData.isImageYCCK()) {
                            parserOptions.hasYCCKimages = true;
                        }
                    }
                }
                catch (Exception e) {
                    errorTracker.addPageFailureMessage("Unable to use alt colorspace with " + name + " to JPEG");
                    LogWriter.writeLog("Exception: " + e.getMessage());
                    if (image != null) {
                        image.flush();
                    }
                    image = null;
                }
            }
        }
        if (!decodedOnAltColorspace) {
            try {
                image = jpegDecodeColorData.JPEGToRGBImage(data, w, h, decodeArray, imageData.getpX(), imageData.getpY(), arrayInverted, XObject2);
                if (jpegDecodeColorData.isImageYCCK()) {
                    parserOptions.hasYCCKimages = true;
                }
            }
            catch (Exception e) {
                errorTracker.addPageFailureMessage("Problem converting " + name + " to JPEG");
                LogWriter.writeLog("Exception: " + e.getMessage());
                image.flush();
                image = null;
            }
        }
        return image;
    }
}

