/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;

public class PDFtoImageConvertorSwing
extends PDFtoImageConvertor {
    public PDFtoImageConvertorSwing(float multiplyer, DecoderOptions options) {
        super(multiplyer, options);
    }

    @Override
    public DynamicVectorRenderer getDisplay(int pageIndex, ObjectStore localStore, boolean isTransparent) {
        this.imageDisplay = new ImageDisplay(pageIndex, !isTransparent, 5000, localStore);
        return this.imageDisplay;
    }

    public static AffineTransform setPageParametersForImage(float scaling, int pageNumber, PdfPageData pageData) {
        AffineTransform imageScaling = new AffineTransform();
        int crw = pageData.getCropBoxWidth(pageNumber);
        int crh = pageData.getCropBoxHeight(pageNumber);
        int crx = pageData.getCropBoxX(pageNumber);
        int cry = pageData.getCropBoxY(pageNumber);
        int image_x_size = (int)((float)crw * scaling);
        int image_y_size = (int)((float)crh * scaling);
        int raw_rotation = pageData.getRotation(pageNumber);
        imageScaling.translate((float)(-crx) * scaling, (float)cry * scaling);
        if (raw_rotation == 270) {
            imageScaling.rotate(-1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate((double)image_y_size - y_change, -x_change);
            if (cry < 0) {
                imageScaling.translate((float)(2 * cry) * scaling, (float)(2 * cry) * scaling);
            } else {
                imageScaling.translate((float)(2 * cry) * scaling, 0.0);
            }
            imageScaling.translate(0.0, -scaling * (float)(pageData.getCropBoxHeight(pageNumber) - pageData.getMediaBoxHeight(pageNumber)));
        } else if (raw_rotation == 180) {
            imageScaling.rotate(Math.PI, image_x_size / 2, image_y_size / 2);
        } else if (raw_rotation == 90) {
            imageScaling.rotate(1.5707963267948966, image_x_size / 2, image_y_size / 2);
            double x_change = imageScaling.getTranslateX();
            double y_change = imageScaling.getTranslateY();
            imageScaling.translate(-y_change, (double)image_x_size - x_change);
        }
        imageScaling.translate(image_x_size, image_y_size);
        imageScaling.scale(1.0, -1.0);
        imageScaling.translate(-image_x_size, 0.0);
        imageScaling.scale(scaling, scaling);
        return imageScaling;
    }

    @Override
    public BufferedImage pageToImage(boolean imageIsTransparent, PdfStreamDecoder currentImageDecoder, float scaling, PdfObject pdfObject, AcroRenderer formRenderer) throws PdfException {
        BufferedImage image = new BufferedImage(this.w, this.h, 2);
        Graphics graphics = image.getGraphics();
        Graphics2D g2 = (Graphics2D)graphics;
        if (!imageIsTransparent) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.w, this.h);
        }
        if (this.rotation == 180) {
            g2.translate(this.crx * 2.0f * this.multiplyer, -(this.cry * 2.0f * this.multiplyer));
        }
        this.imageDisplay.setScalingValues(this.crx * this.multiplyer, this.crh * this.multiplyer + this.cry, this.multiplyer * scaling);
        g2.setRenderingHints(ColorSpaces.hints);
        g2.transform(this.imageScaling);
        if (this.rotated) {
            if (this.rotation == 90) {
                if (this.multiplyer < 1.0f) {
                    this.cry = (int)(this.imageScaling.getTranslateX() + (double)this.cry);
                    this.crx = (int)(this.imageScaling.getTranslateY() + (double)this.crx);
                } else {
                    this.cry = (int)(this.imageScaling.getTranslateX() / (double)this.multiplyer + (double)this.cry);
                    this.crx = (int)(this.imageScaling.getTranslateY() / (double)this.multiplyer + (double)this.crx);
                }
                this.crx /= scaling;
                this.cry /= scaling;
                g2.translate(-this.crx, -this.cry);
            } else if (this.cry < 0.0f) {
                g2.translate(-(this.crx / scaling), ((float)this.mediaH - this.crh + this.cry) / scaling);
            } else {
                g2.translate(-(this.crx / scaling), ((float)this.mediaH - this.crh - this.cry) / scaling);
            }
        }
        currentImageDecoder.setObjectValue(-7, g2);
        this.imageDisplay.setG2(g2);
        currentImageDecoder.decodePageContent(pdfObject);
        g2.setClip(null);
        return image;
    }
}

