/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.UnrendererGlyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.CIDTextUtils;
import org.jpedal.parser.text.CharReader;
import org.jpedal.parser.text.EscapedTextUtils;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.HexTextUtils;
import org.jpedal.parser.text.JavaTextRenderer;
import org.jpedal.parser.text.Leading;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class Tj
extends BaseDecoder {
    public static boolean showInvisibleText;
    private PdfData pdfData;
    private PdfFont currentFontData;
    private final Vector_Rectangle_Int textAreas;
    private final Vector_Int textDirections;
    private TextState currentTextState = new TextState();
    private final GlyphData glyphData = new GlyphData();
    private GlyphTracker customGlyphTracker;
    private StructuredContentHandler contentHandler;
    private boolean ttHintingRequired;
    private String tjTextValue = "";
    static final String[] hex;
    private float charSpacing;
    private final GlyphFactory factory;
    private PdfJavaGlyphs glyphs;
    private float[][] Trm;
    private boolean returnText;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float lastWidth;
    private float currentWidth;
    private String actualText;
    private final DynamicVectorRenderer current;
    private int streamLength;
    private float[][] TrmBeforeSpace = new float[3][3];
    private boolean isTabRemapped;
    private boolean isCRRemapped;
    private boolean isReturnRemapped;
    private final ErrorTracker errorTracker;

    public Tj(ParserOptions parserOptions, PdfData pdfData, boolean isXMLExtraction, Vector_Rectangle_Int textAreas, Vector_Int textDirections, DynamicVectorRenderer current, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.pdfData = pdfData;
        this.glyphData.setXMLExtraction(isXMLExtraction);
        this.textAreas = textAreas;
        this.textDirections = textDirections;
        this.current = current;
        this.errorTracker = errorTracker;
        this.factory = new T1GlyphFactory(parserOptions.useJavaFX());
    }

    public Tj(ParserOptions parserOptions, Vector_Rectangle_Int textAreas, Vector_Int textDirections, DynamicVectorRenderer current, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.factory = new T1GlyphFactory(parserOptions.useJavaFX());
        this.textAreas = textAreas;
        this.textDirections = textDirections;
        this.current = current;
        this.errorTracker = errorTracker;
    }

    private void calcCoordinates(float x, float[][] Trm, float charSpacing) {
        float[][] trm = new float[3][3];
        for (int xx = 0; xx < 3; ++xx) {
            System.arraycopy(Trm[xx], 0, trm[xx], 0, 3);
        }
        this.x1 = x;
        this.x2 = trm[2][0] - charSpacing * trm[0][0];
        if (this.glyphData.isHorizontal()) {
            if (trm[1][0] < 0.0f) {
                this.x1 = x + trm[1][0] - charSpacing * trm[0][0];
                this.x2 = trm[2][0];
            } else if (trm[1][0] > 0.0f) {
                this.x1 = x;
                this.x2 = trm[2][0];
            }
        } else if (trm[1][0] > 0.0f) {
            this.x1 = trm[2][0];
            this.x2 = x + trm[1][0] - charSpacing * trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            this.x2 = trm[2][0];
            this.x1 = x + trm[1][0] - charSpacing * trm[0][0];
        }
    }

    public String TJ(TextState currentTextState, PdfFont currentFontData, byte[] characterStream, int startCommand, int dataPointer, boolean multipleTJs) {
        this.currentTextState = currentTextState;
        this.currentFontData = currentFontData;
        this.customGlyphTracker = this.parserOptions.getCustomGlyphTracker();
        this.contentHandler = this.parserOptions.getContentHandler();
        this.isTabRemapped = currentFontData.getDiffMapping(9) != null;
        this.isCRRemapped = currentFontData.getDiffMapping(10) != null;
        this.isReturnRemapped = currentFontData.getDiffMapping(13) != null;
        this.streamLength = characterStream.length;
        this.glyphs = currentFontData.getGlyphData();
        if (this.parserOptions.isRenderText() && this.gs.getTextRenderType() != 4) {
            this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
        }
        StringBuffer current_value = this.processTextArray(characterStream, startCommand, dataPointer, this.multiplyer, multipleTJs);
        int fontSize = this.glyphData.getFontSize();
        if (fontSize == 0) {
            fontSize = (int)currentTextState.getTfs();
        }
        if (fontSize < 0) {
            fontSize = -fontSize;
        }
        if (current_value != null && this.parserOptions.isPageContent()) {
            String currentColor = null;
            if (this.parserOptions.isTextColorExtracted()) {
                currentColor = (this.gs.getTextRenderType() & 2) == 2 ? this.gs.nonstrokeColorSpace.getXMLColorToken() : this.gs.strokeColorSpace.getXMLColorToken();
            }
            if (this.contentHandler != null) {
                this.contentHandler.setText(current_value, this.x1, this.y1, this.x2, this.y2);
            } else if (this.parserOptions.isTextExtracted()) {
                this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, currentTextState.writingMode, Fonts.createFontToken(currentFontData.getFontName(), fontSize), currentFontData.getCurrentFontSpaceWidth(), fontSize, this.x1, this.y1, this.x2, this.y2, current_value, this.glyphData.getTextLength(), currentColor, this.glyphData.isXMLExtraction());
            }
        }
        return this.tjTextValue;
    }

    private void resetValues(GlyphData glyphData) {
        glyphData.reset();
        this.TrmBeforeSpace = new float[3][3];
        this.lastWidth = 0.0f;
        this.currentWidth = 0.0f;
        this.Trm = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
    }

    private StringBuffer processTextArray(byte[] stream, int startCommand, int dataPointer, float multiplyer, boolean multipleTJs) {
        float TFS;
        this.glyphData.setText(false);
        this.isHTML = this.current.isHTMLorSVG();
        this.resetValues(this.glyphData);
        boolean widthIsVertical = this.currentFontData.isWidthVertical();
        int Tmode = this.gs.getTextRenderType();
        boolean hasContent = false;
        boolean isMultiple = false;
        char lastTextChar = 'x';
        float rawTFS = TFS = this.currentTextState.getTfs();
        if (TFS < 0.0f) {
            TFS = -TFS;
        }
        int type = this.currentFontData.getFontType();
        float spaceWidth = this.currentFontData.getCurrentFontSpaceWidth();
        StringBuffer textData = null;
        if (this.parserOptions.isTextExtracted()) {
            textData = new StringBuffer(50);
        }
        boolean isTextShifted = false;
        while (stream[startCommand] == 91 || stream[startCommand] == 10 || stream[startCommand] == 13 || stream[startCommand] == 32) {
            if (stream[startCommand] == 91) {
                isMultiple = true;
            }
            ++startCommand;
        }
        this.glyphData.setDefaultCharSize(this.currentFontData);
        this.charSpacing = this.currentTextState.getCharacterSpacing() / TFS;
        float wordSpacing = this.currentTextState.getWordSpacing() / TFS;
        if (multipleTJs) {
            this.Trm[2][0] = this.currentTextState.Tm[2][0];
            this.Trm[2][1] = this.currentTextState.Tm[2][1];
        }
        float[][] temp = new float[3][3];
        temp[0][0] = rawTFS * this.currentTextState.getHorizontalScaling();
        temp[1][1] = rawTFS;
        temp[2][1] = this.currentTextState.getTextRise();
        temp[2][2] = 1.0f;
        this.Trm = Matrix.multiply(temp, this.Trm);
        if (isMultiple && stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93) {
            float offset = 0.0f;
            while (stream[startCommand] != 40 && stream[startCommand] != 60 && stream[startCommand] != 93) {
                StringBuilder kerning = new StringBuilder(10);
                while (stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93 && stream[startCommand] != 32) {
                    kerning.append((char)stream[startCommand]);
                    ++startCommand;
                }
                offset += Float.parseFloat(kerning.toString());
                while (stream[startCommand] == 32) {
                    ++startCommand;
                }
            }
            if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] != 0.0f && this.Trm[1][0] != 0.0f) {
                offset = this.Trm[0][1] * offset / 1000.0f;
                float[] fArray = this.Trm[2];
                fArray[1] = fArray[1] - offset;
            } else {
                offset = this.Trm[0][0] * offset / 1000.0f;
                float[] fArray = this.Trm[2];
                fArray[0] = fArray[0] - offset;
            }
        }
        int fontSize = Tj.calcFontSize(this.glyphData, this.currentTextState, this.Trm);
        Font javaFont = null;
        int textPrint = this.parserOptions.getTextPrint();
        if (textPrint == 3 && StandardFonts.isStandardFont(this.currentFontData.getFontName(), true) && this.parserOptions.isPrinting()) {
            javaFont = this.currentFontData.getJavaFontX(fontSize);
        } else if (this.currentFontData.isFontEmbedded && !this.currentFontData.isFontSubstituted()) {
            javaFont = null;
        } else if ((PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts || textPrint != 0) && this.parserOptions.isPrinting()) {
            javaFont = this.currentFontData.getJavaFontX(fontSize);
        }
        float x = this.Trm[2][0];
        if (this.Trm[1][0] < 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][0] == 0.0f) {
            isTextShifted = true;
        }
        int i = startCommand;
        StringBuffer buff = null;
        if (this.returnText) {
            buff = new StringBuffer(this.streamLength);
        }
        boolean resetCoords = true;
        boolean isCID = this.currentFontData.isCIDFont();
        while (i < dataPointer) {
            this.glyphData.setActualWidth(-1.0f);
            i = CharReader.getNextValue(i, stream, this.glyphData, isCID);
            if (this.glyphData.isText()) {
                int idx;
                lastTextChar = this.glyphData.getRawChar();
                if (this.glyphData.getOpenChar() == '<') {
                    i = isCID && !this.currentFontData.isFontSubstituted() && this.currentFontData.isFontEmbedded && stream[i] != 48 ? HexTextUtils.getHexCIDValue(stream, i, this.glyphData, this.currentFontData, this.parserOptions) : HexTextUtils.getHexValue(stream, i, this.glyphData, this.currentFontData, this.parserOptions);
                } else if (lastTextChar == '\\' && !isCID) {
                    i = EscapedTextUtils.getEscapedValue(i, stream, this.glyphData, this.currentFontData, this.streamLength, this.parserOptions, this.current);
                } else if (isCID) {
                    i = CIDTextUtils.getCIDCharValues(i, stream, this.streamLength, this.glyphData, this.currentFontData, this.parserOptions);
                } else {
                    lastTextChar = Tj.getValue(lastTextChar, this.glyphData, this.currentFontData, this.current);
                }
                if (this.isHTML && !this.currentFontData.hasToUnicode() && this.currentFontData.getFontType() == -1684566726 && this.currentFontData.getGlyphData().isIdentity()) {
                    int charToUse = this.glyphData.getRawChar();
                    int valueForHTML = this.glyphData.getValueForHTML();
                    if (valueForHTML != -1) {
                        charToUse = valueForHTML;
                        this.glyphData.setValueForHTML(-1);
                    }
                    int rawC = StandardFonts.mapCIDToValidUnicode(this.currentFontData.getBaseFontName(), charToUse);
                    this.glyphData.setUnicodeValue(String.valueOf((char)rawC));
                }
                if (!this.isTabRemapped && this.glyphData.getRawInt() == 9 && this.currentFontData.isFontSubstituted()) {
                    this.glyphData.setRawInt(32);
                    this.glyphData.set(" ");
                }
                temp[0][0] = 1.0f;
                temp[0][1] = 0.0f;
                temp[0][2] = 0.0f;
                temp[1][0] = 0.0f;
                temp[1][1] = 1.0f;
                temp[1][2] = 0.0f;
                if (this.currentFontData.isFontVertical()) {
                    temp[2][1] = -(this.currentWidth + this.glyphData.getLeading());
                    temp[2][0] = 0.0f;
                } else {
                    temp[2][0] = this.currentWidth + this.glyphData.getLeading();
                    temp[2][1] = 0.0f;
                }
                temp[2][2] = 1.0f;
                this.Trm = Matrix.multiply(temp, this.Trm);
                if (this.glyphData.getRawChar() == ' ' && this.glyphData.getLastChar() != ' ') {
                    this.TrmBeforeSpace = this.Trm;
                }
                this.glyphData.setLeading(0.0f);
                float actualWidth = this.glyphData.getActualWidth();
                if (this.currentFontData.isCIDFont() && (idx = this.glyphs.getCMAPValue(this.glyphData.getRawInt())) > 0) {
                    if (this.glyphs.is1C() && !this.glyphs.isIdentity()) {
                        this.glyphData.setRawInt(idx);
                    }
                    actualWidth = this.currentFontData.getWidth(idx);
                }
                idx = this.glyphData.getRawInt();
                if (!this.glyphs.isCorrupted()) {
                    int diff;
                    if (this.currentFontData.isCIDFont() && !this.glyphs.isIdentity() && !this.glyphs.hasGIDtoCID()) {
                        int mappedIdx = this.glyphs.getConvertedGlyph(idx);
                        if (mappedIdx != -1) {
                            idx = mappedIdx;
                        }
                    } else if (this.currentFontData.getFontType() == 1228944677 && (diff = this.currentFontData.getDiffChar(idx)) > 0) {
                        this.glyphData.setRawInt(diff);
                    }
                }
                this.currentWidth = actualWidth > 0.0f ? actualWidth : this.currentFontData.getWidth(idx);
                if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
                    Float value = StandardFonts.getStandardWidth("Arial", this.currentFontData.getMappedChar(this.glyphData.getRawInt(), false));
                    this.currentWidth = value != null ? value.floatValue() : 0.0f;
                    this.currentFontData.setLastWidth(this.currentWidth);
                }
                if (this.isHTML && !this.currentFontData.isFontSubsetted() && this.currentFontData.getFontEncoding(true) == 2 && this.glyphData.getUnicodeValue().charAt(0) - idx == 32) {
                    this.glyphData.setUnicodeValue(String.valueOf((char)idx));
                }
                if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
                    int rawInt = this.glyphData.getRawInt();
                    String glyfName = rawInt > 255 ? String.valueOf(rawInt) : StandardFonts.getUnicodeChar(2, rawInt);
                    this.currentWidth = this.currentFontData.getGlyphWidth(glyfName, rawInt, this.glyphData.getDisplayValue());
                }
                if (this.returnText) {
                    buff.append(this.glyphData.getDisplayValue());
                }
                this.currentTextState.setLastKerningAdded(this.glyphData.getSpacingAdded());
                this.glyphData.setSpacingAdded(0.0f);
                if (this.parserOptions.isRenderText() && (Tmode != 4 || this.isHTML) || Tmode == 7 && this.parserOptions.isRenderClipText()) {
                    if (javaFont != null && this.parserOptions.isPrinting() && (textPrint == 3 || textPrint == 2 || PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                        if (Tmode == 7) {
                            boolean isSTD = DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
                            Area transformedGlyph2 = this.glyphs.getStandardGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.currentWidth, isSTD);
                            if (transformedGlyph2 != null) {
                                this.gs.addClip(transformedGlyph2);
                            }
                            this.current.drawClip(this.gs, null, true);
                        }
                        if (this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            if (this.isHTML || this.current.getType() == 7) {
                                this.current.drawEmbeddedText(this.Trm, fontSize, null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                            } else {
                                this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], javaFont);
                            }
                        }
                    } else if (!((textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded && this.currentFontData.isFontSubstituted() && (this.glyphData.getRawInt() == 9 && !this.isTabRemapped || this.glyphData.getRawInt() == 10 && !this.isCRRemapped || this.glyphData.getRawInt() == 13 && !this.isReturnRemapped) || (textPrint != 1 || javaFont == null) && this.currentFontData.isFontSubstituted() && this.currentWidth == 0.0f && this.glyphData.getDisplayValue().charAt(0) == '\r')) {
                        if ((textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded) {
                            this.renderText(this.currentWidth, type, Tmode, multiplyer, isTextShifted);
                        } else if (!this.glyphData.getDisplayValue().isEmpty() && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            JavaTextRenderer.renderTextWithJavaFonts(this.gs, this.current, this.streamType, this.parserOptions, this.currentFontData, this.glyphData, Tmode, this.currentWidth, isTextShifted, this.glyphs, this.Trm);
                        }
                    }
                }
                this.currentWidth += this.charSpacing;
                if (this.glyphData.getRawChar() == ' ') {
                    this.currentWidth += wordSpacing;
                }
                float currentGap = this.glyphData.getWidth() + this.charSpacing - this.lastWidth;
                String spaces = "";
                if (currentGap > 0.0f && this.lastWidth > 0.0f) {
                    spaces = PdfFont.getSpaces(currentGap, spaceWidth, 0.595f);
                }
                this.glyphData.addToWidth(this.currentWidth);
                this.lastWidth = this.glyphData.getWidth();
                if (this.customGlyphTracker != null) {
                    this.customGlyphTracker.addGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.glyphData.getUnicodeValue());
                }
                if (this.parserOptions.isTextExtracted()) {
                    hasContent = Tj.writeOutText(this.glyphData, this.Trm, hasContent, this.currentWidth, textData, spaces);
                }
            } else if (this.glyphData.getRawChar() == '(' || this.glyphData.getRawChar() == '<') {
                this.glyphData.setText(true);
                this.glyphData.setOpenChar(this.glyphData.getRawChar());
            } else if (this.glyphData.getRawChar() == ')' || this.glyphData.getRawChar() == '>' && this.glyphData.getOpenChar() == '<' || !this.glyphData.isText() && (this.glyphData.getRawChar() == '-' || this.glyphData.getRawChar() >= '0' && this.glyphData.getRawChar() <= '9')) {
                i = Leading.readLeading(i, stream, this.glyphData);
            }
            if (this.parserOptions.isTextExtracted()) {
                resetCoords = this.setExtractedText(this.currentWidth, resetCoords);
            }
            ++i;
        }
        if (this.returnText) {
            this.tjTextValue = !this.tjTextValue.isEmpty() ? this.tjTextValue + ' ' + buff.toString() : buff.toString();
        }
        this.Trm = Tj.updateMatrixPosition(widthIsVertical, this.Trm, this.glyphData.getLeading(), this.currentWidth, this.currentTextState);
        if (this.parserOptions.isTextExtracted()) {
            return this.setExtractedText(lastTextChar, x, textData, hasContent);
        }
        return null;
    }

    static float[][] updateMatrixPosition(boolean widthIsVertical, float[][] Trm, float leading, float currentWidth, TextState currentTextState) {
        float[][] temp = new float[3][3];
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = leading < 0.0f ? currentWidth : currentWidth + leading;
        temp[2][1] = 0.0f;
        if (widthIsVertical) {
            float tmp = temp[2][0];
            temp[2][0] = temp[2][1];
            temp[2][1] = tmp;
        }
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        currentTextState.Tm[2][0] = Trm[2][0];
        currentTextState.Tm[2][1] = Trm[2][1] - currentTextState.getTextRise();
        return Trm;
    }

    private StringBuffer setExtractedText(char lastTextChar, float x, StringBuffer textData, boolean hasContent) {
        if (lastTextChar == ' ') {
            this.Trm = this.TrmBeforeSpace;
        }
        this.calcCoordinates(x, this.Trm, this.charSpacing);
        if (textData != null && this.actualText != null) {
            int startValue = textData.indexOf(PdfData.marker, 2);
            if (startValue > 0) {
                startValue = textData.indexOf(PdfData.marker, startValue + 1);
            }
            if (startValue > 0) {
                textData.setLength(startValue + 1);
                textData.append(this.actualText);
            }
            this.actualText = null;
        }
        if (textData.length() == 0 || !hasContent) {
            textData = null;
        }
        return textData;
    }

    private void renderText(float currentWidth, int type, int Tmode, float multiplyer, boolean isTextShifted) throws RuntimeException {
        String charGlyph = "notdef";
        int rawInt = this.glyphData.getRawInt();
        try {
            PdfGlyph glyph;
            if (!this.currentFontData.isCIDFont()) {
                charGlyph = this.currentFontData.getMappedChar(rawInt, false);
            }
            if (this.parserOptions.generateGlyphOnRender() && !this.parserOptions.renderDirectly()) {
                if (this.glyphData.isfirstTime()) {
                    glyph = new MarkerGlyph(this.Trm[0][0], this.Trm[0][1], this.Trm[1][0], this.Trm[1][1], this.currentFontData.getBaseFontName());
                    this.current.checkFontSaved(glyph, this.currentFontData.getBaseFontName(), this.currentFontData);
                    this.glyphData.setFirstTime(false);
                }
                this.currentFontData.setValuesForGlyph(rawInt, charGlyph, this.glyphData.getDisplayValue(), this.currentFontData.getEmbeddedChar(rawInt));
                glyph = new UnrendererGlyph(this.Trm[2][0], this.Trm[2][1], rawInt, currentWidth);
            } else {
                glyph = this.glyphs.getEmbeddedGlyph(this.factory, charGlyph, this.Trm, rawInt, this.glyphData.getDisplayValue(), currentWidth, this.currentFontData.getEmbeddedChar(rawInt));
                if (glyph instanceof TTGlyph) {
                    if (glyph.containsBrokenData()) {
                        if (this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            if (this.current.isHTMLorSVG()) {
                                this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                            } else {
                                this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], this.currentFontData.getJavaFontX(this.glyphData.getFontSize()));
                            }
                        }
                        glyph = null;
                    } else {
                        boolean bl = this.ttHintingRequired = this.ttHintingRequired || ((TTGlyph)glyph).isTTHintingRequired();
                    }
                }
            }
            if (type == 1228944679) {
                if (glyph != null && glyph.getmaxWidth() == 0.0f) {
                    glyph = null;
                } else if (glyph != null && glyph.ignoreColors()) {
                    glyph.setT3Colors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor(), true);
                }
            }
            if (glyph != null || this.isHTML) {
                if (glyph != null && type == 1228944677) {
                    glyph.setWidth(currentWidth * 1000.0f);
                }
                Object finalTrm = new float[][]{{this.Trm[0][0], this.Trm[0][1], 0.0f}, {this.Trm[1][0], this.Trm[1][1], 0.0f}, {this.Trm[2][0], this.Trm[2][1], 1.0f}};
                float[][] finalScale = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                finalTrm = Matrix.multiply(finalTrm, finalScale);
                finalTrm[2][0] = this.Trm[2][0];
                finalTrm[2][1] = this.Trm[2][1];
                if (finalTrm[1][0] < 0.0f && finalTrm[0][1] < 0.0f) {
                    finalTrm[1][0] = -finalTrm[1][0];
                    finalTrm[0][1] = -finalTrm[0][1];
                }
                AffineTransform at = new AffineTransform(finalTrm[0][0], finalTrm[0][1], finalTrm[1][0], finalTrm[1][1], finalTrm[2][0], finalTrm[2][1]);
                int fontType = 5;
                if (type == 6) {
                    fontType = 5;
                    float z = 1000.0f / glyph.getmaxWidth();
                    at.scale(currentWidth * z, 1.0);
                } else if (type == 1217103210 || type == -1684566724 || this.currentFontData.isFontSubstituted() && type != 1228944677) {
                    fontType = 4;
                } else if (type == 1228944679) {
                    fontType = 6;
                }
                if (this.parserOptions.generateGlyphOnRender()) {
                    fontType = -fontType;
                }
                if (Tmode == 7) {
                    if (glyph != null && !this.parserOptions.useJavaFX() && glyph.getShape() != null) {
                        Area glyphShape = (Area)glyph.getShape().clone();
                        if (TTGlyph.useHinting && glyph instanceof TTGlyph) {
                            glyphShape.transform(AffineTransform.getScaleInstance(0.01, 0.01));
                        }
                        glyphShape.transform(at);
                        if (glyphShape.getBounds().getWidth() > 0.0 && glyphShape.getBounds().getHeight() > 0.0) {
                            this.gs.addClip(glyphShape);
                        }
                    }
                } else {
                    float lw = this.gs.getLineWidth();
                    float lineWidth = 0.0f;
                    if (multiplyer > 0.0f) {
                        lineWidth = lw / multiplyer;
                    }
                    double[] textTrans = new double[6];
                    at.getMatrix(textTrans);
                    this.gs.setLineWidth((float)((double)lineWidth / textTrans[0]));
                    if (isTextShifted) {
                        this.current.drawEmbeddedText(this.Trm, -this.glyphData.getFontSize(), glyph, null, fontType, this.gs, textTrans, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    } else {
                        this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), glyph, null, fontType, this.gs, textTrans, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    }
                    this.gs.setLineWidth(lw);
                }
            } else {
                this.glyphData.set(" ");
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            this.errorTracker.addPageFailureMessage("Exception " + e + " on embedded font renderer");
        }
    }

    static char getValue(char lastTextChar, GlyphData glyphData, PdfFont currentFontData, DynamicVectorRenderer current) {
        String possAltValue;
        String newValue = currentFontData.getGlyphValue(glyphData.getRawInt());
        glyphData.setDisplayValue(newValue);
        int rawInt = glyphData.getRawInt();
        if (rawInt == 32 && !glyphData.getDisplayValue().equals(" ")) {
            lastTextChar = (char)90;
        }
        glyphData.setUnicodeValue(currentFontData.getUnicodeValue(glyphData.getDisplayValue(), rawInt));
        if (currentFontData.getFontType() == 1228944677 && current.isHTMLorSVG() && (possAltValue = currentFontData.getMappedChar(rawInt, true)) != null && possAltValue.length() == 1 && possAltValue.equalsIgnoreCase(glyphData.getUnicodeValue().toLowerCase())) {
            glyphData.set(possAltValue);
        }
        return lastTextChar;
    }

    static int calcFontSize(GlyphData glyphData, TextState currentTextState, float[][] Trm) throws RuntimeException {
        int fontSize;
        if (Trm[1][1] != 0.0f) {
            glyphData.setHorizontal(true);
            currentTextState.writingMode = 0;
            fontSize = Trm[1][1] < 0.0f ? (int)(Trm[1][1] - 0.5f) : (int)(Trm[1][1] + 0.5f);
            if (fontSize == 0) {
                fontSize = Trm[0][1] < 0.0f ? (int)(Trm[0][1] - 0.5f) : (int)(Trm[0][1] + 0.5f);
            }
            glyphData.setFontScale(Trm[0][0]);
            if (Trm[0][0] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f && Trm[1][1] > 0.0f) {
                currentTextState.writingMode = 3;
            }
        } else {
            glyphData.setHorizontal(false);
            fontSize = Trm[1][0] < 0.0f ? (int)(Trm[1][0] - 0.5f) : (int)(Trm[1][0] + 0.5f);
            if (fontSize == 0) {
                fontSize = Trm[0][0] < 0.0f ? (int)(Trm[0][0] - 0.5f) : (int)(Trm[0][0] + 0.5f);
            }
            if (fontSize < 0) {
                fontSize = -fontSize;
                currentTextState.writingMode = 3;
            } else {
                currentTextState.writingMode = 2;
            }
            glyphData.setFontScale(Trm[0][1]);
        }
        if (fontSize == 0) {
            fontSize = 1;
        }
        glyphData.setFontSize(fontSize);
        return fontSize;
    }

    static boolean writeOutText(GlyphData glyphData, float[][] Trm, boolean hasContent, float currentWidth, StringBuffer textData, String spaces) {
        String unicodeValue = glyphData.getUnicodeValue();
        float fontScale = glyphData.getFontScale();
        if (!unicodeValue.isEmpty()) {
            if (DecoderOptions.embedWidthData) {
                float xx = Trm[2][0];
                float yy = Trm[2][1];
                textData.append(spaces);
                if (glyphData.isHorizontal()) {
                    textData.append(PdfData.marker);
                    textData.append(xx);
                    textData.append(PdfData.marker);
                } else {
                    textData.append(PdfData.marker);
                    textData.append(yy);
                    textData.append(PdfData.marker);
                }
                textData.append(currentWidth * fontScale);
                textData.append(PdfData.marker);
            } else {
                textData.append(spaces);
            }
            int length = unicodeValue.length();
            boolean isXMLExtraction = glyphData.isXMLExtraction();
            for (int ii = 0; ii < length; ++ii) {
                char next = unicodeValue.charAt(ii);
                hasContent = true;
                if (next == '\t') {
                    next = ' ';
                }
                if (next == '<' && isXMLExtraction) {
                    textData.append("&lt;");
                    continue;
                }
                if (next == '>' && isXMLExtraction) {
                    textData.append("&gt;");
                    continue;
                }
                if (next == '\ufb02') {
                    textData.append("fl");
                    continue;
                }
                if (next > '\u001f') {
                    textData.append(next);
                    continue;
                }
                textData.append(hex[next]);
            }
        } else {
            textData.append(spaces);
        }
        return hasContent;
    }

    public boolean setExtractedText(float currentWidth, boolean resetCoords) {
        String displayValue = this.glyphData.getDisplayValue();
        if (!displayValue.isEmpty() && !displayValue.equals(" ")) {
            float fy;
            float xx = (int)this.Trm[2][0];
            float yy = (int)this.Trm[2][1];
            float ww = currentWidth * this.glyphData.getFontScale();
            float hh = this.Trm[1][1];
            if (hh == 0.0f) {
                hh = this.Trm[0][1];
            }
            if (this.currentFontData.getFontType() == 1228944679 && hh != 0.0f && (int)hh == 0 && this.currentFontData.FontMatrix[3] == -1.0) {
                hh *= this.currentFontData.FontBBox[3] - this.currentFontData.FontBBox[1];
                hh = -hh;
            }
            hh = (int)hh;
            if (ww < 0.0f) {
                ww = -ww;
                xx -= ww;
            }
            if (hh < 0.0f) {
                hh = -hh;
                yy -= hh;
            }
            Rectangle fontbb = this.currentFontData.getBoundingBox();
            if (fontbb.y < 0) {
                fontbb.height -= fontbb.y;
                fontbb.y = 0;
            }
            if ((fy = (float)fontbb.y) == 0.0f) {
                fy = 100.0f;
            }
            if (fy < 0.0f) {
                fy = -fy;
            }
            float h = 1000.0f + fy;
            h = 1000.0f / h;
            switch (this.currentTextState.writingMode) {
                case 0: {
                    float fontHeight = hh / h;
                    yy -= fontHeight - hh;
                    hh = fontHeight;
                    break;
                }
                case 1: {
                    System.out.println("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                    break;
                }
                case 2: {
                    float fontHeight = ww / h;
                    xx -= fontHeight - ww;
                    ww = fontHeight;
                    break;
                }
                case 3: {
                    float fontHeight = ww / h;
                    xx -= fontHeight;
                    ww = fontHeight;
                }
            }
            xx -= 1.0f;
            ww += 2.0f;
            if (resetCoords) {
                this.y2 = yy;
                this.y1 = yy + hh;
                resetCoords = false;
            }
            if (yy < this.y2) {
                this.y2 = yy;
            }
            if (yy + hh > this.y1) {
                this.y1 = yy + hh;
            }
            if (this.textAreas != null && this.parserOptions.isRenderText()) {
                this.textAreas.addElement(new int[]{(int)xx, (int)yy, (int)ww, (int)hh});
                this.textDirections.addElement(this.currentTextState.writingMode);
            }
        }
        return resetCoords;
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    public void setActualText(String actualText) {
        this.actualText = actualText;
    }

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    }
}

