/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.SwingDisplay;
import org.jpedal.render.T3ImageUtils;
import org.jpedal.render.T3Renderer;

public class T3Display
extends SwingDisplay
implements T3Renderer {
    public T3Display(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
        this.type = 9;
    }

    public T3Display(byte[] dvr, Map map) {
        super(dvr, map);
        this.type = 9;
    }

    @Override
    public void setType3Glyph(String pKey) {
        this.rawKey = pKey;
        this.isType3Font = true;
    }

    @Override
    public void lockColors(PdfPaint strokePaint, PdfPaint nonstrokePaint, boolean lockColour) {
        this.colorsLocked = lockColour;
        Color strokeColor = Color.white;
        Color nonstrokeColor = Color.white;
        if (strokePaint != null && !strokePaint.isPattern()) {
            strokeColor = (Color)((Object)strokePaint);
        }
        this.strokeCol = new PdfColor(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue());
        if (!nonstrokePaint.isPattern()) {
            nonstrokeColor = (Color)((Object)nonstrokePaint);
        }
        this.fillCol = new PdfColor(nonstrokeColor.getRed(), nonstrokeColor.getGreen(), nonstrokeColor.getBlue());
    }

    @Override
    void renderImage(AffineTransform imageAf, BufferedImage image, float alpha, GraphicsState currentGraphicsState, float x, float y) {
        if (image != null && this.fillCol != null) {
            image = T3ImageUtils.handleType3Image(image, this.fillCol);
        }
        super.renderImage(imageAf, image, alpha, currentGraphicsState, x, y);
    }
}

