/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.PdfPaint;

class T3ImageUtils {
    T3ImageUtils() {
    }

    public static BufferedImage handleType3Image(BufferedImage image, PdfPaint fillCol) {
        int[] maskCol = new int[4];
        int foreground = fillCol.getRGB();
        maskCol[0] = foreground >> 16 & 0xFF;
        maskCol[1] = foreground >> 8 & 0xFF;
        maskCol[2] = foreground & 0xFF;
        maskCol[3] = 255;
        if (maskCol[0] != 0 || maskCol[1] != 0 || maskCol[2] != 0) {
            if (image.getType() == 10 && maskCol[0] > 250 && maskCol[1] > 250 && maskCol[2] > 250) {
                image = null;
            } else {
                BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
                WritableRaster src = image.getRaster();
                WritableRaster dest = img.getRaster();
                int[] values = new int[4];
                for (int yy = 0; yy < image.getHeight(); ++yy) {
                    for (int xx = 0; xx < image.getWidth(); ++xx) {
                        src.getPixel(xx, yy, values);
                        if (values[3] <= 2) continue;
                        dest.setPixel(xx, yy, maskCol);
                    }
                }
                image = img;
            }
        }
        return image;
    }
}

