/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.render.output.FontMapper;

public class GenericFontMapper
implements FontMapper {
    private static final String DEFAULT_FONT = "DEFAULT_FONT";
    String style = "normal";
    String weight = "normal";
    String family;
    private String fontID;
    private int fontMode = 3;
    private boolean isFontEmbedded;
    private boolean isFontSubstituted;
    public static final Map<String, String> fontMappings = new HashMap<String, String>();
    public static final Map<String, Integer> fontSizeAdjustments = new HashMap<String, Integer>();
    private String rawFont;

    public GenericFontMapper(String rawFont) {
        this.init(rawFont);
        this.rawFont = rawFont;
    }

    public GenericFontMapper(String rawFont, int fontMode, boolean isFontEmbedded, boolean isFontSubstituted) {
        this.fontMode = fontMode;
        this.isFontEmbedded = isFontEmbedded;
        this.isFontSubstituted = isFontSubstituted;
        this.rawFont = rawFont;
        this.init(rawFont);
    }

    private void init(String rawFont) {
        String fontLessAttributes;
        if (this.fontMode == 6 || this.fontMode == 7) {
            this.fontID = rawFont;
            if (!this.isFontEmbedded || StandardFonts.isStandardFont(rawFont, true)) {
                int ptr = rawFont.indexOf(44);
                if (ptr == -1) {
                    ptr = rawFont.indexOf(45);
                }
                if (ptr == -1) {
                    for (int i = rawFont.length() - 1; i >= 0; --i) {
                        int pt = rawFont.codePointAt(i);
                        if (pt < 48 || pt > 57) continue;
                        if (i >= rawFont.length() - 1) break;
                        ptr = i - 1;
                        break;
                    }
                }
                if (ptr > 0) {
                    this.findAttributes(rawFont);
                }
            }
        } else if (!(this.mapFont(rawFont) || this.mapFont(fontLessAttributes = this.findAttributes(rawFont)) || this.hasSimiliarMapping(fontLessAttributes))) {
            switch (this.fontMode) {
                case 3: {
                    this.fontID = DEFAULT_FONT;
                    break;
                }
                case 2: {
                    throw new RuntimeException("Font " + rawFont + " not mapped");
                }
            }
        }
    }

    private String findAttributes(String rawFont) {
        String result = rawFont;
        int ptr = rawFont.indexOf(44);
        if (ptr == -1) {
            ptr = rawFont.indexOf(45);
        }
        if (ptr == -1) {
            ptr = rawFont.lastIndexOf(32);
        }
        if (ptr == -1) {
            for (int i = rawFont.length() - 1; i >= 0; --i) {
                int pt = rawFont.codePointAt(i);
                if (pt < 48 || pt > 57) continue;
                if (i >= rawFont.length() - 1) break;
                ptr = i - 1;
                break;
            }
        }
        if (ptr != -1) {
            String fontAttributes = rawFont.substring(ptr + 1, rawFont.length()).toLowerCase();
            this.family = result = rawFont.substring(0, ptr);
            boolean isFontExists = false;
            for (String k : fontMappings.keySet()) {
                if (!k.startsWith(this.family)) continue;
                isFontExists = true;
            }
            if (isFontExists || !this.isFontEmbedded) {
                if (fontAttributes.contains("heavy")) {
                    this.weight = "900";
                } else if (fontAttributes.endsWith("black")) {
                    this.weight = "bolder";
                } else if (fontAttributes.contains("light")) {
                    this.weight = "lighter";
                } else if (fontAttributes.contains("condensed")) {
                    this.weight = "100";
                } else if (fontAttributes.contains("bold")) {
                    this.weight = "bold";
                }
                if (fontAttributes.equals("it") || fontAttributes.contains("italic") || fontAttributes.contains("kursiv") || fontAttributes.contains("oblique")) {
                    this.style = "italic";
                }
            }
        }
        return result;
    }

    private boolean mapFont(String s) {
        if (fontMappings.get(s) != null) {
            this.fontID = s;
            return true;
        }
        return false;
    }

    private boolean hasSimiliarMapping(String fontName) {
        Set<String> keySet = fontMappings.keySet();
        HashSet<String> candidates = new HashSet<String>();
        for (String key : keySet) {
            String lcFont;
            String lcKey = key.toLowerCase();
            if (lcKey.equals(lcFont = fontName.toLowerCase())) {
                this.fontID = key;
                return true;
            }
            if (!lcKey.contains(lcFont) && !lcFont.contains(lcKey)) continue;
            candidates.add(key);
        }
        if (!candidates.isEmpty()) {
            String[] result = new String[candidates.size()];
            result = candidates.toArray(result);
            this.fontID = result[0];
            if (candidates.size() > 1) {
                for (int i = 1; i < result.length; ++i) {
                    if (result[i].length() >= this.fontID.length()) continue;
                    this.fontID = result[i];
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getFont() {
        String result = fontMappings.get(this.fontID);
        if (result == null && this.family != null && !this.isFontEmbedded) {
            result = fontMappings.get(this.family);
        }
        if (result == null && (this.fontMode == 6 || this.fontMode == 7)) {
            result = this.rawFont = this.rawFont.replaceAll("[.,@*#]", "-");
        } else if (result != null && this.isFontEmbedded && this.fontMode == 6) {
            result = this.fontID;
        }
        return result == null ? "" : result;
    }

    @Override
    public String getStyle() {
        if (this.isFontEmbedded) {
            this.style = "normal";
        }
        return this.style;
    }

    @Override
    public String getWeight() {
        if (this.isFontEmbedded) {
            this.weight = "normal";
        }
        return this.weight;
    }

    @Override
    public boolean isFontEmbedded() {
        return this.isFontEmbedded;
    }

    @Override
    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    @Override
    public boolean equals(FontMapper fontMapper) {
        return this.getStyle().equals(fontMapper.getStyle()) && this.getFont().equals(fontMapper.getFont()) && this.getWeight().equals(fontMapper.getWeight()) && this.isFontEmbedded == fontMapper.isFontEmbedded();
    }

    static {
        String arialType = "Arial, Helvetica, sans-serif";
        String arialBlackType = "'Arial Black', Gadget, sans-serif";
        String comicSansType = "'Comic Sans MS', Textile, cursive";
        String courierNewType = "'Courier New', Courier, monospace";
        String georgiaType = "Georgia, 'Times New Roman', Times, serif";
        String impactType = "Impact, Charcoal, sans-serif";
        String lucidaConsoleType = "'Lucida Console', Monaco, monospace";
        String lucidaSansType = "'Lucida Sans Unicode', 'Lucida Grande', sans-serif";
        String palatinoType = "'Palatino Linotype', 'Book Antiqua', Palatino, serif";
        String tahomaType = "Tahoma, Geneva, sans-serif";
        String romanType = "'Times New Roman', Times, serif";
        String trebuchetType = "'Trebuchet MS', Helvetica, sans-serif";
        String verdanaType = "Verdana, Geneva, sans-serif";
        String symbolType = "Symbol";
        String webdingsType = "Webdings";
        String wingdingsType = "Wingdings, 'Zapf Dingbats'";
        String msSansSerifType = "'MS Sans Serif', Geneva, sans-serif";
        String msSerifType = "'MS Serif', 'New York', serif";
        String helveticaType = "Helvetica, Arial, sans-serif";
        if (fontMappings.keySet().isEmpty()) {
            fontMappings.put("Arial", "Arial, Helvetica, sans-serif");
            fontMappings.put("ArialMT", "Arial, Helvetica, sans-serif");
            fontMappings.put("ArialBlack", "'Arial Black', Gadget, sans-serif");
            fontMappings.put("ComicSansMS", "'Comic Sans MS', Textile, cursive");
            fontMappings.put("CourierNew", "'Courier New', Courier, monospace");
            fontMappings.put("Georgia", "Georgia, 'Times New Roman', Times, serif");
            fontMappings.put("Impact", "Impact, Charcoal, sans-serif");
            fontMappings.put("LucidaConsole", "'Lucida Console', Monaco, monospace");
            fontMappings.put("LucidaSansUnicode", "'Lucida Sans Unicode', 'Lucida Grande', sans-serif");
            fontMappings.put("PalatinoLinotype", "'Palatino Linotype', 'Book Antiqua', Palatino, serif");
            fontMappings.put("Tahoma", "Tahoma, Geneva, sans-serif");
            fontMappings.put("TimesNewRoman", "'Times New Roman', Times, serif");
            fontMappings.put("Times", "'Times New Roman', Times, serif");
            fontMappings.put("Trebuchet", "'Trebuchet MS', Helvetica, sans-serif");
            fontMappings.put("Verdana", "Verdana, Geneva, sans-serif");
            fontMappings.put("Symbol", "Symbol");
            fontMappings.put("Webdings", "Webdings");
            fontMappings.put("Wingdings", "Wingdings, 'Zapf Dingbats'");
            fontMappings.put("MSSansSerif", "'MS Sans Serif', Geneva, sans-serif");
            fontMappings.put("MSSerif", "'MS Serif', 'New York', serif");
            fontMappings.put("Helvetica", "Helvetica, Arial, sans-serif");
            fontMappings.put("ZapfDingbats", "Wingdings, 'Zapf Dingbats'");
            fontMappings.put(DEFAULT_FONT, "'Times New Roman', Times, serif");
            fontSizeAdjustments.put(DEFAULT_FONT, -1);
        }
    }
}

