/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.text;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class TextLines {
    private Map lineAreas = new HashMap();
    private Map lineWritingMode = new HashMap();
    public Map areas = new HashMap();
    boolean hasHighlightAreasUpdated;

    @Deprecated
    public Rectangle setFoundParagraph(int x, int y, int page) {
        int[][] rectParams = this.getLineAreasAs2DArray(page);
        if (rectParams != null) {
            Rectangle[] lines = new Rectangle[rectParams.length];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = new Rectangle(rectParams[i][0], rectParams[i][1], rectParams[i][2], rectParams[i][3]);
            }
            Rectangle point = new Rectangle(x, y, 1, 1);
            Rectangle current = new Rectangle(0, 0, 0, 0);
            boolean lineFound = false;
            int selectedLine = 0;
            for (int i = 0; i != lines.length; ++i) {
                if (!lines[i].intersects(point)) continue;
                selectedLine = i;
                lineFound = true;
                break;
            }
            if (lineFound) {
                int i;
                double left = lines[selectedLine].x;
                double cx = lines[selectedLine].getCenterX();
                double right = lines[selectedLine].x + lines[selectedLine].width;
                double cy = lines[selectedLine].getCenterY();
                int h = lines[selectedLine].height;
                current.x = lines[selectedLine].x;
                current.y = lines[selectedLine].y;
                current.width = lines[selectedLine].width;
                current.height = lines[selectedLine].height;
                boolean foundTop = true;
                boolean foundBottom = true;
                Vector_Rectangle selected = new Vector_Rectangle(0);
                selected.addElement(lines[selectedLine]);
                block2: while (foundTop) {
                    foundTop = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!lines[i].contains(left, cy + (double)h) && !lines[i].contains(cx, cy + (double)h) && !lines[i].contains(right, cy + (double)h)) continue;
                        selected.addElement(lines[i]);
                        foundTop = true;
                        cy = lines[i].getCenterY();
                        h = lines[i].height;
                        if (current.x > lines[i].x) {
                            current.width = current.x + current.width - lines[i].x;
                            current.x = lines[i].x;
                        }
                        if (current.x + current.width < lines[i].x + lines[i].width) {
                            current.width = lines[i].x + lines[i].width - current.x;
                        }
                        if (current.y > lines[i].y) {
                            current.height = current.y + current.height - lines[i].y;
                            current.y = lines[i].y;
                        }
                        if (current.y + current.height >= lines[i].y + lines[i].height) continue block2;
                        current.height = lines[i].y + lines[i].height - current.y;
                        continue block2;
                    }
                }
                left = lines[selectedLine].x;
                cx = lines[selectedLine].getCenterX();
                right = lines[selectedLine].x + lines[selectedLine].width;
                cy = lines[selectedLine].getCenterY();
                h = lines[selectedLine].height;
                block4: while (foundBottom) {
                    foundBottom = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!lines[i].contains(left, cy - (double)h) && !lines[i].contains(cx, cy - (double)h) && !lines[i].contains(right, cy - (double)h)) continue;
                        selected.addElement(lines[i]);
                        foundBottom = true;
                        cy = lines[i].getCenterY();
                        h = lines[i].height;
                        if (current.x > lines[i].x) {
                            current.width = current.x + current.width - lines[i].x;
                            current.x = lines[i].x;
                        }
                        if (current.x + current.width < lines[i].x + lines[i].width) {
                            current.width = lines[i].x + lines[i].width - current.x;
                        }
                        if (current.y > lines[i].y) {
                            current.height = current.y + current.height - lines[i].y;
                            current.y = lines[i].y;
                        }
                        if (current.y + current.height >= lines[i].y + lines[i].height) continue block4;
                        current.height = lines[i].y + lines[i].height - current.y;
                        continue block4;
                    }
                }
                selected.trim();
                this.addHighlights(selected.get(), true, page);
                return current;
            }
            return null;
        }
        return null;
    }

    public int[] setFoundParagraphAsArray(int x, int y, int page) {
        int[][] lines = this.getLineAreasAs2DArray(page);
        if (lines != null) {
            int[] point = new int[]{x, y, 1, 1};
            int[] current = new int[]{0, 0, 0, 0};
            boolean lineFound = false;
            int selectedLine = 0;
            for (int i = 0; i != lines.length; ++i) {
                if (!TextLines.intersects(lines[i], point)) continue;
                selectedLine = i;
                lineFound = true;
                break;
            }
            if (lineFound) {
                int i;
                int left = lines[selectedLine][0];
                int cx = lines[selectedLine][0] + lines[selectedLine][2] / 2;
                int right = lines[selectedLine][0] + lines[selectedLine][2];
                int cy = lines[selectedLine][1] + lines[selectedLine][3] / 2;
                int h = lines[selectedLine][3];
                current[0] = lines[selectedLine][0];
                current[1] = lines[selectedLine][1];
                current[2] = lines[selectedLine][2];
                current[3] = lines[selectedLine][3];
                boolean foundTop = true;
                boolean foundBottom = true;
                Vector_Rectangle_Int selected = new Vector_Rectangle_Int(0);
                selected.addElement(lines[selectedLine]);
                block1: while (foundTop) {
                    foundTop = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!TextLines.contains(left, cy + h, lines[i]) && !TextLines.contains(cx, cy + h, lines[i]) && !TextLines.contains(right, cy + h, lines[i])) continue;
                        selected.addElement(lines[i]);
                        foundTop = true;
                        cy = lines[i][1] + lines[i][3] / 2;
                        h = lines[i][3];
                        if (current[0] > lines[i][0]) {
                            current[2] = current[0] + current[2] - lines[i][0];
                            current[0] = lines[i][0];
                        }
                        if (current[0] + current[2] < lines[i][0] + lines[i][2]) {
                            current[2] = lines[i][0] + lines[i][2] - current[0];
                        }
                        if (current[1] > lines[i][1]) {
                            current[3] = current[1] + current[3] - lines[i][1];
                            current[1] = lines[i][1];
                        }
                        if (current[1] + current[3] >= lines[i][1] + lines[i][3]) continue block1;
                        current[3] = lines[i][1] + lines[i][3] - current[1];
                        continue block1;
                    }
                }
                left = lines[selectedLine][0];
                cx = lines[selectedLine][0] + lines[selectedLine][2] / 2;
                right = lines[selectedLine][0] + lines[selectedLine][2];
                cy = lines[selectedLine][1] + lines[selectedLine][3] / 2;
                h = lines[selectedLine][3];
                block3: while (foundBottom) {
                    foundBottom = false;
                    for (i = 0; i != lines.length; ++i) {
                        if (!TextLines.contains(left, cy - h, lines[i]) && !TextLines.contains(cx, cy - h, lines[i]) && !TextLines.contains(right, cy - h, lines[i])) continue;
                        selected.addElement(lines[i]);
                        foundBottom = true;
                        cy = lines[i][1] + lines[i][3] / 2;
                        h = lines[i][3];
                        if (current[0] > lines[i][0]) {
                            current[2] = current[0] + current[2] - lines[i][0];
                            current[0] = lines[i][0];
                        }
                        if (current[0] + current[2] < lines[i][0] + lines[i][2]) {
                            current[2] = lines[i][0] + lines[i][2] - current[0];
                        }
                        if (current[1] > lines[i][1]) {
                            current[3] = current[1] + current[3] - lines[i][1];
                            current[1] = lines[i][1];
                        }
                        if (current[1] + current[3] >= lines[i][1] + lines[i][3]) continue block3;
                        current[3] = lines[i][1] + lines[i][3] - current[1];
                        continue block3;
                    }
                }
                selected.trim();
                this.addHighlights(selected.get(), true, page);
                return current;
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public void addToLineAreas(Rectangle area, int writingMode, int page) {
        boolean addNew = true;
        if (this.lineAreas == null) {
            this.lineAreas = new HashMap();
            this.lineAreas.put(page, new Rectangle[]{area});
            this.lineWritingMode = new HashMap();
            this.lineWritingMode.put(page, new int[]{writingMode});
        } else {
            Rectangle[] lastAreas = (Rectangle[])this.lineAreas.get(page);
            int[] lastWritingMode = (int[])this.lineWritingMode.get(page);
            if (area != null) {
                if (lastAreas != null) {
                    block6: for (int i = 0; i != lastAreas.length; ++i) {
                        int lwm = lastWritingMode[i];
                        int cx = area.x;
                        int cy = area.y;
                        int cw = area.width;
                        int ch = area.height;
                        int lx = lastAreas[i].x;
                        int ly = lastAreas[i].y;
                        int lw = lastAreas[i].width;
                        int lh = lastAreas[i].height;
                        float heightMod = 5.0f;
                        float widthMod = 1.1f;
                        switch (writingMode) {
                            case 0: {
                                if (lwm != writingMode || !((float)ly > (float)cy - (float)ch / 5.0f) || !((float)ly < (float)cy + (float)ch / 5.0f) || !((float)lh < (float)ch + (float)ch / 5.0f) || !((float)lh > (float)ch - (float)ch / 5.0f) || !((float)lx > (float)(cx + cw) - (float)ch * 1.1f && (float)lx < (float)(cx + cw) + (float)ch * 1.1f || (float)(lx + lw) > (float)cx - (float)ch * 1.1f && (float)(lx + lw) < (float)cx + (float)ch * 1.1f) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 1: {
                                lx = lastAreas[i].x;
                                ly = lastAreas[i].y;
                                lw = lastAreas[i].width;
                                lh = lastAreas[i].height;
                                cx = area.x;
                                cy = area.y;
                                cw = area.width;
                                ch = area.height;
                                if (lwm != writingMode || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 2: {
                                lx = lastAreas[i].y;
                                ly = lastAreas[i].x;
                                lw = lastAreas[i].height;
                                lh = lastAreas[i].width;
                                cx = area.y;
                                cy = area.x;
                                cw = area.height;
                                ch = area.width;
                                if (lwm != writingMode || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !lastAreas[i].intersects(area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 3: {
                                int currentBaseLine = cx + cw;
                                int lastBaseLine = lx + lw;
                                if (lwm != writingMode || currentBaseLine < lastBaseLine - lw / 3 || currentBaseLine > lastBaseLine + lw / 3 || !((double)ly + ((double)lh + (double)lw * 0.6) > (double)cy && (double)ly + ((double)lh - (double)lw * 0.6) < (double)cy || (double)ly + (double)lw * 0.6 > (double)(cy + ch) && (double)ly - (double)lw * 0.6 < (double)(cy + ch)) && !area.intersects(lastAreas[i])) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                            }
                        }
                    }
                } else {
                    addNew = true;
                }
                if (addNew) {
                    int[] lineWritingMode;
                    Rectangle[] lineAreas;
                    if (lastAreas != null) {
                        int i;
                        lineAreas = new Rectangle[lastAreas.length + 1];
                        for (i = 0; i != lastAreas.length; ++i) {
                            lineAreas[i] = lastAreas[i];
                        }
                        lineAreas[lineAreas.length - 1] = area;
                        lineWritingMode = new int[lastWritingMode.length + 1];
                        for (i = 0; i != lastWritingMode.length; ++i) {
                            lineWritingMode[i] = lastWritingMode[i];
                        }
                        lineWritingMode[lineWritingMode.length - 1] = writingMode;
                    } else {
                        lineAreas = new Rectangle[]{area};
                        lineWritingMode = new int[]{writingMode};
                    }
                    this.lineAreas.put(page, lineAreas);
                    this.lineWritingMode.put(page, lineWritingMode);
                }
            }
        }
    }

    public void addToLineAreas(int[] area, int writingMode, int page) {
        boolean addNew = true;
        if (this.lineAreas == null) {
            this.lineAreas = new HashMap();
            this.lineAreas.put(page, new int[][]{area});
            this.lineWritingMode = new HashMap();
            this.lineWritingMode.put(page, new int[]{writingMode});
        } else {
            int[][] lastAreas = (int[][])this.lineAreas.get(page);
            int[] lastWritingMode = (int[])this.lineWritingMode.get(page);
            if (area != null) {
                if (lastAreas != null) {
                    block6: for (int i = 0; i != lastAreas.length; ++i) {
                        int lwm = lastWritingMode[i];
                        int cx = area[0];
                        int cy = area[1];
                        int cw = area[2];
                        int ch = area[3];
                        int lx = lastAreas[i][0];
                        int ly = lastAreas[i][1];
                        int lw = lastAreas[i][2];
                        int lh = lastAreas[i][3];
                        float heightMod = 5.0f;
                        float widthMod = 1.1f;
                        switch (writingMode) {
                            case 0: {
                                if (lwm != writingMode || !((float)ly > (float)cy - (float)ch / 5.0f) || !((float)ly < (float)cy + (float)ch / 5.0f) || !((float)lh < (float)ch + (float)ch / 5.0f) || !((float)lh > (float)ch - (float)ch / 5.0f) || !((float)lx > (float)(cx + cw) - (float)ch * 1.1f && (float)lx < (float)(cx + cw) + (float)ch * 1.1f || (float)(lx + lw) > (float)cx - (float)ch * 1.1f && (float)(lx + lw) < (float)cx + (float)ch * 1.1f) && !TextLines.intersects(lastAreas[i], area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 1: {
                                lx = lastAreas[i][0];
                                ly = lastAreas[i][1];
                                lw = lastAreas[i][2];
                                lh = lastAreas[i][3];
                                cx = area[0];
                                cy = area[1];
                                cw = area[2];
                                ch = area[3];
                                if (lwm != writingMode || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !TextLines.intersects(lastAreas[i], area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 2: {
                                lx = lastAreas[i][1];
                                ly = lastAreas[i][0];
                                lw = lastAreas[i][3];
                                lh = lastAreas[i][2];
                                cx = area[1];
                                cy = area[0];
                                cw = area[3];
                                ch = area[2];
                                if (lwm != writingMode || ly <= cy - 5 || ly >= cy + 5 || lh > ch + ch / 5 || lh < ch - ch / 5 || !((double)lx > (double)(cx + cw) - (double)ch * 0.6 && (double)lx < (double)(cx + cw) + (double)ch * 0.6 || (double)(lx + lw) > (double)cx - (double)ch * 0.6 && (double)(lx + lw) < (double)cx + (double)ch * 0.6) && !TextLines.intersects(lastAreas[i], area)) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                                continue block6;
                            }
                            case 3: {
                                int currentBaseLine = cx + cw;
                                int lastBaseLine = lx + lw;
                                if (lwm != writingMode || currentBaseLine < lastBaseLine - lw / 3 || currentBaseLine > lastBaseLine + lw / 3 || !((double)ly + ((double)lh + (double)lw * 0.6) > (double)cy && (double)ly + ((double)lh - (double)lw * 0.6) < (double)cy || (double)ly + (double)lw * 0.6 > (double)(cy + ch) && (double)ly - (double)lw * 0.6 < (double)(cy + ch)) && !TextLines.intersects(area, lastAreas[i])) continue block6;
                                addNew = false;
                                lastAreas[i] = TextLines.mergePartLines(lastAreas[i], area);
                            }
                        }
                    }
                } else {
                    addNew = true;
                }
                if (addNew) {
                    int[] lineWritingMode;
                    Object lineAreas;
                    if (lastAreas != null) {
                        int i;
                        lineAreas = new int[lastAreas.length + 1][4];
                        for (i = 0; i != lastAreas.length; ++i) {
                            lineAreas[i] = lastAreas[i];
                        }
                        lineAreas[((int[][])lineAreas).length - 1] = area;
                        lineWritingMode = new int[lastWritingMode.length + 1];
                        for (i = 0; i != lastWritingMode.length; ++i) {
                            lineWritingMode[i] = lastWritingMode[i];
                        }
                        lineWritingMode[lineWritingMode.length - 1] = writingMode;
                    } else {
                        lineAreas = new int[][]{area};
                        lineWritingMode = new int[]{writingMode};
                    }
                    this.lineAreas.put(page, lineAreas);
                    this.lineWritingMode.put(page, lineWritingMode);
                }
            }
        }
    }

    public void removeFoundTextArea(int[] rectArea, int page) {
        if (rectArea == null || this.areas == null) {
            return;
        }
        Integer p = page;
        int[][] areas = (int[][])this.areas.get(p);
        if (areas != null) {
            int size = areas.length;
            for (int i = 0; i < size; ++i) {
                if (areas[i] == null || !TextLines.contains(rectArea[0], rectArea[1], areas[i]) && (areas[i][0] != rectArea[0] || areas[i][1] != rectArea[1] || areas[i][2] != rectArea[2] || areas[i][3] != rectArea[3])) continue;
                areas[i] = null;
                i = size;
            }
            this.areas.put(p, areas);
            this.hasHighlightAreasUpdated = true;
        }
    }

    @Deprecated
    public void removeFoundTextArea(Rectangle rectArea, int page) {
        if (rectArea == null || this.areas == null) {
            return;
        }
        Integer p = page;
        Rectangle[] areas = (Rectangle[])this.areas.get(p);
        if (areas != null) {
            int size = areas.length;
            for (int i = 0; i < size; ++i) {
                if (areas[i] == null || !areas[i].contains(rectArea) && (areas[i].x != rectArea.x || areas[i].y != rectArea.y || areas[i].width != rectArea.width || areas[i].height != rectArea.height)) continue;
                areas[i] = null;
                i = size;
            }
            this.areas.put(p, areas);
            this.hasHighlightAreasUpdated = true;
        }
    }

    public void removeFoundTextAreas(int[][] rectArea, int page) {
        if (rectArea == null) {
            this.areas = null;
        } else {
            for (int[] aRectArea : rectArea) {
                this.removeFoundTextArea(aRectArea, page);
            }
            boolean allNull = true;
            Integer p = page;
            int[][] areas = (int[][])this.areas.get(p);
            if (areas != null) {
                for (int ii = 0; ii < areas.length; ++ii) {
                    if (areas[ii] == null) continue;
                    allNull = false;
                    ii = areas.length;
                }
                if (allNull) {
                    areas = null;
                    this.areas.put(p, areas);
                    this.hasHighlightAreasUpdated = true;
                }
            }
        }
    }

    @Deprecated
    public void removeFoundTextAreas(Rectangle[] rectArea, int page) {
        if (rectArea == null) {
            this.areas = null;
        } else {
            for (Rectangle aRectArea : rectArea) {
                this.removeFoundTextArea(aRectArea, page);
            }
            boolean allNull = true;
            Integer p = page;
            Rectangle[] areas = (Rectangle[])this.areas.get(p);
            if (areas != null) {
                for (int ii = 0; ii < areas.length; ++ii) {
                    if (areas[ii] == null) continue;
                    allNull = false;
                    ii = areas.length;
                }
                if (allNull) {
                    areas = null;
                    this.areas.put(p, areas);
                    this.hasHighlightAreasUpdated = true;
                }
            }
        }
    }

    public void clearHighlights() {
        this.areas = null;
        this.hasHighlightAreasUpdated = true;
    }

    @Deprecated
    public void addHighlights(Rectangle[] highlights, boolean areaSelect, int page) {
        block38: {
            if (highlights == null) break block38;
            this.hasHighlightAreasUpdated = true;
            if (!areaSelect) {
                for (int j = 0; j != highlights.length; ++j) {
                    int i;
                    if (highlights[j] == null) continue;
                    Point startPoint = new Point(highlights[j].x + 1, highlights[j].y + 1);
                    Point endPoint = new Point(highlights[j].x + highlights[j].width - 1, highlights[j].y + highlights[j].height - 1);
                    if (this.areas == null) {
                        this.areas = new HashMap();
                    }
                    int[][] rectParams = this.getLineAreasAs2DArray(page);
                    int[] writingMode = this.getLineWritingMode(page);
                    int start = -1;
                    int finish = -1;
                    boolean backward = false;
                    if (rectParams == null) continue;
                    Rectangle[] lines = new Rectangle[rectParams.length];
                    for (i = 0; i < lines.length; ++i) {
                        lines[i] = new Rectangle(rectParams[i][0], rectParams[i][1], rectParams[i][2], rectParams[i][3]);
                    }
                    for (i = 0; i != lines.length; ++i) {
                        if (lines[i].contains(startPoint)) {
                            start = i;
                        }
                        if (lines[i].contains(endPoint)) {
                            finish = i;
                        }
                        if (start != -1 && finish != -1) break;
                    }
                    if (start > finish) {
                        int temp = start;
                        start = finish;
                        finish = temp;
                        backward = true;
                    }
                    if (start == finish && startPoint.x > endPoint.x) {
                        Point temp = startPoint;
                        startPoint = endPoint;
                        endPoint = temp;
                    }
                    if (start == -1 || finish == -1) continue;
                    Integer p = page;
                    Rectangle[] areas = new Rectangle[finish - start + 1];
                    System.arraycopy(lines, start + 0, areas, 0, finish - start + 1);
                    if (areas.length > 0) {
                        boolean top = false;
                        int bottom = areas.length - 1;
                        if (areas[0] != null && areas[bottom] != null) {
                            switch (writingMode[start]) {
                                case 0: {
                                    if (backward) {
                                        if (endPoint.x - 15 <= areas[0].x) break;
                                        areas[0].width -= endPoint.x - areas[0].x;
                                        areas[0].x = endPoint.x;
                                        break;
                                    }
                                    if (startPoint.x - 15 <= areas[0].x) break;
                                    areas[0].width -= startPoint.x - areas[0].x;
                                    areas[0].x = startPoint.x;
                                    break;
                                }
                                case 1: {
                                    LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (endPoint.y - 15 <= areas[0].y) break;
                                        areas[0].height -= endPoint.y - areas[0].y;
                                        areas[0].y = endPoint.y;
                                        break;
                                    }
                                    if (startPoint.y - 15 <= areas[0].y) break;
                                    areas[0].height -= startPoint.y - areas[0].y;
                                    areas[0].y = startPoint.y;
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (endPoint.y - 15 <= areas[0].y) break;
                                        areas[0].height -= endPoint.y - areas[0].y;
                                        areas[0].y = endPoint.y;
                                        break;
                                    }
                                    if (startPoint.y - 15 <= areas[0].y) break;
                                    areas[0].height -= startPoint.y - areas[0].y;
                                    areas[0].y = startPoint.y;
                                }
                            }
                            switch (writingMode[finish]) {
                                case 0: {
                                    if (backward) {
                                        if (startPoint.x + 15 >= areas[bottom].x + areas[bottom].width) break;
                                        areas[bottom].width = startPoint.x - areas[bottom].x;
                                        break;
                                    }
                                    if (endPoint.x + 15 >= areas[bottom].x + areas[bottom].width) break;
                                    areas[bottom].width = endPoint.x - areas[bottom].x;
                                    break;
                                }
                                case 1: {
                                    LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (startPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                        areas[bottom].height = startPoint.y - areas[bottom].y;
                                        break;
                                    }
                                    if (endPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                    areas[bottom].height = endPoint.y - areas[bottom].y;
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (startPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                        areas[bottom].height = startPoint.y - areas[bottom].y;
                                        break;
                                    }
                                    if (endPoint.y + 15 >= areas[bottom].y + areas[bottom].height) break;
                                    areas[bottom].height = endPoint.y - areas[bottom].y;
                                }
                            }
                        }
                    }
                    this.areas.put(p, areas);
                }
            } else {
                for (int v = 0; v != highlights.length; ++v) {
                    Rectangle[] areas;
                    Integer p;
                    if (highlights[v] == null) continue;
                    if (highlights[v].width < 0) {
                        highlights[v].width = -highlights[v].width;
                        highlights[v].x -= highlights[v].width;
                    }
                    if (highlights[v].height < 0) {
                        highlights[v].height = -highlights[v].height;
                        highlights[v].y -= highlights[v].height;
                    }
                    if (this.areas != null) {
                        p = page;
                        areas = (Rectangle[])this.areas.get(p);
                        if (areas != null) {
                            boolean matchFound = false;
                            int size = areas.length;
                            for (int i = 0; i < size; ++i) {
                                if (areas[i] == null || areas[i] == null || areas[i].x != highlights[v].x || areas[i].y != highlights[v].y || areas[i].width != highlights[v].width || areas[i].height != highlights[v].height) continue;
                                matchFound = true;
                                i = size;
                            }
                            if (!matchFound) {
                                int newSize = areas.length + 1;
                                Rectangle[] newAreas = new Rectangle[newSize];
                                for (int i = 0; i < areas.length; ++i) {
                                    if (areas[i] == null) continue;
                                    newAreas[i + 1] = new Rectangle(areas[i].x, areas[i].y, areas[i].width, areas[i].height);
                                }
                                areas = newAreas;
                                areas[0] = highlights[v];
                            }
                            this.areas.put(p, areas);
                            continue;
                        }
                        this.areas.put(p, highlights);
                        continue;
                    }
                    this.areas = new HashMap();
                    p = page;
                    areas = new Rectangle[]{highlights[v]};
                    this.areas.put(p, areas);
                }
            }
        }
    }

    public void addHighlights(int[][] highlights, boolean areaSelect, int page) {
        block37: {
            if (highlights == null) break block37;
            this.hasHighlightAreasUpdated = true;
            if (!areaSelect) {
                for (int j = 0; j != highlights.length; ++j) {
                    if (highlights[j] == null) continue;
                    int[] startPoint = new int[]{highlights[j][0] + 1, highlights[j][1] + 1};
                    int[] endPoint = new int[]{highlights[j][0] + highlights[j][2] - 1, highlights[j][1] + highlights[j][3] - 1};
                    if (this.areas == null) {
                        this.areas = new HashMap();
                    }
                    int[][] lines = this.getLineAreasAs2DArray(page);
                    int[] writingMode = this.getLineWritingMode(page);
                    int start = -1;
                    int finish = -1;
                    boolean backward = false;
                    if (lines == null) continue;
                    for (int i = 0; i != lines.length; ++i) {
                        if (TextLines.contains(startPoint[0], startPoint[1], lines[i])) {
                            start = i;
                        }
                        if (TextLines.contains(endPoint[0], endPoint[1], lines[i])) {
                            finish = i;
                        }
                        if (start != -1 && finish != -1) break;
                    }
                    if (start > finish) {
                        int temp = start;
                        start = finish;
                        finish = temp;
                        backward = true;
                    }
                    if (start == finish && startPoint[0] > endPoint[0]) {
                        int[] temp = startPoint;
                        startPoint = endPoint;
                        endPoint = temp;
                    }
                    if (start == -1 || finish == -1) continue;
                    Integer p = page;
                    int[][] areas = new int[finish - start + 1][4];
                    System.arraycopy(lines, start + 0, areas, 0, finish - start + 1);
                    if (areas.length > 0) {
                        boolean top = false;
                        int bottom = areas.length - 1;
                        if (areas[0] != null && areas[bottom] != null) {
                            switch (writingMode[start]) {
                                case 0: {
                                    if (backward) {
                                        if (endPoint[0] - 15 <= areas[0][0]) break;
                                        int[] nArray = areas[0];
                                        nArray[2] = nArray[2] - (endPoint[0] - areas[0][0]);
                                        areas[0][0] = endPoint[0];
                                        break;
                                    }
                                    if (startPoint[0] - 15 <= areas[0][0]) break;
                                    int[] nArray = areas[0];
                                    nArray[2] = nArray[2] - (startPoint[0] - areas[0][0]);
                                    areas[0][0] = startPoint[0];
                                    break;
                                }
                                case 1: {
                                    LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (endPoint[1] - 15 <= areas[0][1]) break;
                                        int[] nArray = areas[0];
                                        nArray[3] = nArray[3] - (endPoint[1] - areas[0][1]);
                                        areas[0][1] = endPoint[1];
                                        break;
                                    }
                                    if (startPoint[1] - 15 <= areas[0][1]) break;
                                    int[] nArray = areas[0];
                                    nArray[3] = nArray[3] - (startPoint[1] - areas[0][1]);
                                    areas[0][1] = startPoint[1];
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (endPoint[1] - 15 <= areas[0][1]) break;
                                        int[] nArray = areas[0];
                                        nArray[3] = nArray[3] - (endPoint[1] - areas[0][1]);
                                        areas[0][1] = endPoint[1];
                                        break;
                                    }
                                    if (startPoint[1] - 15 <= areas[0][1]) break;
                                    int[] nArray = areas[0];
                                    nArray[3] = nArray[3] - (startPoint[1] - areas[0][1]);
                                    areas[0][1] = startPoint[1];
                                }
                            }
                            switch (writingMode[finish]) {
                                case 0: {
                                    if (backward) {
                                        if (startPoint[0] + 15 >= areas[bottom][0] + areas[bottom][2]) break;
                                        areas[bottom][2] = startPoint[0] - areas[bottom][0];
                                        break;
                                    }
                                    if (endPoint[0] + 15 >= areas[bottom][0] + areas[bottom][2]) break;
                                    areas[bottom][2] = endPoint[0] - areas[bottom][0];
                                    break;
                                }
                                case 1: {
                                    LogWriter.writeLog("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                                    break;
                                }
                                case 2: {
                                    if (backward) {
                                        if (startPoint[1] + 15 >= areas[bottom][1] + areas[bottom][3]) break;
                                        areas[bottom][3] = startPoint[1] - areas[bottom][1];
                                        break;
                                    }
                                    if (endPoint[1] + 15 >= areas[bottom][1] + areas[bottom][3]) break;
                                    areas[bottom][3] = endPoint[1] - areas[bottom][1];
                                    break;
                                }
                                case 3: {
                                    if (backward) {
                                        if (startPoint[1] + 15 >= areas[bottom][1] + areas[bottom][3]) break;
                                        areas[bottom][3] = startPoint[1] - areas[bottom][1];
                                        break;
                                    }
                                    if (endPoint[1] + 15 >= areas[bottom][1] + areas[bottom][3]) break;
                                    areas[bottom][3] = endPoint[1] - areas[bottom][1];
                                }
                            }
                        }
                    }
                    this.areas.put(p, areas);
                }
            } else {
                for (int v = 0; v != highlights.length; ++v) {
                    int[][] areas;
                    Integer p;
                    if (highlights[v] == null) continue;
                    if (highlights[v][2] < 0) {
                        highlights[v][2] = -highlights[v][2];
                        int[] nArray = highlights[v];
                        nArray[0] = nArray[0] - highlights[v][2];
                    }
                    if (highlights[v][3] < 0) {
                        highlights[v][3] = -highlights[v][3];
                        int[] nArray = highlights[v];
                        nArray[1] = nArray[1] - highlights[v][3];
                    }
                    if (this.areas != null) {
                        p = page;
                        areas = (int[][])this.areas.get(p);
                        if (areas != null) {
                            boolean matchFound = false;
                            int size = areas.length;
                            for (int i = 0; i < size; ++i) {
                                if (areas[i] == null || areas[i] == null || areas[i][0] != highlights[v][0] || areas[i][1] != highlights[v][1] || areas[i][2] != highlights[v][2] || areas[i][3] != highlights[v][3]) continue;
                                matchFound = true;
                                i = size;
                            }
                            if (!matchFound) {
                                int newSize = areas.length + 1;
                                int[][] newAreas = new int[newSize][4];
                                for (int i = 0; i < areas.length; ++i) {
                                    if (areas[i] == null) continue;
                                    newAreas[i] = new int[]{areas[i][0], areas[i][1], areas[i][2], areas[i][3]};
                                }
                                areas = newAreas;
                                areas[areas.length - 1] = highlights[v];
                            }
                            this.areas.put(p, areas);
                            continue;
                        }
                        this.areas.put(p, highlights);
                        continue;
                    }
                    this.areas = new HashMap();
                    p = page;
                    areas = new int[1][4];
                    areas[0] = highlights[v];
                    this.areas.put(p, areas);
                }
            }
        }
    }

    public boolean hasHighlightAreasUpdated() {
        return this.hasHighlightAreasUpdated;
    }

    public Map getAllHighlights() {
        this.hasHighlightAreasUpdated = false;
        if (this.areas == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.areas);
    }

    @Deprecated
    public Rectangle[] getHighlightedAreas(int page) {
        if (this.areas == null) {
            return null;
        }
        Integer p = page;
        Rectangle[] areas = (Rectangle[])this.areas.get(p);
        if (areas != null) {
            int count = areas.length;
            Rectangle[] returnValue = new Rectangle[count];
            for (int ii = 0; ii < count; ++ii) {
                returnValue[ii] = areas[ii] == null ? null : new Rectangle(areas[ii].x, areas[ii].y, areas[ii].width, areas[ii].height);
            }
            this.hasHighlightAreasUpdated = false;
            return returnValue;
        }
        return null;
    }

    public int[][] getHighlightedAreasAs2DArray(int page) {
        if (this.areas == null) {
            return null;
        }
        Integer p = page;
        int[][] areas = (int[][])this.areas.get(p);
        if (areas != null) {
            int count = areas.length;
            int[][] returnValue = new int[count][4];
            for (int ii = 0; ii < count; ++ii) {
                returnValue[ii] = (int[])(areas[ii] == null ? null : new int[]{areas[ii][0], areas[ii][1], areas[ii][2], areas[ii][3]});
            }
            this.hasHighlightAreasUpdated = false;
            return returnValue;
        }
        return null;
    }

    public void setLineAreas(Map la) {
        this.lineAreas = la;
    }

    public void setLineWritingMode(Map lineOrientation) {
        this.lineWritingMode = lineOrientation;
    }

    public int[][] getLineAreasAs2DArray(int page) {
        if (this.lineAreas == null || this.lineAreas.get(page) == null) {
            return null;
        }
        int[][] lineAreas = (int[][])this.lineAreas.get(page);
        if (lineAreas == null) {
            return null;
        }
        int count = lineAreas.length;
        int[][] returnValue = new int[count][4];
        for (int ii = 0; ii < count; ++ii) {
            returnValue[ii] = (int[])(lineAreas[ii] == null ? null : new int[]{lineAreas[ii][0], lineAreas[ii][1], lineAreas[ii][2], lineAreas[ii][3]});
        }
        return returnValue;
    }

    @Deprecated
    public Rectangle[] getLineAreas(int page) {
        if (this.lineAreas == null) {
            return null;
        }
        Rectangle[] lineAreas = (Rectangle[])this.lineAreas.get(page);
        if (lineAreas == null) {
            return null;
        }
        int count = lineAreas.length;
        Rectangle[] returnValue = new Rectangle[count];
        for (int ii = 0; ii < count; ++ii) {
            returnValue[ii] = lineAreas[ii] == null ? null : new Rectangle(lineAreas[ii].x, lineAreas[ii].y, lineAreas[ii].width, lineAreas[ii].height);
        }
        return returnValue;
    }

    public int[] getLineWritingMode(int page) {
        if (this.lineWritingMode == null) {
            return null;
        }
        int[] lineWritingMode = (int[])this.lineWritingMode.get(page);
        if (lineWritingMode == null) {
            return null;
        }
        int count = lineWritingMode.length;
        int[] returnValue = new int[count];
        System.arraycopy(lineWritingMode, 0, returnValue, 0, count);
        return returnValue;
    }

    private static int[] mergePartLines(int[] lastArea, int[] area) {
        int x1 = area[0];
        int x2 = area[0] + area[2];
        int y1 = area[1];
        int y2 = area[1] + area[3];
        int lx1 = lastArea[0];
        int lx2 = lastArea[0] + lastArea[2];
        int ly1 = lastArea[1];
        int ly2 = lastArea[1] + lastArea[3];
        area[0] = x1 < lx1 ? x1 : lx1;
        area[1] = y1 < ly1 ? y1 : ly1;
        area[3] = y2 > ly2 ? y2 - area[1] : ly2 - area[1];
        area[2] = x2 > lx2 ? x2 - area[0] : lx2 - area[0];
        return area;
    }

    @Deprecated
    private static Rectangle mergePartLines(Rectangle lastArea, Rectangle area) {
        int x1 = area.x;
        int x2 = area.x + area.width;
        int y1 = area.y;
        int y2 = area.y + area.height;
        int lx1 = lastArea.x;
        int lx2 = lastArea.x + lastArea.width;
        int ly1 = lastArea.y;
        int ly2 = lastArea.y + lastArea.height;
        area.x = x1 < lx1 ? x1 : lx1;
        area.y = y1 < ly1 ? y1 : ly1;
        area.height = y2 > ly2 ? y2 - area.y : ly2 - area.y;
        area.width = x2 > lx2 ? x2 - area.x : lx2 - area.x;
        return area;
    }

    public static boolean intersects(int[] paramsOne, int[] paramsTwo) {
        int X1 = paramsOne[0];
        int Y1 = paramsOne[1];
        int W1 = paramsOne[2];
        int H1 = paramsOne[3];
        int X2 = paramsTwo[0];
        int Y2 = paramsTwo[1];
        int W2 = paramsTwo[2];
        int H2 = paramsTwo[3];
        return X1 + W1 >= X2 && X2 + W2 >= X1 && Y1 + H1 >= Y2 && Y2 + H2 >= Y1;
    }

    private static boolean contains(int x, int y, int[] rectParams) {
        int minX = rectParams[0];
        int minY = rectParams[1];
        int maxX = rectParams[0] + rectParams[2];
        int maxY = rectParams[1] + rectParams[3];
        return x >= minX && x <= maxX && y >= minY && y <= maxY;
    }
}

