/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.geom.AffineTransform;

public class FloatMatrix {
    public static final float[][] multiply(float[][] m1, float[][] m2) {
        float[][] result = new float[3][3];
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                result[row][col] = m1[row][0] * m2[0][col] + m1[row][1] * m2[1][col] + m1[row][2] * m2[2][col];
            }
        }
        return result;
    }

    public static final float[][] inverse(float[][] inp) {
        float d = inp[2][0] * inp[0][1] * inp[1][2] - inp[2][0] * inp[0][2] * inp[1][1] - inp[1][0] * inp[0][1] * inp[2][2] + inp[1][0] * inp[0][2] * inp[2][1] + inp[0][0] * inp[1][1] * inp[2][2] - inp[0][0] * inp[1][2] * inp[2][1];
        float t00 = (inp[1][1] * inp[2][2] - inp[1][2] * inp[2][1]) / d;
        float t01 = -(inp[0][1] * inp[2][2] - inp[0][2] * inp[2][1]) / d;
        float t02 = (inp[0][1] * inp[1][2] - inp[0][2] * inp[1][1]) / d;
        float t10 = -(-inp[2][0] * inp[1][2] + inp[1][0] * inp[2][2]) / d;
        float t11 = (-inp[2][0] * inp[0][2] + inp[0][0] * inp[2][2]) / d;
        float t12 = -(-inp[1][0] * inp[0][2] + inp[0][0] * inp[1][2]) / d;
        float t20 = (-inp[2][0] * inp[1][1] + inp[1][0] * inp[2][1]) / d;
        float t21 = -(-inp[2][0] * inp[0][1] + inp[0][0] * inp[2][1]) / d;
        float t22 = (-inp[1][0] * inp[0][1] + inp[0][0] * inp[1][1]) / d;
        float[][] output = new float[3][3];
        output[0][0] = t00;
        output[0][1] = t01;
        output[0][2] = t02;
        output[1][0] = t10;
        output[1][1] = t11;
        output[1][2] = t12;
        output[2][0] = t20;
        output[2][1] = t21;
        output[2][2] = t22;
        return output;
    }

    public static AffineTransform toAffine(float[][] mm) {
        return new AffineTransform(mm[0][0], mm[0][1], mm[1][0], mm[1][1], mm[2][0], mm[2][1]);
    }

    public static float[][] toMatrix(AffineTransform at) {
        return new float[][]{{(float)at.getScaleX(), (float)at.getShearX(), 0.0f}, {(float)at.getShearY(), (float)at.getScaleY(), 0.0f}, {(float)at.getTranslateX(), (float)at.getTranslateY(), 1.0f}};
    }

    public static final void show(float[][] matrix1) {
        System.out.println("[...............................");
        for (int row = 0; row < 3; ++row) {
            System.out.println("\t[ " + matrix1[row][0] + " , " + matrix1[row][1] + " , " + matrix1[row][2] + " ]");
        }
        System.out.println("...............................]");
    }

    public static void main(String[] args) {
        float[][] matrix = new float[][]{{100.77587f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        FloatMatrix.show(matrix);
    }
}

