/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static LogScanner logScanner;
    public static boolean debug;
    public static String log_name;
    public static boolean testing;
    private static boolean verbose;
    private static final Set<String> filterValues;
    public static final boolean isRunningFromIDE;

    private static Set getFilterSet() {
        String filters = System.getProperty("org.jpedal.inclusiveLogFilters");
        HashSet<String> filterSet = null;
        if (filters != null) {
            filterSet = new HashSet<String>(Arrays.asList(filters.toLowerCase().split("[,]")));
        }
        return filterSet;
    }

    @Deprecated
    public static final boolean isOutput() {
        return verbose || logScanner != null;
    }

    public static final void writeLog(String message) {
        if (isRunningFromIDE && message.contains("Exception")) {
            System.out.println("[Exception] " + message);
        } else if (verbose || logScanner != null) {
            LogWriter.writeMessage(message);
        }
    }

    private static void writeMessage(String message) {
        if (filterValues != null && message != null) {
            boolean found = false;
            for (String s : filterValues) {
                if (!message.toLowerCase().contains(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        if (logScanner != null) {
            logScanner.message(message);
        }
        if (verbose) {
            System.out.println(message);
        }
        if (log_name != null) {
            try {
                PrintWriter log_file = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    log_file.println(TimeNow.getTimeNow() + ' ' + message);
                }
                log_file.println(message);
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void setupLogFile(String command_line_values) {
        if (command_line_values != null) {
            if (command_line_values.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static void writeFormLog(String message, boolean print) {
        if (print) {
            System.out.println("[forms] " + message);
        }
        LogWriter.writeLog("[forms] " + message);
    }

    static {
        filterValues = LogWriter.getFilterSet();
        isRunningFromIDE = System.getProperty("debugInIDE") != null && System.getProperty("debugInIDE").equalsIgnoreCase("true") && LogWriter.class.getResource("LogWriter.class").toString().startsWith("file:");
    }
}

