/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Int
implements Serializable {
    int increment_size = 1000;
    protected int current_item;
    int max_size = 250;
    protected int[] items = new int[this.max_size];
    private int checkPoint = -1;

    public Vector_Int() {
    }

    protected static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Int(int number) {
        this.max_size = number;
        this.items = new int[this.max_size];
    }

    public final synchronized int elementAt(int id) {
        if (id >= this.max_size) {
            return 0;
        }
        return this.items[id];
    }

    public final int[] get() {
        return this.items;
    }

    public final void setElementAt(int new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final void set(int[] new_items) {
        this.items = new_items;
    }

    public final void keep_larger(int master, int child) {
        if (this.items[master] < this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void keep_smaller(int master, int child) {
        if (this.items[master] > this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void clear() {
        this.checkPoint = -1;
        this.items = null;
        this.items = new int[this.max_size];
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0;
            }
        }
        this.current_item = 0;
    }

    public final synchronized int size() {
        return this.current_item + 1;
    }

    public final synchronized int getCapacity() {
        return this.items.length;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final synchronized void deleteElementWithValue(int id) {
        int currentSize = this.items.length;
        int[] newItems = new int[currentSize - 1];
        int counter = 0;
        for (int item : this.items) {
            if (item == id) continue;
            newItems[counter] = item;
            ++counter;
        }
        this.items = newItems;
        --this.current_item;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder("{");
        for (int item : this.items) {
            returnString.append(' ').append(item);
        }
        returnString.append("} ").append(this.current_item);
        return returnString.toString();
    }

    public final boolean contains(int value) {
        boolean flag = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != value) continue;
            i = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final int pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void addElement(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void add_together(int master, int child) {
        int n = master;
        this.items[n] = this.items[n] + this.items[child];
    }

    private void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            int[] temp = this.items;
            this.items = new int[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Int.incrementSize(this.increment_size);
        }
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public void trim() {
        int[] newItems = new int[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.checkPoint = this.current_item;
        }
    }
}

