/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.gitea.api.GiteaAPI;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtOrganization;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.sdk.gitea.api.GtSearchUser;
import org.jreleaser.sdk.gitea.api.GtUser;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

class Gitea {
    private static final String API_V1 = "/api/v1";
    private final Tika tika = new Tika();
    private final JReleaserLogger logger;
    private final GiteaAPI api;

    Gitea(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) throws IOException {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        if (!endpoint.endsWith(API_V1)) {
            if (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            endpoint = endpoint + API_V1;
        }
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GiteaAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("token %s", token)})).target(GiteaAPI.class, endpoint);
    }

    GtRepository findRepository(String owner, String repo) {
        this.logger.debug("lookup repository {}/{}", new Object[]{owner, repo});
        try {
            return this.api.getRepository(owner, repo);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    Optional<GtMilestone> findMilestoneByName(String owner, String repo, String milestoneName) {
        this.logger.debug("lookup milestone '{}' on {}/{}", new Object[]{milestoneName, owner, repo});
        try {
            GtMilestone milestone = this.api.findMilestoneByTitle(owner, repo, milestoneName);
            if (milestone == null) {
                return Optional.empty();
            }
            return "open".equals(milestone.getState()) ? Optional.of(milestone) : Optional.empty();
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    void closeMilestone(String owner, String repo, GtMilestone milestone) throws IOException {
        this.logger.debug("closing milestone '{}' on {}/{}", new Object[]{milestone.getTitle(), owner, repo});
        this.api.updateMilestone((Map<String, Object>)CollectionUtils.map().e((Object)"state", (Object)"closed"), owner, repo, milestone.getId());
    }

    GtRepository createRepository(String owner, String repo) {
        this.logger.debug("creating repository {}/{}", new Object[]{owner, repo});
        CollectionUtils.MapBuilder params = CollectionUtils.map().e((Object)"name", (Object)repo).e((Object)"private", (Object)false);
        GtOrganization organization = this.resolveOrganization(owner);
        if (null != organization) {
            return this.api.createRepository((Map<String, Object>)params, owner);
        }
        return this.api.createRepository((Map<String, Object>)params);
    }

    private GtOrganization resolveOrganization(String name) {
        try {
            return this.api.getOrganization(name);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    GtRelease findReleaseByTag(String owner, String repo, String tagName) {
        this.logger.debug("fetching release on {}/{} with tag {}", new Object[]{owner, repo, tagName});
        try {
            return this.api.getReleaseByTagName(owner, repo, tagName);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return null;
            }
            throw e;
        }
    }

    void deleteRelease(String owner, String repo, String tagName, Integer id) throws RestAPIException {
        this.logger.debug("deleting release {} from {}/{} ({})", new Object[]{tagName, owner, repo, id});
        try {
            this.api.deleteRelease(owner, repo, id);
        }
        catch (RestAPIException e) {
            if (e.isNotFound()) {
                return;
            }
            throw e;
        }
    }

    void deleteTag(String owner, String repo, String tagName) throws RestAPIException {
        this.logger.debug("deleting tag {} from {}/{}", new Object[]{tagName, owner, repo});
        this.api.deleteTag(owner, repo, tagName);
    }

    GtRelease createRelease(String owner, String repo, GtRelease release) throws RestAPIException {
        this.logger.debug("creating release on {}/{} with tag {}", new Object[]{owner, repo, release.getTagName()});
        return this.api.createRelease(release, owner, repo);
    }

    void updateRelease(String owner, String repo, Integer id, GtRelease release) throws RestAPIException {
        this.logger.debug("updating release on {}/{} with tag {}", new Object[]{owner, repo, release.getTagName()});
        this.api.updateRelease(release, owner, repo, id);
    }

    void uploadAssets(String owner, String repo, GtRelease release, List<Path> assets) throws IOException {
        for (Path asset : assets) {
            if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
            this.logger.info(" - uploading {}", new Object[]{asset.getFileName().toString()});
            try {
                this.api.uploadAsset(owner, repo, release.getId(), this.toFormData(asset));
            }
            catch (RestAPIException e) {
                this.logger.error(" x failed to upload {}", new Object[]{asset.getFileName()});
                throw e;
            }
        }
    }

    Optional<User> findUser(String email, String name, String host) throws RestAPIException {
        this.logger.debug("looking up user for {} <{}>", new Object[]{name, email});
        GtSearchUser search = this.api.searchUser(CollectionUtils.newMap((Object[])new Object[]{"q", email}));
        if (null != search.getData() && !search.getData().isEmpty()) {
            GtUser user = search.getData().get(0);
            return Optional.of(new User(user.getUsername(), email, host + user.getUsername()));
        }
        return Optional.empty();
    }

    private FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)this.tika.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }
}

