/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.gitea;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.releaser.spi.User;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.sdk.gitea.Gitea;
import org.jreleaser.sdk.gitea.api.GtMilestone;
import org.jreleaser.sdk.gitea.api.GtRelease;
import org.jreleaser.sdk.gitea.api.GtRepository;
import org.jreleaser.util.StringUtils;

public class GiteaReleaser
implements Releaser {
    protected final JReleaserContext context;
    protected final List<Path> assets = new ArrayList<Path>();

    public GiteaReleaser(JReleaserContext context, List<Path> assets) {
        this.context = context;
        this.assets.addAll(assets);
    }

    protected org.jreleaser.model.Gitea resolveGiteaFromModel() {
        return this.context.getModel().getRelease().getGitea();
    }

    protected Repository.Kind resolveRepositoryKind() {
        return Repository.Kind.OTHER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() throws ReleaseException {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        this.context.getLogger().info("Releasing to {}", new Object[]{gitea.getResolvedRepoUrl(this.context.getModel())});
        String tagName = gitea.getEffectiveTagName(this.context.getModel());
        try {
            String changelog = this.context.getChangelog();
            Gitea api = new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), gitea.getResolvedToken(), gitea.getConnectTimeout(), gitea.getReadTimeout());
            this.context.getLogger().debug("looking up release with tag {} at repository {}", new Object[]{tagName, gitea.getCanonicalRepoName()});
            GtRelease release = api.findReleaseByTag(gitea.getOwner(), gitea.getName(), tagName);
            boolean snapshot = this.context.getModel().getProject().isSnapshot();
            if (null == release) {
                this.context.getLogger().debug("release {} does not exist", new Object[]{tagName});
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, snapshot);
                return;
            }
            this.context.getLogger().debug("release {} exists", new Object[]{tagName});
            if (gitea.isOverwrite() || snapshot) {
                this.context.getLogger().debug("deleting release {}", new Object[]{tagName});
                if (!this.context.isDryrun()) {
                    api.deleteRelease(gitea.getOwner(), gitea.getName(), tagName, release.getId());
                }
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, true);
                return;
            }
            if (!gitea.isUpdate()) {
                if (!this.context.isDryrun()) throw new IllegalStateException(StringUtils.capitalize((String)gitea.getServiceName()) + " release failed because release " + tagName + " already exists. overwrite = false; update = false");
                this.context.getLogger().debug("creating release {}", new Object[]{tagName});
                this.createRelease(api, tagName, changelog, false);
                return;
            }
            this.context.getLogger().debug("updating release {}", new Object[]{tagName});
            if (this.context.isDryrun()) return;
            boolean update = false;
            GtRelease updater = new GtRelease();
            if (gitea.getUpdateSections().contains(UpdateSection.TITLE)) {
                update = true;
                this.context.getLogger().info("updating release title to {}", new Object[]{gitea.getEffectiveReleaseName()});
                updater.setName(gitea.getEffectiveReleaseName());
            }
            if (gitea.getUpdateSections().contains(UpdateSection.BODY)) {
                update = true;
                this.context.getLogger().info("updating release body");
                updater.setBody(changelog);
            }
            if (update) {
                api.updateRelease(gitea.getOwner(), gitea.getName(), release.getId(), updater);
            }
            if (!gitea.getUpdateSections().contains(UpdateSection.ASSETS)) return;
            api.uploadAssets(gitea.getOwner(), gitea.getName(), release, this.assets);
            return;
        }
        catch (IOException | IllegalStateException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new ReleaseException((Throwable)e);
        }
    }

    public Repository maybeCreateRepository(String owner, String repo, String password) throws IOException {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        this.context.getLogger().debug("looking up {}/{}", new Object[]{owner, repo});
        Gitea api = new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), password, gitea.getConnectTimeout(), gitea.getReadTimeout());
        GtRepository repository = api.findRepository(owner, repo);
        if (null == repository) {
            repository = api.createRepository(owner, repo);
        }
        return new Repository(this.resolveRepositoryKind(), owner, repo, repository.getHtmlUrl(), repository.getCloneUrl());
    }

    public Optional<User> findUser(String email, String name) {
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        try {
            String host = gitea.getHost();
            String endpoint = gitea.getApiEndpoint();
            host = endpoint.startsWith("https") ? "https://" + host : "http://" + host;
            if (!host.endsWith("/")) {
                host = host + "/";
            }
            return new Gitea(this.context.getLogger(), gitea.getApiEndpoint(), gitea.getResolvedToken(), gitea.getConnectTimeout(), gitea.getReadTimeout()).findUser(email, name, host);
        }
        catch (IOException e) {
            this.context.getLogger().trace((Throwable)e);
            this.context.getLogger().debug("Could not find user matching {}", new Object[]{email});
            return Optional.empty();
        }
    }

    private void createRelease(Gitea api, String tagName, String changelog, boolean deleteTags) throws IOException {
        Optional<GtMilestone> milestone;
        org.jreleaser.model.Gitea gitea = this.resolveGiteaFromModel();
        if (this.context.isDryrun()) {
            for (Path asset : this.assets) {
                if (0L == asset.toFile().length() || !Files.exists(asset, new LinkOption[0])) continue;
                this.context.getLogger().info(" - uploading {}", new Object[]{asset.getFileName().toString()});
            }
            return;
        }
        if (deleteTags) {
            this.deleteTags(api, gitea.getOwner(), gitea.getName(), tagName);
        }
        if (deleteTags || !gitea.isSkipTag()) {
            this.context.getLogger().debug("tagging local repository with {}", new Object[]{tagName});
            GitSdk.of((JReleaserContext)this.context).tag(tagName, true, this.context);
        }
        GtRelease release = new GtRelease();
        release.setName(gitea.getEffectiveReleaseName());
        release.setTagName(tagName);
        release.setTargetCommitish(gitea.getBranch());
        release.setBody(changelog);
        release = api.createRelease(gitea.getOwner(), gitea.getName(), release);
        api.uploadAssets(gitea.getOwner(), gitea.getName(), release, this.assets);
        if (gitea.getMilestone().isClose().booleanValue() && !this.context.getModel().getProject().isSnapshot() && (milestone = api.findMilestoneByName(gitea.getOwner(), gitea.getName(), gitea.getMilestone().getEffectiveName())).isPresent()) {
            api.closeMilestone(gitea.getOwner(), gitea.getName(), milestone.get());
        }
    }

    private void deleteTags(Gitea api, String owner, String repo, String tagName) {
        try {
            api.deleteTag(owner, repo, tagName);
        }
        catch (RestAPIException restAPIException) {
            // empty catch block
        }
    }
}

