/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.model.assembler.spi.AssemblerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessInitException;

abstract class AbstractAssemblerProcessor<A extends Assembler>
implements AssemblerProcessor<A> {
    protected final JReleaserContext context;
    protected A assembler;

    protected AbstractAssemblerProcessor(JReleaserContext context) {
        this.context = context;
    }

    public A getAssembler() {
        return this.assembler;
    }

    public void setAssembler(A assembler) {
        this.assembler = assembler;
    }

    public void assemble(Map<String, Object> props) throws AssemblerProcessingException {
        try {
            this.context.getLogger().debug("creating props for {}/{}", new Object[]{this.assembler.getType(), this.assembler.getName()});
            Map<String, Object> newProps = this.fillProps(props);
            this.context.getLogger().debug("resolving templates for {}/{}", new Object[]{this.assembler.getType(), this.assembler.getName()});
            Map templates = TemplateUtils.resolveAndMergeTemplates((JReleaserLogger)this.context.getLogger(), (String)this.assembler.getType(), (String)this.assembler.getType(), (boolean)this.context.getModel().getProject().isSnapshot(), (Path)this.context.getBasedir().resolve(this.getAssembler().getTemplateDirectory()));
            for (Map.Entry entry : templates.entrySet()) {
                this.context.getLogger().debug("evaluating template {} for {}/{}", new Object[]{entry.getKey(), this.assembler.getName(), this.assembler.getType()});
                String content = MustacheUtils.applyTemplate((Reader)((Reader)entry.getValue()), newProps);
                this.context.getLogger().debug("writing template {} for {}/{}", new Object[]{entry.getKey(), this.assembler.getName(), this.assembler.getType()});
                this.writeFile(this.context.getModel().getProject(), content, newProps, (String)entry.getKey());
            }
            Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
            Files.createDirectories(assembleDirectory, new FileAttribute[0]);
            this.doAssemble(newProps);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AssemblerProcessingException((Throwable)e);
        }
    }

    protected abstract void doAssemble(Map<String, Object> var1) throws AssemblerProcessingException;

    protected abstract void writeFile(Project var1, String var2, Map<String, Object> var3, String var4) throws AssemblerProcessingException;

    protected void writeFile(String content, Path outputFile) throws AssemblerProcessingException {
        try {
            FileUtils.createDirectoriesWithFullAccess((Path)outputFile.getParent());
            Files.write(outputFile, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileUtils.grantFullAccess((Path)outputFile);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException("Unexpected error when writing to " + outputFile.toAbsolutePath(), (Throwable)e);
        }
    }

    protected Map<String, Object> fillProps(Map<String, Object> props) throws AssemblerProcessingException {
        LinkedHashMap<String, Object> newProps = new LinkedHashMap<String, Object>(props);
        this.context.getLogger().debug("filling git properties into props");
        this.context.getModel().getRelease().getGitService().fillProps(newProps, this.context.getModel());
        this.context.getLogger().debug("filling assembler properties into props");
        this.fillAssemblerProperties(newProps);
        return newProps;
    }

    protected void fillAssemblerProperties(Map<String, Object> props) {
        props.putAll(this.assembler.props());
    }

    protected boolean executeCommand(ProcessExecutor processExecutor) throws AssemblerProcessingException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            int exitValue = processExecutor.redirectOutput((OutputStream)out).redirectError((OutputStream)err).execute().getExitValue();
            this.info(out);
            this.error(err);
            if (exitValue == 0) {
                return true;
            }
            throw new AssemblerProcessingException("Command execution error. exitValue = " + exitValue);
        }
        catch (ProcessInitException e) {
            throw new AssemblerProcessingException("Unexpected error", e.getCause());
        }
        catch (AssemblerProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssemblerProcessingException("Unexpected error", (Throwable)e);
        }
    }

    protected boolean executeCommand(Path directory, List<String> cmd) throws AssemblerProcessingException {
        return this.executeCommand(new ProcessExecutor(cmd).directory(directory.toFile()));
    }

    protected boolean executeCommand(List<String> cmd) throws AssemblerProcessingException {
        return this.executeCommand(new ProcessExecutor(cmd));
    }

    protected boolean executeCommandCapturing(List<String> cmd, OutputStream out) throws AssemblerProcessingException {
        try {
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            int exitValue = new ProcessExecutor(cmd).redirectOutput(out).redirectError((OutputStream)err).execute().getExitValue();
            this.error(err);
            if (exitValue == 0) {
                return true;
            }
            throw new AssemblerProcessingException("Command execution error. exitValue = " + exitValue);
        }
        catch (ProcessInitException e) {
            throw new AssemblerProcessingException("Unexpected error", e.getCause());
        }
        catch (Exception e) {
            if (e instanceof AssemblerProcessingException) {
                throw (AssemblerProcessingException)((Object)e);
            }
            throw new AssemblerProcessingException("Unexpected error", (Throwable)e);
        }
    }

    protected void info(ByteArrayOutputStream out) {
        this.log(out, arg_0 -> ((JReleaserLogger)this.context.getLogger()).info(arg_0));
    }

    protected void error(ByteArrayOutputStream err) {
        this.log(err, arg_0 -> ((JReleaserLogger)this.context.getLogger()).error(arg_0));
    }

    private void log(ByteArrayOutputStream stream, Consumer<? super String> consumer) {
        String str = stream.toString();
        if (StringUtils.isBlank((String)str)) {
            return;
        }
        Arrays.stream(str.split(System.lineSeparator())).forEach(consumer);
    }
}

