/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.io.IOException;
import org.jreleaser.model.Codeberg;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Github;
import org.jreleaser.model.Gitlab;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.JReleaserModelPrinter;
import org.jreleaser.model.releaser.spi.Commit;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public class ModelConfigurer {
    public static void configure(JReleaserContext context) {
        try {
            context.getModel().setCommit(GitSdk.of((JReleaserContext)context).head());
        }
        catch (IOException e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException("Could not determine git HEAD", (Throwable)e);
        }
        Repository repository = null;
        try {
            repository = GitSdk.of((JReleaserContext)context).getRemote();
        }
        catch (IOException e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException("Could not determine remote", (Throwable)e);
        }
        if (StringUtils.isBlank((String)context.getModel().getProject().getResolvedName())) {
            context.getModel().getProject().setName(repository.getName());
        }
        switch (repository.getKind()) {
            case GITHUB: {
                ModelConfigurer.autoConfigureGithub(context, repository);
                break;
            }
            case GITLAB: {
                ModelConfigurer.autoConfigureGitlab(context, repository);
                break;
            }
            case CODEBERG: {
                ModelConfigurer.autoConfigureCodeberg(context, repository);
                break;
            }
            default: {
                ModelConfigurer.autoConfigureOther(context, repository);
            }
        }
        try {
            Errors errors = context.validateModel();
            new JReleaserModelPrinter.Plain(context.getLogger().getTracer()).print((Object)context.getModel().asMap(true));
            switch (context.getMode()) {
                case ASSEMBLE: {
                    if (errors.hasConfigurationErrors()) {
                        throw new JReleaserException("JReleaser has not been properly configured.");
                    }
                    break;
                }
                default: {
                    if (errors.hasErrors()) {
                        throw new JReleaserException("JReleaser has not been properly configured.");
                    }
                }
            }
        }
        catch (JReleaserException e) {
            context.getLogger().trace((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            context.getLogger().trace((Throwable)e);
            throw new JReleaserException("JReleaser has not been properly configured.", (Throwable)e);
        }
    }

    private static void autoConfigureGithub(JReleaserContext context, Repository repository) {
        GitService service = context.getModel().getRelease().getGitService();
        if (service != null) {
            if (!(service instanceof Github)) {
                context.getLogger().warn("Auto configure detected github but project has " + service.getServiceName() + " configured");
            }
        } else {
            context.getModel().getRelease().setGithub(new Github());
        }
        ModelConfigurer.fillGitProperties(context.getModel().getRelease().getGitService(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureGitlab(JReleaserContext context, Repository repository) {
        GitService service = context.getModel().getRelease().getGitService();
        if (service != null) {
            if (!(service instanceof Gitlab)) {
                context.getLogger().warn("Auto configure detected gitlab but project has " + service.getServiceName() + " configured");
            }
        } else {
            context.getModel().getRelease().setGitlab(new Gitlab());
        }
        ModelConfigurer.fillGitProperties(context.getModel().getRelease().getGitService(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureCodeberg(JReleaserContext context, Repository repository) {
        GitService service = context.getModel().getRelease().getGitService();
        if (service != null) {
            if (!(service instanceof Codeberg)) {
                context.getLogger().warn("Auto configure detected codeberg but project has " + service.getServiceName() + " configured");
            }
        } else {
            context.getModel().getRelease().setCodeberg(new Codeberg());
        }
        ModelConfigurer.fillGitProperties(context.getModel().getRelease().getGitService(), repository, context.getModel().getCommit());
    }

    private static void autoConfigureOther(JReleaserContext context, Repository repository) {
        GitService service = context.getModel().getRelease().getGitService();
        if (service != null) {
            ModelConfigurer.fillGitProperties(service, repository, context.getModel().getCommit());
        }
    }

    private static void fillGitProperties(GitService service, Repository repository, Commit head) {
        if (StringUtils.isBlank((String)service.getOwner())) {
            service.setOwner(repository.getOwner());
        }
        if (StringUtils.isBlank((String)service.getName())) {
            service.setName(repository.getName());
        }
        if (StringUtils.isBlank((String)Env.resolve((String)"BRANCH", (String)service.getBranch()))) {
            service.setBranch(head.getRefName());
        }
    }
}

