/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.Map;
import java.util.Objects;
import org.jreleaser.engine.distribution.ToolProcessors;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Tool;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.model.tool.spi.ToolProcessor;
import org.jreleaser.util.StringUtils;

public class DistributionProcessor {
    private final JReleaserContext context;
    private final String distributionName;
    private final String toolName;

    private DistributionProcessor(JReleaserContext context, String distributionName, String toolName) {
        this.context = context;
        this.distributionName = distributionName;
        this.toolName = toolName;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public String getToolName() {
        return this.toolName;
    }

    public void prepareDistribution() throws ToolProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Tool tool = distribution.getTool(this.toolName);
        if (!tool.isEnabled()) {
            this.context.getLogger().debug("skipping for {} distribution", new Object[]{this.distributionName});
            return;
        }
        ToolProcessor<Tool> toolProcessor = ToolProcessors.findProcessor(this.context, tool);
        if (!toolProcessor.supportsDistribution(distribution)) {
            this.context.getLogger().info("distribution {} with type {} is not supported. Skipping", new Object[]{this.distributionName, distribution.getType()});
            return;
        }
        this.context.getLogger().info("preparing {} distribution", new Object[]{this.distributionName});
        try {
            toolProcessor.prepareDistribution(distribution, this.initProps());
        }
        catch (ToolProcessingException tpe) {
            if (tool.isContinueOnError()) {
                tool.fail();
                this.context.getLogger().warn("failure: " + tpe.getMessage());
                this.context.getLogger().trace((Throwable)tpe);
            }
            throw tpe;
        }
    }

    public void packageDistribution() throws ToolProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Tool tool = distribution.getTool(this.toolName);
        if (!tool.isEnabled()) {
            this.context.getLogger().debug("skipping for {} distribution", new Object[]{this.distributionName});
            return;
        }
        if (tool.isFailed()) {
            this.context.getLogger().warn("skipping due to previous failure");
            return;
        }
        ToolProcessor<Tool> toolProcessor = ToolProcessors.findProcessor(this.context, tool);
        if (!toolProcessor.supportsDistribution(distribution)) {
            this.context.getLogger().info("distribution {} with type {} is not supported. Skipping", new Object[]{this.distributionName, distribution.getType()});
            return;
        }
        this.context.getLogger().info("packaging {} distribution", new Object[]{this.distributionName});
        try {
            toolProcessor.packageDistribution(distribution, this.initProps());
        }
        catch (ToolProcessingException tpe) {
            if (tool.isContinueOnError()) {
                tool.fail();
                this.context.getLogger().warn("failure: " + tpe.getMessage());
                this.context.getLogger().trace((Throwable)tpe);
            }
            throw tpe;
        }
    }

    public void publishDistribution() throws ToolProcessingException {
        Distribution distribution = this.context.getModel().findDistribution(this.distributionName);
        Tool tool = distribution.getTool(this.toolName);
        if (!tool.isEnabled()) {
            this.context.getLogger().debug("skipping for {} distribution", new Object[]{this.distributionName});
            return;
        }
        if (tool.isFailed()) {
            this.context.getLogger().warn("skipping due to previous failure");
            return;
        }
        ToolProcessor<Tool> toolProcessor = ToolProcessors.findProcessor(this.context, tool);
        if (!toolProcessor.supportsDistribution(distribution)) {
            this.context.getLogger().info("distribution {} with type {} is not supported. Skipping", new Object[]{this.distributionName, distribution.getType()});
            return;
        }
        this.context.getLogger().info("publishing {} distribution", new Object[]{this.distributionName});
        try {
            toolProcessor.publishDistribution(distribution, this.initProps());
        }
        catch (ToolProcessingException tpe) {
            if (tool.isContinueOnError()) {
                tool.fail();
                this.context.getLogger().warn("failure: " + tpe.getMessage());
                this.context.getLogger().trace((Throwable)tpe);
            }
            throw tpe;
        }
    }

    private Map<String, Object> initProps() {
        Map props = this.context.props();
        props.put("prepareDirectory", this.context.getPrepareDirectory());
        props.put("packageDirectory", this.context.getPackageDirectory());
        props.put("distributionPrepareDirectory", this.context.getPrepareDirectory().resolve(this.distributionName).resolve(this.toolName));
        props.put("distributionPackageDirectory", this.context.getPackageDirectory().resolve(this.distributionName).resolve(this.toolName));
        return props;
    }

    public static DistributionProcessorBuilder builder() {
        return new DistributionProcessorBuilder();
    }

    public static class DistributionProcessorBuilder {
        private JReleaserContext context;
        private String distributionName;
        private String toolName;

        public DistributionProcessorBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public DistributionProcessorBuilder distributionName(String distributionName) {
            this.distributionName = StringUtils.requireNonBlank((String)distributionName, (String)"'distributionName' must not be blank");
            return this;
        }

        public DistributionProcessorBuilder toolName(String toolName) {
            this.toolName = StringUtils.requireNonBlank((String)toolName, (String)"'toolName' must not be blank");
            return this;
        }

        public DistributionProcessor build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            StringUtils.requireNonBlank((String)this.distributionName, (String)"'distributionName' must not be blank");
            StringUtils.requireNonBlank((String)this.toolName, (String)"'toolName' must not be blank");
            return new DistributionProcessor(this.context, this.distributionName, this.toolName);
        }
    }
}

