/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Docker;
import org.jreleaser.model.DockerConfiguration;
import org.jreleaser.model.DockerSpec;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Registry;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;

public class DockerToolProcessor
extends AbstractRepositoryToolProcessor<Docker> {
    public DockerToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, String templateDirectory, String toolName) throws IOException, ToolProcessingException {
        if (((Docker)this.tool).getActiveSpecs().isEmpty()) {
            super.doPrepareDistribution(distribution, props, distributionName, prepareDirectory, templateDirectory, toolName);
            return;
        }
        for (DockerSpec spec : ((Docker)this.tool).getActiveSpecs()) {
            this.prepareSpec(distribution, props, distributionName, prepareDirectory, spec);
        }
    }

    private void prepareSpec(Distribution distribution, Map<String, Object> props, String distributionName, Path prepareDirectory, DockerSpec spec) throws IOException, ToolProcessingException {
        Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
        this.context.getLogger().debug(RB.$((String)"distributions.action.preparing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
        super.doPrepareDistribution(distribution, newProps, distributionName, prepareDirectory.resolve(spec.getName()), spec.getTemplateDirectory(), spec.getName() + "/" + ((Docker)this.tool).getName());
    }

    private Map<String, Object> fillSpecProps(Distribution distribution, Map<String, Object> props, DockerSpec spec) throws ToolProcessingException {
        List<Artifact> artifacts = Collections.singletonList(spec.getArtifact());
        Map<String, Object> newProps = this.fillProps(distribution, props);
        newProps.put("dockerSpecName", spec.getName());
        this.fillDockerProperties(newProps, distribution, (DockerConfiguration)spec);
        this.verifyAndAddArtifacts(newProps, distribution, artifacts);
        Path prepareDirectory = (Path)newProps.get("distributionPrepareDirectory");
        newProps.put("distributionPrepareDirectory", prepareDirectory.resolve(spec.getName()));
        Path packageDirectory = (Path)newProps.get("distributionPackageDirectory");
        newProps.put("distributionPackageDirectory", packageDirectory.resolve(spec.getName()));
        return newProps;
    }

    @Override
    protected boolean verifyAndAddArtifacts(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        if (((Docker)this.tool).getActiveSpecs().isEmpty()) {
            return super.verifyAndAddArtifacts(props, distribution);
        }
        return true;
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        if (((Docker)this.tool).getActiveSpecs().isEmpty()) {
            Set fileExtensions = ((Docker)this.tool).getSupportedExtensions();
            List<Artifact> artifacts = distribution.getArtifacts().stream().filter(Artifact::isActive).filter(artifact -> fileExtensions.stream().anyMatch(ext -> artifact.getPath().endsWith((String)ext))).collect(Collectors.toList());
            this.packageDocker(distribution, props, packageDirectory, (DockerConfiguration)this.getTool(), artifacts);
            return;
        }
        for (DockerSpec spec : ((Docker)this.tool).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.packaging", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
            this.packageDocker(distribution, newProps, packageDirectory.resolve(spec.getName()), (DockerConfiguration)spec, Collections.singletonList(spec.getArtifact()));
        }
    }

    protected void packageDocker(Distribution distribution, Map<String, Object> props, Path packageDirectory, DockerConfiguration docker, List<Artifact> artifacts) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        try {
            Path workingDirectory = this.prepareAssembly(distribution, props, packageDirectory, artifacts);
            for (String imageName : docker.getImageNames()) {
                imageName = MustacheUtils.applyTemplate((String)imageName, props);
                Command cmd = this.createBuildCommand(props, docker);
                if (!cmd.hasArg("-q") && !cmd.hasArg("--quiet")) {
                    cmd.arg("-q");
                }
                cmd.arg("-f");
                cmd.arg(workingDirectory.resolve("Dockerfile").toAbsolutePath().toString());
                cmd.arg("-t");
                cmd.arg(imageName);
                cmd.arg(workingDirectory.toAbsolutePath().toString());
                this.context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
                this.context.getLogger().info(" - {}", new Object[]{imageName});
                this.executeCommand(cmd);
            }
        }
        catch (IOException e) {
            throw new ToolProcessingException((Throwable)e);
        }
    }

    private Path prepareAssembly(Distribution distribution, Map<String, Object> props, Path packageDirectory, List<Artifact> artifacts) throws IOException, ToolProcessingException {
        this.copyPreparedFiles(distribution, props);
        Path assemblyDirectory = packageDirectory.resolve("assembly");
        Files.createDirectories(assemblyDirectory, new FileAttribute[0]);
        for (Artifact artifact : artifacts) {
            Path artifactPath = artifact.getEffectivePath(this.context);
            if (distribution.getType() == Distribution.DistributionType.NATIVE_IMAGE) {
                if (artifactPath.toString().endsWith(".zip")) {
                    FileUtils.unpack((Path)artifactPath, (Path)assemblyDirectory);
                    continue;
                }
                Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            Files.copy(artifactPath, assemblyDirectory.resolve(artifactPath.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
        return packageDirectory;
    }

    private Command createBuildCommand(Map<String, Object> props, DockerConfiguration docker) {
        Command cmd = this.createCommand("build");
        for (int i = 0; i < docker.getBuildArgs().size(); ++i) {
            String arg = (String)docker.getBuildArgs().get(i);
            if (arg.contains("{{")) {
                cmd.arg(MustacheUtils.applyTemplate((String)arg, props, (String)("arg" + i)));
                continue;
            }
            cmd.arg(arg);
        }
        return cmd;
    }

    private Command createCommand(String name) {
        return new Command("docker" + (PlatformUtils.isWindows() ? ".exe" : "")).arg("-l").arg("error").arg(name);
    }

    @Override
    public void publishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        if (((Docker)this.tool).getActiveSpecs().isEmpty()) {
            if (((Docker)this.tool).getRegistries().isEmpty()) {
                this.context.getLogger().info(RB.$((String)"docker.no.registries", (Object[])new Object[0]));
                this.publishToRepository(distribution, props);
                return;
            }
            super.publishDistribution(distribution, props);
            this.publishToRepository(distribution, props);
            return;
        }
        for (DockerSpec spec : ((Docker)this.tool).getActiveSpecs()) {
            this.context.getLogger().debug(RB.$((String)"distributions.action.publishing", (Object[])new Object[0]) + " {} spec", new Object[]{spec.getName()});
            Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
            this.publishDocker(distribution, newProps, (DockerConfiguration)spec);
        }
        this.publishToRepository(distribution, props);
    }

    private void publishToRepository(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        super.doPublishDistribution(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        this.publishDocker(distribution, props, (DockerConfiguration)this.getTool());
    }

    protected void publishDocker(Distribution distribution, Map<String, Object> props, DockerConfiguration docker) throws ToolProcessingException {
        for (Registry registry : docker.getRegistries()) {
            this.login(registry);
            for (String imageName : docker.getImageNames()) {
                this.publish(registry, imageName, props);
            }
            this.logout(registry);
        }
    }

    private void login(Registry registry) throws ToolProcessingException {
        Command cmd = this.createCommand("login");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServer());
        }
        cmd.arg("-u");
        cmd.arg(registry.getResolvedUsername());
        cmd.arg("-p");
        cmd.arg(registry.getResolvedPassword());
        ByteArrayInputStream in = new ByteArrayInputStream((registry.getResolvedPassword() + System.lineSeparator()).getBytes());
        this.context.getLogger().debug(RB.$((String)"docker.login", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommandWithInput(cmd, in);
        }
    }

    private void publish(Registry registry, String imageName, Map<String, Object> props) throws ToolProcessingException {
        int pos;
        String tag = imageName = MustacheUtils.applyTemplate((String)imageName, props);
        String serverName = registry.getServerName();
        String server = registry.getServer();
        String repositoryName = registry.getRepositoryName();
        if ("DEFAULT".equals(serverName)) {
            if (!tag.startsWith(repositoryName)) {
                pos = tag.indexOf("/");
                tag = pos < 0 ? repositoryName + "/" + tag : repositoryName + tag.substring(pos);
            }
        } else if (!tag.startsWith(server)) {
            pos = tag.indexOf("/");
            tag = pos < 0 ? server + "/" + repositoryName + "/" + tag : server + "/" + repositoryName + tag.substring(pos);
        }
        if (!tag.equals(imageName)) {
            Command cmd = this.createCommand("tag").arg(imageName).arg(tag);
            this.context.getLogger().debug(RB.$((String)"docker.tag", (Object[])new Object[0]), new Object[]{imageName, tag});
            if (!this.context.isDryrun()) {
                this.executeCommand(cmd);
            }
        }
        Command cmd = this.createCommand("push").arg("-q").arg(tag);
        this.context.getLogger().info(" - {}", new Object[]{tag});
        this.context.getLogger().debug(RB.$((String)"docker.push", (Object[])new Object[0]), new Object[]{tag, registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    private void logout(Registry registry) throws ToolProcessingException {
        Command cmd = this.createCommand("logout");
        if (StringUtils.isNotBlank((String)registry.getServer())) {
            cmd.arg(registry.getServerName());
        }
        this.context.getLogger().debug(RB.$((String)"docker.logout", (Object[])new Object[0]), new Object[]{registry.getServerName(), StringUtils.isNotBlank((String)registry.getServer()) ? " (" + registry.getServer() + ")" : ""});
        if (!this.context.isDryrun()) {
            this.executeCommand(cmd);
        }
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        this.fillDockerProperties(props, distribution, (DockerConfiguration)this.getTool());
    }

    protected void fillDockerProperties(Map<String, Object> props, Distribution distribution, DockerConfiguration docker) throws ToolProcessingException {
        props.put("dockerBaseImage", MustacheUtils.applyTemplate((String)docker.getBaseImage(), props, (String)"baseImage"));
        ArrayList labels = new ArrayList();
        docker.getLabels().forEach((label, value) -> labels.add(MustacheUtils.passThrough((String)("\"" + label + "\"=\"" + MustacheUtils.applyTemplate((String)value, (Map)props, (String)label) + "\""))));
        props.put("dockerLabels", labels);
        props.put("dockerPreCommands", docker.getPreCommands().stream().map(c -> MustacheUtils.passThrough((String)MustacheUtils.applyTemplate((String)c, (Map)props))).collect(Collectors.toList()));
        props.put("dockerPostCommands", docker.getPostCommands().stream().map(c -> MustacheUtils.passThrough((String)MustacheUtils.applyTemplate((String)c, (Map)props))).collect(Collectors.toList()));
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "executable".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("assembly").resolve(distribution.getExecutable()) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected void prepareWorkingCopy(Map<String, Object> props, Path directory, Distribution distribution) throws ToolProcessingException, IOException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        if (((Docker)this.tool).getActiveSpecs().isEmpty()) {
            for (String imageName : ((Docker)this.tool).getImageNames()) {
                this.copyDockerfiles(packageDirectory, MustacheUtils.applyTemplate((String)imageName, props), directory);
            }
        } else {
            for (DockerSpec spec : ((Docker)this.tool).getActiveSpecs()) {
                Map<String, Object> newProps = this.fillSpecProps(distribution, props, spec);
                for (String imageName : spec.getImageNames()) {
                    this.copyDockerfiles(packageDirectory.resolve(spec.getName()), MustacheUtils.applyTemplate((String)imageName, newProps), directory);
                }
            }
        }
    }

    private void copyDockerfiles(Path source, String imageName, Path directory) throws IOException {
        String[] parts = imageName.split("/");
        parts = parts[parts.length - 1].split(":");
        Path destination = directory.resolve(parts[0]).resolve(parts[1]);
        Files.createDirectories(destination, new FileAttribute[0]);
        this.prepareWorkingCopy(source, destination);
    }
}

