/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Snap;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.command.Command;

public class SnapToolProcessor
extends AbstractRepositoryToolProcessor<Snap> {
    public SnapToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
        if (((Snap)this.tool).isRemoteBuild().booleanValue()) {
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().debug(RB.$((String)"ERROR_tool_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.createSnap(distribution, props);
    }

    @Override
    protected void doPublishDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        if (((Snap)this.tool).isRemoteBuild().booleanValue()) {
            super.doPublishDistribution(distribution, props);
            return;
        }
        if (this.context.isDryrun()) {
            this.context.getLogger().error(RB.$((String)"dryrun.set", (Object[])new Object[0]));
            return;
        }
        if (PlatformUtils.isWindows()) {
            this.context.getLogger().debug(RB.$((String)"ERROR_tool_excludes_platform", (Object[])new Object[]{"Windows"}));
            return;
        }
        this.login(distribution, props);
        this.push(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        GitService gitService = this.context.getModel().getRelease().getGitService();
        String desc = this.context.getModel().getProject().getLongDescription();
        desc = Arrays.stream(desc.split(System.lineSeparator())).map(line -> "  " + line).collect(Collectors.joining(System.lineSeparator()));
        props.put("projectLongDescription", MustacheUtils.passThrough((String)("|" + System.lineSeparator() + desc)));
        props.put("snapRepoUrl", gitService.getResolvedRepoUrl(this.context.getModel(), ((Snap)this.tool).getSnap().getOwner(), ((Snap)this.tool).getSnap().getName()));
        props.put("snapRepoCloneUrl", gitService.getResolvedRepoCloneUrl(this.context.getModel(), ((Snap)this.tool).getSnap().getOwner(), ((Snap)this.tool).getSnap().getName()));
        props.put("snapBase", ((Snap)this.getTool()).getBase());
        props.put("snapGrade", ((Snap)this.getTool()).getGrade());
        props.put("snapConfinement", ((Snap)this.getTool()).getConfinement());
        props.put("snapHasPlugs", !((Snap)this.getTool()).getPlugs().isEmpty());
        props.put("snapPlugs", ((Snap)this.getTool()).getPlugs());
        props.put("snapHasSlots", !((Snap)this.getTool()).getSlots().isEmpty());
        props.put("snapSlots", ((Snap)this.getTool()).getSlots());
        props.put("snapHasLocalPlugs", !((Snap)this.getTool()).getLocalPlugs().isEmpty());
        props.put("snapLocalPlugs", ((Snap)this.getTool()).getLocalPlugs());
        props.put("snapHasLocalSlots", !((Snap)this.getTool()).getLocalSlots().isEmpty());
        props.put("snapLocalSlots", ((Snap)this.getTool()).getLocalSlots());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private void login(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Command cmd = new Command("snapcraft").arg("login").arg("--with").arg(this.context.getBasedir().resolve(distribution.getSnap().getExportedLogin()).toAbsolutePath().toString());
        this.executeCommand(cmd);
    }

    private void push(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = distribution.getName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("push").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }

    private void createSnap(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Path packageDirectory = (Path)props.get("distributionPackageDirectory");
        String version = (String)props.get("projectEffectiveVersion");
        String snapName = distribution.getName() + "-" + version + ".snap";
        Command cmd = new Command("snapcraft").arg("snap").arg("--output").arg(snapName);
        this.executeCommand(packageDirectory, cmd);
    }
}

