/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.util.JReleaserLogger;

public class Errors {
    private final Set<Error> assemblyErrors = new LinkedHashSet<Error>();
    private final Set<Error> configurationErrors = new LinkedHashSet<Error>();

    public boolean hasErrors() {
        return !this.assemblyErrors.isEmpty() || !this.configurationErrors.isEmpty();
    }

    public boolean hasAssemblyErrors() {
        return !this.assemblyErrors.isEmpty();
    }

    public boolean hasConfigurationErrors() {
        return !this.configurationErrors.isEmpty();
    }

    public void assembly(String message) {
        this.assemblyErrors.add(new Error(Kind.ASSEMBLY, message));
    }

    public void configuration(String message) {
        this.configurationErrors.add(new Error(Kind.CONFIGURATION, message));
    }

    public void logErrors(JReleaserLogger logger) {
        this.assemblyErrors.forEach(e -> logger.error(((Error)e).message));
        this.configurationErrors.forEach(e -> logger.error(((Error)e).message));
    }

    public void logErrors(PrintWriter writer) {
        this.assemblyErrors.forEach(e -> writer.println(((Error)e).message));
        this.configurationErrors.forEach(e -> writer.println(((Error)e).message));
    }

    public String asString() {
        StringWriter writer = new StringWriter();
        this.logErrors(new PrintWriter(writer));
        return writer.toString();
    }

    public static class Error {
        private final Kind kind;
        private final String message;

        public Error(Kind kind, String message) {
            this.kind = kind;
            this.message = message;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return this.kind == error.kind && this.message.equals(error.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.message});
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum Kind {
        ASSEMBLY,
        CONFIGURATION;

    }
}

