/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.Ptr;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.specific.UTF32LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Converter"})
public class RubyConverter
extends RubyObject {
    private EConv ec;
    @JRubyConstant
    public static final int INVALID_MASK = 15;
    @JRubyConstant
    public static final int INVALID_REPLACE = 2;
    @JRubyConstant
    public static final int UNDEF_MASK = 240;
    @JRubyConstant
    public static final int UNDEF_REPLACE = 32;
    @JRubyConstant
    public static final int UNDEF_HEX_CHARREF = 48;
    @JRubyConstant
    public static final int PARTIAL_INPUT = 131072;
    @JRubyConstant
    public static final int AFTER_OUTPUT = 262144;
    @JRubyConstant
    public static final int UNIVERSAL_NEWLINE_DECORATOR = 256;
    @JRubyConstant
    public static final int CRLF_NEWLINE_DECORATOR = 4096;
    @JRubyConstant
    public static final int CR_NEWLINE_DECORATOR = 8192;
    @JRubyConstant
    public static final int XML_TEXT_DECORATOR = 32768;
    @JRubyConstant
    public static final int XML_ATTR_CONTENT_DECORATOR = 65536;
    @JRubyConstant
    public static final int XML_ATTR_QUOTE_DECORATOR = 0x100000;
    public static final Map<Encoding, Encoding> NONASCII_TO_ASCII = new HashMap<Encoding, Encoding>();

    public static RubyClass createConverterClass(Ruby runtime2) {
        RubyClass converterc = runtime2.defineClassUnder("Converter", runtime2.getObject(), RubyConverter::new, runtime2.getEncoding());
        converterc.setClassIndex(ClassIndex.CONVERTER);
        converterc.setReifiedClass(RubyConverter.class);
        converterc.kindOf = new RubyModule.JavaClassKindOf(RubyConverter.class);
        converterc.defineAnnotatedMethods(RubyConverter.class);
        converterc.defineAnnotatedConstants(RubyConverter.class);
        return converterc;
    }

    public RubyConverter(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public RubyConverter(Ruby runtime2) {
        super(runtime2, runtime2.getConverter());
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, required=1, optional=2, checkArity=false)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject convpath2;
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        Ruby runtime2 = context.runtime;
        Encoding[] encs = new Encoding[]{null, null};
        byte[][] encNames = new byte[][]{null, null};
        int[] ecflags = new int[]{0};
        IRubyObject[] ecopts = new IRubyObject[]{context.nil};
        if (this.ec != null) {
            throw runtime2.newTypeError("already initialized");
        }
        if (argc == 1 && !(convpath2 = args2[0].checkArrayType()).isNil()) {
            this.ec = EncodingUtils.econvInitByConvpath(context, convpath2, encNames, encs);
            ecflags[0] = 0;
            ecopts[0] = context.nil;
        } else {
            EncodingUtils.econvArgs(context, args2, encNames, encs, ecflags, ecopts);
            this.ec = EncodingUtils.econvOpenOpts(context, encNames[0], encNames[1], ecflags[0], ecopts[0]);
        }
        if (this.ec == null) {
            throw EncodingUtils.econvOpenExc(context, encNames[0], encNames[1], ecflags[0]);
        }
        if (!EncodingUtils.DECORATOR_P(encNames[0], encNames[1])) {
            if (encs[0] == null) {
                encs[0] = EncodingDB.dummy((byte[])encNames[0]).getEncoding();
            }
            if (encs[1] == null) {
                encs[1] = EncodingDB.dummy((byte[])encNames[1]).getEncoding();
            }
        }
        this.ec.sourceEncoding = encs[0];
        this.ec.destinationEncoding = encs[1];
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.runtime, "#<Encoding::Converter: " + this.ec.sourceEncoding + " to " + this.ec.destinationEncoding + ">");
    }

    @JRubyMethod
    public IRubyObject convpath(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyArray result2 = runtime2.newArray();
        for (int i2 = 0; i2 < this.ec.numTranscoders; ++i2) {
            Transcoder tr = this.ec.elements[i2].transcoding.transcoder;
            RubyObject v = EncodingUtils.DECORATOR_P(tr.getSource(), tr.getDestination()) ? RubyString.newString(runtime2, tr.getDestination()) : runtime2.newArray(runtime2.getEncodingService().convertEncodingToRubyEncoding(runtime2.getEncodingService().findEncodingOrAliasEntry(tr.getSource()).getEncoding()), runtime2.getEncodingService().convertEncodingToRubyEncoding(runtime2.getEncodingService().findEncodingOrAliasEntry(tr.getDestination()).getEncoding()));
            result2.push(v);
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject source_encoding(ThreadContext context) {
        if (this.ec.sourceEncoding == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.ec.sourceEncoding);
    }

    @JRubyMethod
    public IRubyObject destination_encoding(ThreadContext context) {
        if (this.ec.destinationEncoding == null) {
            return context.nil;
        }
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.ec.destinationEncoding);
    }

    @JRubyMethod(required=2, optional=4, checkArity=false)
    public IRubyObject primitive_convert(ThreadContext context, IRubyObject[] args2) {
        EConvResult res;
        ByteList inBytes;
        IRubyObject opt;
        int argc = Arity.checkArgumentCount(context, args2, 2, 6);
        Ruby runtime2 = context.runtime;
        RubyString input = null;
        IRubyObject outputByteOffsetObj = context.nil;
        IRubyObject outputBytesizeObj = context.nil;
        int outputByteoffset = -1;
        int outputBytesize = 0;
        int flags2 = 0;
        int hashArg = -1;
        if (argc > 2 && !args2[2].isNil()) {
            if (argc == 3 && args2[2] instanceof RubyHash) {
                hashArg = 2;
            } else {
                outputByteOffsetObj = args2[2];
                outputByteoffset = (int)args2[2].convertToInteger().getLongValue();
            }
        }
        if (argc > 3 && !args2[3].isNil()) {
            if (argc == 4 && args2[3] instanceof RubyHash) {
                hashArg = 3;
            } else {
                outputBytesizeObj = args2[3];
                outputBytesize = (int)args2[3].convertToInteger().getLongValue();
            }
        }
        if (argc > 4 && !args2[4].isNil()) {
            if (argc > 5 && !args2[5].isNil()) {
                throw runtime2.newArgumentError(argc, 5);
            }
            if (args2[4] instanceof RubyHash) {
                hashArg = 4;
            } else {
                flags2 = (int)args2[4].convertToInteger().getLongValue();
            }
        }
        if (hashArg != -1 && !(opt = TypeConverter.checkHashType(runtime2, args2[hashArg])).isNil()) {
            IRubyObject v = ((RubyHash)opt).op_aref(context, runtime2.newSymbol("partial_input"));
            if (v.isTrue()) {
                flags2 |= 0x20000;
            }
            if ((v = ((RubyHash)opt).op_aref(context, runtime2.newSymbol("after_output"))).isTrue()) {
                flags2 |= 0x40000;
            }
        }
        if (args2[0].isNil()) {
            inBytes = new ByteList();
        } else {
            input = args2[0].convertToString();
            input.modifyAndClearCodeRange();
            inBytes = input.getByteList();
        }
        RubyString output = args2[1].convertToString();
        output.modifyAndClearCodeRange();
        ByteList outBytes = output.getByteList();
        Ptr inPtr = new Ptr();
        Ptr outPtr = new Ptr();
        if (outputBytesizeObj.isNil()) {
            outputBytesize = 16;
            if (input != null && outputBytesize < input.getByteList().getRealSize()) {
                outputBytesize = input.getByteList().getRealSize();
            }
        }
        while (true) {
            if (outputByteOffsetObj.isNil()) {
                outputByteoffset = outBytes.getRealSize();
            }
            if (outputByteoffset < 0) {
                throw runtime2.newArgumentError("negative output offset");
            }
            if (outBytes.getRealSize() < outputByteoffset) {
                throw runtime2.newArgumentError("output offset too big");
            }
            if (outputBytesize < 0) {
                throw runtime2.newArgumentError("negative bytesize");
            }
            long outputByteEnd = outputByteoffset + outputBytesize;
            if (outputByteEnd > Integer.MAX_VALUE) {
                throw runtime2.newArgumentError("output offset + bytesize too big");
            }
            outBytes.ensure((int)outputByteEnd);
            inPtr.p = inBytes.getBegin();
            outPtr.p = outBytes.getBegin() + outputByteoffset;
            int os = outPtr.p + outputBytesize;
            res = this.ec.convert(inBytes.getUnsafeBytes(), inPtr, inBytes.getRealSize() + inPtr.p, outBytes.getUnsafeBytes(), outPtr, os, flags2);
            outBytes.setRealSize(outPtr.p - outBytes.begin());
            if (input != null) {
                input.getByteList().setRealSize(inBytes.getRealSize() - (inPtr.p - inBytes.getBegin()));
                input.getByteList().setBegin(inPtr.p);
            }
            if (!outputBytesizeObj.isNil() || res != EConvResult.DestinationBufferFull) break;
            if (0x3FFFFFFF < outputBytesize) {
                throw runtime2.newArgumentError("too long conversion result");
            }
            outputBytesize *= 2;
            outputByteOffsetObj = context.nil;
        }
        if (this.ec.destinationEncoding != null) {
            outBytes.setEncoding(this.ec.destinationEncoding);
        }
        return runtime2.newSymbol(res.symbolicName());
    }

    @JRubyMethod
    public IRubyObject convert(ThreadContext context, IRubyObject srcBuffer) {
        Ruby runtime2 = context.runtime;
        RubyString orig = srcBuffer.convertToString();
        IRubyObject[] iRubyObjectArray = new IRubyObject[5];
        iRubyObjectArray[0] = orig.dup();
        RubyString dest = runtime2.newString();
        iRubyObjectArray[1] = dest;
        iRubyObjectArray[2] = context.nil;
        iRubyObjectArray[3] = context.nil;
        iRubyObjectArray[4] = runtime2.newFixnum(131072);
        IRubyObject[] newArgs = iRubyObjectArray;
        IRubyObject ret = this.primitive_convert(context, newArgs);
        if (ret instanceof RubySymbol) {
            RubySymbol retSym = (RubySymbol)ret;
            String retStr = retSym.asJavaString();
            if (retStr.equals(EConvResult.InvalidByteSequence.symbolicName()) || retStr.equals(EConvResult.UndefinedConversion.symbolicName()) || retStr.equals(EConvResult.IncompleteInput.symbolicName())) {
                throw EncodingUtils.makeEconvException(runtime2, this.ec);
            }
            if (retStr.equals(EConvResult.Finished.symbolicName())) {
                throw runtime2.newArgumentError("converter already finished");
            }
            if (!retStr.equals(EConvResult.SourceBufferEmpty.symbolicName())) {
                throw runtime2.newRuntimeError("bug: unexpected result of primitive_convert: " + retSym);
            }
        }
        return dest;
    }

    @JRubyMethod
    public IRubyObject finish(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        IRubyObject[] iRubyObjectArray = new IRubyObject[5];
        iRubyObjectArray[0] = context.nil;
        RubyString dest = runtime2.newString();
        iRubyObjectArray[1] = dest;
        iRubyObjectArray[2] = context.nil;
        iRubyObjectArray[3] = context.nil;
        iRubyObjectArray[4] = runtime2.newFixnum(0);
        IRubyObject[] newArgs = iRubyObjectArray;
        IRubyObject ret = this.primitive_convert(context, newArgs);
        if (ret instanceof RubySymbol) {
            RubySymbol retSym = (RubySymbol)ret;
            String retStr = retSym.asJavaString();
            if (retStr.equals(EConvResult.InvalidByteSequence.symbolicName()) || retStr.equals(EConvResult.UndefinedConversion.symbolicName()) || retStr.equals(EConvResult.IncompleteInput.symbolicName())) {
                throw EncodingUtils.makeEconvException(runtime2, this.ec);
            }
            if (!retStr.equals(EConvResult.Finished.symbolicName())) {
                throw runtime2.newRuntimeError("bug: unexpected result of primitive_convert");
            }
        }
        return dest;
    }

    @JRubyMethod
    public IRubyObject replacement(ThreadContext context) {
        int ret = this.ec.makeReplacement();
        if (ret == -1) {
            throw context.runtime.newUndefinedConversionError("replacement character setup failed");
        }
        return context.runtime.newString(new ByteList(this.ec.replacementString, 0, this.ec.replacementLength, context.runtime.getEncodingService().findEncodingOrAliasEntry(this.ec.replacementEncoding).getEncoding(), true));
    }

    @JRubyMethod(name={"replacement="})
    public IRubyObject replacement_set(ThreadContext context, IRubyObject arg2) {
        RubyString string2 = arg2.convertToString();
        ByteList stringBytes = string2.getByteList();
        Encoding enc = string2.getEncoding();
        int ret = this.ec.setReplacement(stringBytes.getUnsafeBytes(), stringBytes.getBegin(), stringBytes.getRealSize(), enc.getName());
        if (ret == -1) {
            throw context.runtime.newUndefinedConversionError("replacement character setup failed");
        }
        return arg2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject asciicompat_encoding(ThreadContext context, IRubyObject self2, IRubyObject strOrEnc) {
        Ruby runtime2 = context.runtime;
        EncodingService encodingService = runtime2.getEncodingService();
        Encoding encoding2 = encodingService.getEncodingFromObjectNoError(strOrEnc);
        if (encoding2 == null) {
            return context.nil;
        }
        if (encoding2.isAsciiCompatible()) {
            return context.nil;
        }
        Encoding asciiCompat = NONASCII_TO_ASCII.get(encoding2);
        if (asciiCompat == null) {
            throw runtime2.newConverterNotFoundError("no ASCII compatible encoding found for " + strOrEnc);
        }
        return encodingService.convertEncodingToRubyEncoding(asciiCompat);
    }

    @JRubyMethod
    public IRubyObject last_error(ThreadContext context) {
        RaiseException re = EncodingUtils.makeEconvException(context.runtime, this.ec);
        if (re != null) {
            return re.getException();
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject primitive_errinfo(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        IRubyObject[] values2 = new IRubyObject[]{runtime2.newSymbol(this.ec.lastError.getResult().symbolicName()), context.nil, context.nil, context.nil, context.nil};
        if (this.ec.lastError.getSource() != null) {
            values2[1] = RubyString.newString(runtime2, this.ec.lastError.getSource());
        }
        if (this.ec.lastError.getDestination() != null) {
            values2[2] = RubyString.newString(runtime2, this.ec.lastError.getDestination());
        }
        if (this.ec.lastError.getErrorBytes() != null) {
            values2[3] = RubyString.newString(runtime2, this.ec.lastError.getErrorBytes(), this.ec.lastError.getErrorBytesP(), this.ec.lastError.getErrorBytesLength());
            values2[4] = RubyString.newString(runtime2, this.ec.lastError.getErrorBytes(), this.ec.lastError.getErrorBytesP() + this.ec.lastError.getErrorBytesLength(), this.ec.lastError.getReadAgainLength());
        }
        RubyArray ary = RubyArray.newArrayMayCopy(context.runtime, values2);
        return ary;
    }

    @JRubyMethod(meta=true, required=2, optional=1, checkArity=false)
    public static IRubyObject search_convpath(ThreadContext context, IRubyObject self2, IRubyObject[] argv2) {
        final Ruby runtime2 = context.runtime;
        final IRubyObject nil = context.nil;
        final byte[][] encNames = new byte[][]{null, null};
        Encoding[] encs = new Encoding[]{null, null};
        int[] ecflags_p = new int[]{0};
        IRubyObject[] ecopts_p = new IRubyObject[]{context.nil};
        final IRubyObject[] convpath2 = new IRubyObject[]{nil};
        EncodingUtils.econvArgs(context, argv2, encNames, encs, ecflags_p, ecopts_p);
        TranscoderDB.searchPath((byte[])encNames[0], (byte[])encNames[1], (TranscoderDB.SearchPathCallback)new TranscoderDB.SearchPathCallback(){
            final EncodingService es;
            {
                this.es = runtime2.getEncodingService();
            }

            public void call(byte[] source2, byte[] destination, int depth) {
                if (convpath2[0] == nil) {
                    convpath2[0] = runtime2.newArray();
                }
                RubyObject v = EncodingUtils.DECORATOR_P(encNames[0], encNames[1]) ? RubyString.newString(runtime2, encNames[2]) : runtime2.newArray(this.es.convertEncodingToRubyEncoding(this.es.findEncodingOrAliasEntry(source2).getEncoding()), this.es.convertEncodingToRubyEncoding(this.es.findEncodingOrAliasEntry(destination).getEncoding()));
                ((RubyArray)convpath2[0]).store(depth, v);
            }
        });
        if (convpath2[0].isNil()) {
            throw EncodingUtils.econvOpenExc(context, encNames[0], encNames[1], 0);
        }
        if (EncodingUtils.decorateConvpath(context, convpath2[0], ecflags_p[0]) == -1) {
            throw EncodingUtils.econvOpenExc(context, encNames[0], encNames[1], ecflags_p[0]);
        }
        return convpath2[0];
    }

    @JRubyMethod
    public IRubyObject insert_output(ThreadContext context, IRubyObject string2) {
        Ruby runtime2 = context.runtime;
        string2 = string2.convertToString();
        byte[] insertEnc = this.ec.encodingToInsertOutput();
        ByteList stringBL = ((RubyString)(string2 = EncodingUtils.rbStrEncode(context, string2, runtime2.getEncodingService().findEncodingObject(insertEnc), 0, context.nil))).getByteList();
        int ret = this.ec.insertOutput(stringBL.getUnsafeBytes(), stringBL.getBegin(), stringBL.getRealSize(), insertEnc);
        if (ret == -1) {
            throw runtime2.newArgumentError("too big string");
        }
        return context.nil;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public IRubyObject putback(ThreadContext context, IRubyObject[] argv2) {
        int n;
        int argc = Arity.checkArgumentCount(context, argv2, 0, 1);
        Ruby runtime2 = context.runtime;
        IRubyObject max2 = argc == 0 ? context.nil : argv2[0];
        if (max2.isNil()) {
            n = this.ec.putbackable();
        } else {
            n = (int)max2.convertToInteger().getLongValue();
            int putbackable = this.ec.putbackable();
            if (putbackable < n) {
                n = putbackable;
            }
        }
        RubyString str = RubyString.newStringLight(runtime2, n);
        ByteList strBL = str.getByteList();
        this.ec.putback(strBL.getUnsafeBytes(), strBL.getBegin(), n);
        strBL.setRealSize(n);
        if (this.ec.sourceEncoding != null) {
            str.setEncoding(this.ec.sourceEncoding);
        }
        return str;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        EConv ec1 = this.ec;
        if (!(other instanceof RubyConverter)) {
            return context.nil;
        }
        EConv ec2 = ((RubyConverter)other).ec;
        return RubyBoolean.newBoolean(context, ec1.equals((Object)ec2));
    }

    static {
        NONASCII_TO_ASCII.put((Encoding)UTF16BEEncoding.INSTANCE, (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put((Encoding)UTF16LEEncoding.INSTANCE, (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put((Encoding)UTF32BEEncoding.INSTANCE, (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put((Encoding)UTF32LEEncoding.INSTANCE, (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("CP50220".getBytes())).getEncoding(), ((EncodingDB.Entry)EncodingDB.getEncodings().get("CP51932".getBytes())).getEncoding());
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("CP50221".getBytes())).getEncoding(), ((EncodingDB.Entry)EncodingDB.getEncodings().get("CP51932".getBytes())).getEncoding());
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("IBM037".getBytes())).getEncoding(), (Encoding)ISO8859_1Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-16".getBytes())).getEncoding(), (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("UTF-32".getBytes())).getEncoding(), (Encoding)UTF8Encoding.INSTANCE);
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("ISO-2022-JP".getBytes())).getEncoding(), ((EncodingDB.Entry)EncodingDB.getEncodings().get("stateless-ISO-2022-JP".getBytes())).getEncoding());
        NONASCII_TO_ASCII.put(((EncodingDB.Entry)EncodingDB.getEncodings().get("ISO-2022-JP-KDDI".getBytes())).getEncoding(), ((EncodingDB.Entry)EncodingDB.getEncodings().get("stateless-ISO-2022-JP-KDDI".getBytes())).getEncoding());
    }

    public static class InvalidByteSequenceErrorMethods {
        @JRubyMethod
        public static IRubyObject readagain_bytes(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "readagain_bytes");
        }

        @JRubyMethod(name={"incomplete_input?"})
        public static IRubyObject incomplete_input_p(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "incomplete_input");
        }

        @JRubyMethod
        public static IRubyObject error_bytes(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "error_bytes");
        }
    }

    public static class UndefinedConversionErrorMethods {
        @JRubyMethod
        public static IRubyObject error_char(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "error_char");
        }
    }

    public static class EncodingErrorMethods {
        @JRubyMethod
        public static IRubyObject source_encoding(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "source_encoding");
        }

        @JRubyMethod
        public static IRubyObject source_encoding_name(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "source_encoding_name");
        }

        @JRubyMethod
        public static IRubyObject destination_encoding(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "destination_encoding");
        }

        @JRubyMethod
        public static IRubyObject destination_encoding_name(ThreadContext context, IRubyObject self2) {
            return Helpers.getInstanceVariableNoWarn(self2, context, "destination_encoding_name");
        }
    }
}

