/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.util;

import java.lang.reflect.Field;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.hibernate.validator.constraints.URL;
import org.jsondoc.core.pojo.ApiObjectFieldDoc;

public class JSONDocHibernateValidatorProcessor {
    private static final String AssertFalse_message = "must be false";
    private static final String AssertTrue_message = "must be true";
    private static final String DecimalMax_message = "must be less than %s %s";
    private static final String DecimalMin_message = "must be greater than %s %s";
    private static final String Digits_message = "numeric value made of <%s digits>.<%s digits>)";
    private static final String Future_message = "must be in the future";
    private static final String Max_message = "must be less than or equal to %s";
    private static final String Min_message = "must be greater than or equal to %s";
    private static final String NotNull_message = "may not be null";
    private static final String Null_message = "must be null";
    private static final String Past_message = "must be in the past";
    private static final String Pattern_message = "must match %s";
    private static final String Size_message = "size must be between %s and %s";
    private static final String Email_message = "must be a well-formed email address";
    private static final String Length_message = "length must be between %s and %s";
    private static final String NotBlank_message = "may not be empty";
    private static final String NotEmpty_message = "may not be empty";
    private static final String Range_message = "must be between %s and %s";
    private static final String URL_message = "must be a valid URL";
    private static final String CreditCardNumber_message = "must be a valid credit card number";
    private static final String ScriptAssert_message = "script expression %s didn't evaluate to true";

    public static void processHibernateValidatorAnnotations(Field field, ApiObjectFieldDoc apiPojoFieldDoc) {
        try {
            Size annotation;
            Class.forName("org.hibernate.validator.constraints.NotBlank");
            if (field.isAnnotationPresent(AssertFalse.class)) {
                apiPojoFieldDoc.addFormat(AssertFalse_message);
            }
            if (field.isAnnotationPresent(AssertTrue.class)) {
                apiPojoFieldDoc.addFormat(AssertTrue_message);
            }
            if (field.isAnnotationPresent(NotNull.class)) {
                apiPojoFieldDoc.addFormat(NotNull_message);
            }
            if (field.isAnnotationPresent(Null.class)) {
                apiPojoFieldDoc.addFormat(Null_message);
            }
            if (field.isAnnotationPresent(Size.class)) {
                annotation = field.getAnnotation(Size.class);
                apiPojoFieldDoc.addFormat(String.format(Size_message, annotation.min(), annotation.max()));
            }
            if (field.isAnnotationPresent(NotBlank.class)) {
                apiPojoFieldDoc.addFormat("may not be empty");
            }
            if (field.isAnnotationPresent(NotEmpty.class)) {
                apiPojoFieldDoc.addFormat("may not be empty");
            }
            if (field.isAnnotationPresent(Length.class)) {
                annotation = field.getAnnotation(Length.class);
                apiPojoFieldDoc.addFormat(String.format(Length_message, annotation.min(), annotation.max()));
            }
            if (field.isAnnotationPresent(Range.class)) {
                annotation = field.getAnnotation(Range.class);
                apiPojoFieldDoc.addFormat(String.format(Range_message, annotation.min(), annotation.max()));
            }
            if (field.isAnnotationPresent(DecimalMax.class)) {
                annotation = field.getAnnotation(DecimalMax.class);
                apiPojoFieldDoc.addFormat(String.format(DecimalMax_message, annotation.inclusive() ? "or equal to" : "", annotation.value()));
            }
            if (field.isAnnotationPresent(DecimalMin.class)) {
                annotation = field.getAnnotation(DecimalMin.class);
                apiPojoFieldDoc.addFormat(String.format(DecimalMin_message, annotation.inclusive() ? "or equal to" : "", annotation.value()));
            }
            if (field.isAnnotationPresent(Future.class)) {
                apiPojoFieldDoc.addFormat(Future_message);
            }
            if (field.isAnnotationPresent(Past.class)) {
                apiPojoFieldDoc.addFormat(Past_message);
            }
            if (field.isAnnotationPresent(Digits.class)) {
                annotation = field.getAnnotation(Digits.class);
                apiPojoFieldDoc.addFormat(String.format(Digits_message, annotation.integer(), annotation.fraction()));
            }
            if (field.isAnnotationPresent(Max.class)) {
                annotation = field.getAnnotation(Max.class);
                apiPojoFieldDoc.addFormat(String.format(Max_message, annotation.value()));
            }
            if (field.isAnnotationPresent(Min.class)) {
                annotation = field.getAnnotation(Min.class);
                apiPojoFieldDoc.addFormat(String.format(Min_message, annotation.value()));
            }
            if (field.isAnnotationPresent(Pattern.class)) {
                annotation = field.getAnnotation(Pattern.class);
                apiPojoFieldDoc.addFormat(String.format(Pattern_message, annotation.regexp()));
            }
            if (field.isAnnotationPresent(Email.class)) {
                apiPojoFieldDoc.addFormat(Email_message);
            }
            if (field.isAnnotationPresent(URL.class)) {
                apiPojoFieldDoc.addFormat(URL_message);
            }
            if (field.isAnnotationPresent(CreditCardNumber.class)) {
                apiPojoFieldDoc.addFormat(CreditCardNumber_message);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

