/*
 * Decompiled with CFR 0.152.
 */
package org.jsondoc.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jsondoc.core.annotation.ApiObjectField;
import org.jsondoc.core.pojo.JSONDocTemplate;
import org.jsondoc.core.util.JSONDocFieldWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONDocTemplateBuilder {
    private static final Logger log = LoggerFactory.getLogger(JSONDocTemplateBuilder.class);
    private static final Map<Class<?>, Class<?>> primitives = new HashMap();

    public static JSONDocTemplate build(Class<?> clazz, Set<Class<?>> jsondocObjects) {
        JSONDocTemplate jsonDocTemplate = new JSONDocTemplate();
        if (jsondocObjects.contains(clazz)) {
            try {
                Set<JSONDocFieldWrapper> fields = JSONDocTemplateBuilder.getAllDeclaredFields(clazz);
                for (JSONDocFieldWrapper jsondocFieldWrapper : fields) {
                    Field field = jsondocFieldWrapper.getField();
                    if (Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) continue;
                    String fieldName = field.getName();
                    ApiObjectField apiObjectField = field.getAnnotation(ApiObjectField.class);
                    if (apiObjectField != null && !apiObjectField.name().isEmpty()) {
                        fieldName = apiObjectField.name();
                    }
                    Object value = field.getType().equals(clazz) || apiObjectField != null && !apiObjectField.processtemplate() ? JSONDocTemplateBuilder.getValue(Object.class, field.getGenericType(), fieldName, jsondocObjects) : JSONDocTemplateBuilder.getValue(field.getType(), field.getGenericType(), fieldName, jsondocObjects);
                    jsonDocTemplate.put(fieldName, value);
                }
            }
            catch (Exception e) {
                log.error("Error in JSONDocTemplate creation for class [" + clazz.getCanonicalName() + "]", (Throwable)e);
            }
        }
        return jsonDocTemplate;
    }

    private static Object getValue(Class<?> fieldClass, Type fieldGenericType, String fieldName, Set<Class<?>> jsondocObjects) {
        if (fieldClass.isPrimitive()) {
            return JSONDocTemplateBuilder.getValue(JSONDocTemplateBuilder.wrap(fieldClass), null, fieldName, jsondocObjects);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new HashMap();
        }
        if (Number.class.isAssignableFrom(fieldClass)) {
            return new Integer(0);
        }
        if (String.class.isAssignableFrom(fieldClass) || fieldClass.isEnum()) {
            return new String("");
        }
        if (Boolean.class.isAssignableFrom(fieldClass)) {
            return new Boolean("true");
        }
        if (fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass)) {
            return new ArrayList();
        }
        return JSONDocTemplateBuilder.build(fieldClass, jsondocObjects);
    }

    private static Set<JSONDocFieldWrapper> getAllDeclaredFields(Class<?> clazz) {
        TreeSet<JSONDocFieldWrapper> fields = new TreeSet<JSONDocFieldWrapper>();
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        if (clazz.isEnum()) {
            return fields;
        }
        declaredFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Field field : declaredFields) {
            if (field.isAnnotationPresent(ApiObjectField.class)) {
                ApiObjectField annotation = field.getAnnotation(ApiObjectField.class);
                fields.add(new JSONDocFieldWrapper(field, annotation.order()));
                continue;
            }
            fields.add(new JSONDocFieldWrapper(field, Integer.MAX_VALUE));
        }
        if (clazz.getSuperclass() != null) {
            fields.addAll(JSONDocTemplateBuilder.getAllDeclaredFields(clazz.getSuperclass()));
        }
        return fields;
    }

    private static <T> Class<T> wrap(Class<T> clazz) {
        return clazz.isPrimitive() ? primitives.get(clazz) : clazz;
    }

    static {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, String.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Void.TYPE, Void.class);
    }
}

