/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import org.jsr107.ri.annotations.AbstractKeyedCacheInterceptor;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.CacheResultMethodDetails;
import org.jsr107.ri.annotations.ClassFilter;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;

public abstract class AbstractCacheResultInterceptor<I>
extends AbstractKeyedCacheInterceptor<I, CacheResultMethodDetails> {
    public final Object cacheResult(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheKeyInvocationContext<Annotation> cacheKeyInvocationContext = cacheContextSource.getCacheKeyInvocationContext(invocation);
        CacheResultMethodDetails methodDetails = (CacheResultMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_RESULT);
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        Cache<Object, Throwable> exceptionCache = this.getExceptionCache(cacheKeyInvocationContext, methodDetails);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        CacheResult cacheResultAnnotation = (CacheResult)methodDetails.getCacheAnnotation();
        if (!cacheResultAnnotation.skipGet()) {
            result = cache.get((Object)cacheKey);
            if (result != null) {
                return result;
            }
            this.checkForCachedException(exceptionCache, cacheKey);
        }
        try {
            result = this.proceed(invocation);
            if (result != null) {
                cache.put((Object)cacheKey, result);
            }
            return result;
        }
        catch (Throwable t) {
            this.cacheException(exceptionCache, cacheKey, cacheResultAnnotation, t);
            throw t;
        }
    }

    protected void checkForCachedException(Cache<Object, Throwable> exceptionCache, GeneratedCacheKey cacheKey) throws Throwable {
        if (exceptionCache == null) {
            return;
        }
        Throwable throwable = (Throwable)exceptionCache.get((Object)cacheKey);
        if (throwable != null) {
            throw throwable;
        }
    }

    protected void cacheException(Cache<Object, Throwable> exceptionCache, GeneratedCacheKey cacheKey, CacheResult cacheResultAnnotation, Throwable t) {
        Class[] nonCachedExceptions;
        if (exceptionCache == null) {
            return;
        }
        Class[] cachedExceptions = cacheResultAnnotation.cachedExceptions();
        boolean included = ClassFilter.isIncluded(t, cachedExceptions, nonCachedExceptions = cacheResultAnnotation.nonCachedExceptions(), true);
        if (included) {
            exceptionCache.put((Object)cacheKey, (Object)t);
        }
    }

    protected Cache<Object, Throwable> getExceptionCache(InternalCacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext, CacheResultMethodDetails methodDetails) {
        CacheResolver exceptionCacheResolver = methodDetails.getExceptionCacheResolver();
        if (exceptionCacheResolver != null) {
            return exceptionCacheResolver.resolveCache(cacheKeyInvocationContext);
        }
        return null;
    }
}

