/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.ri.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.cache.annotation.CacheInvocationParameter;
import org.jsr107.ri.annotations.CacheInvocationParameterImpl;
import org.jsr107.ri.annotations.CacheParameterDetails;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.StaticCacheInvocationContext;

public abstract class AbstractInternalCacheInvocationContext<I, A extends Annotation>
implements InternalCacheInvocationContext<A> {
    private final StaticCacheInvocationContext<A> abstractStaticCacheInvocationContext;
    private final I invocation;
    private final CacheInvocationParameter[] allParameters;

    public AbstractInternalCacheInvocationContext(StaticCacheInvocationContext<A> staticCacheInvocationContext, I invocation) {
        this.abstractStaticCacheInvocationContext = staticCacheInvocationContext;
        this.invocation = invocation;
        Object[] parameters = this.getParameters(invocation);
        List<CacheParameterDetails> allParameterDetails = staticCacheInvocationContext.getAllParameters();
        this.allParameters = new CacheInvocationParameter[allParameterDetails.size()];
        for (CacheParameterDetails parameterDetails : allParameterDetails) {
            int parameterPosition = parameterDetails.getParameterPosition();
            this.allParameters[parameterPosition] = new CacheInvocationParameterImpl(parameterDetails, parameters[parameterPosition]);
        }
    }

    protected abstract Object[] getParameters(I var1);

    protected abstract Method getMethod(I var1);

    protected abstract Object getTarget(I var1);

    @Override
    public StaticCacheInvocationContext<A> getStaticCacheInvocationContext() {
        return this.abstractStaticCacheInvocationContext;
    }

    public Set<Annotation> getAnnotations() {
        return this.abstractStaticCacheInvocationContext.getAnnotations();
    }

    public A getCacheAnnotation() {
        return (A)this.abstractStaticCacheInvocationContext.getCacheAnnotation();
    }

    public String getCacheName() {
        return this.abstractStaticCacheInvocationContext.getCacheName();
    }

    public Method getMethod() {
        return this.getMethod(this.invocation);
    }

    public Object getTarget() {
        return this.getTarget(this.invocation);
    }

    public CacheInvocationParameter[] getAllParameters() {
        return (CacheInvocationParameter[])this.allParameters.clone();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.invocation.getClass())) {
            return cls.cast(this.invocation);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }
}

