/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.parser.parboiled.node;

import org.jtwig.model.expression.VariableExpression;
import org.jtwig.model.position.Position;
import org.jtwig.model.tree.BlockNode;
import org.jtwig.model.tree.Node;
import org.jtwig.parser.parboiled.ParserContext;
import org.jtwig.parser.parboiled.base.LexicParser;
import org.jtwig.parser.parboiled.base.LimitsParser;
import org.jtwig.parser.parboiled.base.PositionTrackerParser;
import org.jtwig.parser.parboiled.base.SpacingParser;
import org.jtwig.parser.parboiled.expression.VariableExpressionParser;
import org.jtwig.parser.parboiled.model.Keyword;
import org.jtwig.parser.parboiled.node.CompositeNodeParser;
import org.jtwig.parser.parboiled.node.NodeParser;
import org.parboiled.Rule;

public class BlockNodeParser
extends NodeParser<BlockNode> {
    public BlockNodeParser(ParserContext context) {
        super(BlockNodeParser.class, context);
    }

    @Override
    public Rule NodeRule() {
        LimitsParser limitsParser = this.parserContext().parser(LimitsParser.class);
        PositionTrackerParser positionTrackerParser = this.parserContext().parser(PositionTrackerParser.class);
        LexicParser lexicParser = this.parserContext().parser(LexicParser.class);
        SpacingParser spacingParser = this.parserContext().parser(SpacingParser.class);
        VariableExpressionParser variableExpressionParser = this.parserContext().parser(VariableExpressionParser.class);
        CompositeNodeParser compositeNodeParser = this.parserContext().parser(CompositeNodeParser.class);
        return this.Sequence(positionTrackerParser.PushPosition(), this.Sequence(limitsParser.startCode(), spacingParser.Spacing(), new Object[]{lexicParser.Keyword(Keyword.BLOCK), spacingParser.Mandatory(), this.Mandatory(variableExpressionParser.ExpressionRule(), "Block identifier not specified"), spacingParser.Spacing(), this.Mandatory(limitsParser.endCode(), "Missing end of code island")}), new Object[]{compositeNodeParser.NodeRule(), this.Mandatory(this.Sequence(limitsParser.startCode(), spacingParser.Spacing(), new Object[]{lexicParser.Keyword(Keyword.END_BLOCK), this.Optional(spacingParser.Mandatory(), variableExpressionParser.ExpressionRule(), new Object[]{this.throwExceptionIfNonSameVariableName()}), spacingParser.Spacing(), this.Mandatory(limitsParser.endCode(), "Missing end of code island")}), "Missing endblock tag"), this.push(new BlockNode((Position)positionTrackerParser.pop(2), (VariableExpression)variableExpressionParser.pop(1), (Node)compositeNodeParser.pop()))});
    }

    boolean throwExceptionIfNonSameVariableName() {
        VariableExpressionParser variableExpressionParser = this.parserContext().parser(VariableExpressionParser.class);
        VariableExpression expression = (VariableExpression)variableExpressionParser.pop();
        VariableExpression original = (VariableExpression)variableExpressionParser.peek(1);
        if (!expression.getIdentifier().equals(original.getIdentifier())) {
            this.addError(String.format("Expecting block '%s' to end with the same identifier but found '%s' instead", original.getIdentifier(), expression.getIdentifier()));
        }
        return true;
    }
}

