/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.render.expression.calculator.operation.binary.calculators.selection;

import com.google.common.base.Optional;
import org.jtwig.model.expression.ConstantExpression;
import org.jtwig.model.expression.Expression;
import org.jtwig.model.expression.FunctionExpression;
import org.jtwig.model.expression.VariableExpression;

public class SelectionErrorMessageGenerator {
    public String explain(Expression leftOperand, Expression rightOperand) {
        Optional<String> leftName = this.getName(leftOperand);
        Optional<String> rightName = this.getName(rightOperand);
        if (leftName.isPresent()) {
            if (rightName.isPresent()) {
                return String.format("Cannot extract property '%s' out of '%s'", rightName.get(), leftName.get());
            }
            return String.format("Cannot extract property out of '%s'", leftName.get());
        }
        if (rightName.isPresent()) {
            return String.format("Cannot extract property '%s'", rightName.get());
        }
        return "Cannot extract property";
    }

    private Optional<String> getName(Expression expression) {
        if (expression instanceof VariableExpression) {
            return Optional.of((Object)((VariableExpression)expression).getIdentifier());
        }
        if (expression instanceof FunctionExpression) {
            return Optional.of((Object)((FunctionExpression)expression).getFunctionIdentifier());
        }
        if (expression instanceof ConstantExpression) {
            return Optional.of((Object)String.valueOf(((ConstantExpression)expression).getConstantValue()));
        }
        return Optional.absent();
    }
}

