/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.translate.spring;

import com.google.common.base.Supplier;
import org.jtwig.translate.TranslateExtension;
import org.jtwig.translate.configuration.TranslateConfiguration;
import org.jtwig.translate.configuration.TranslateConfigurationBuilder;
import org.jtwig.translate.message.source.cache.CachedMessageSourceFactory;
import org.jtwig.translate.message.source.cache.MessageSourceCache;
import org.jtwig.translate.message.source.factory.MessageSourceFactory;
import org.jtwig.translate.spring.SpringTranslateExtensionConfiguration;
import org.jtwig.translate.spring.adapters.CurrentLocaleResolverSpringAdapter;
import org.jtwig.translate.spring.adapters.SpringMessageSourceFactory;
import org.springframework.web.servlet.LocaleResolver;

public class SpringTranslateExtension
extends TranslateExtension {
    public SpringTranslateExtension(SpringTranslateExtensionConfiguration configuration) {
        super(SpringTranslateExtension.createConfiguration(configuration));
    }

    private static TranslateConfiguration createConfiguration(SpringTranslateExtensionConfiguration configuration) {
        TranslateConfigurationBuilder configurationBuilder = TranslateConfigurationBuilder.translateConfiguration();
        if (configuration.getCache().isPresent()) {
            configurationBuilder.withMessageSourceFactory((MessageSourceFactory)CachedMessageSourceFactory.cachedWith((MessageSourceCache)((MessageSourceCache)configuration.getCache().get()), (MessageSourceFactory)SpringMessageSourceFactory.create(configuration.getMessageSource())));
        } else {
            configurationBuilder.withMessageSourceFactory((MessageSourceFactory)SpringMessageSourceFactory.create(configuration.getMessageSource()));
        }
        if (configuration.getLocaleResolver().isPresent()) {
            configurationBuilder.withCurrentLocaleSupplier((Supplier)new CurrentLocaleResolverSpringAdapter((LocaleResolver)configuration.getLocaleResolver().get()));
        }
        return configurationBuilder.build();
    }
}

