/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.translate.spring;

import com.google.common.base.Optional;
import org.jtwig.translate.message.source.cache.MessageSourceCache;
import org.jtwig.translate.message.source.cache.PersistentMessageSourceCache;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.LocaleResolver;

public class SpringTranslateExtensionConfiguration {
    private final MessageSource messageSource;
    private final Optional<LocaleResolver> localeResolver;
    private final Optional<MessageSourceCache> cache;

    public static Builder builder(MessageSource messageSource) {
        return new Builder(messageSource);
    }

    SpringTranslateExtensionConfiguration(MessageSource messageSource, Optional<LocaleResolver> localeResolver, Optional<MessageSourceCache> cache) {
        this.messageSource = messageSource;
        this.localeResolver = localeResolver;
        this.cache = cache;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Optional<LocaleResolver> getLocaleResolver() {
        return this.localeResolver;
    }

    public Optional<MessageSourceCache> getCache() {
        return this.cache;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<SpringTranslateExtensionConfiguration> {
        private final MessageSource messageSource;
        private Optional<LocaleResolver> localeResolver = Optional.absent();
        private Optional<MessageSourceCache> cache = Optional.of((Object)PersistentMessageSourceCache.persistentCache());

        Builder(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public Builder withLocaleResolver(LocaleResolver localeResolver) {
            this.localeResolver = Optional.fromNullable((Object)localeResolver);
            return this;
        }

        public Builder withCache(MessageSourceCache cache) {
            this.cache = Optional.fromNullable((Object)cache);
            return this;
        }

        public Builder withoutCache() {
            this.cache = Optional.absent();
            return this;
        }

        public SpringTranslateExtensionConfiguration build() {
            return new SpringTranslateExtensionConfiguration(this.messageSource, this.localeResolver, this.cache);
        }
    }
}

