/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.testkit.engine.EngineExecutionResults;
import org.junit.platform.testkit.engine.ExecutionRecorder;

@API(status=API.Status.MAINTAINED, since="1.7")
public final class EngineTestKit {
    public static Builder engine(String engineId) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.engine(EngineTestKit.loadTestEngine(engineId.trim()));
    }

    public static Builder engine(TestEngine testEngine) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        return new Builder(testEngine);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7")
    public static EngineExecutionResults execute(String engineId, EngineDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.execute(EngineTestKit.loadTestEngine(engineId.trim()), discoveryRequest);
    }

    public static EngineExecutionResults execute(String engineId, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notBlank((String)engineId, (String)"TestEngine ID must not be null or blank");
        return EngineTestKit.execute(EngineTestKit.loadTestEngine(engineId.trim()), discoveryRequest);
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.7")
    public static EngineExecutionResults execute(TestEngine testEngine, EngineDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        ExecutionRecorder executionRecorder = new ExecutionRecorder();
        EngineTestKit.executeDirectly(testEngine, discoveryRequest, executionRecorder);
        return executionRecorder.getExecutionResults();
    }

    public static EngineExecutionResults execute(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)testEngine, (String)"TestEngine must not be null");
        Preconditions.notNull((Object)discoveryRequest, (String)"EngineDiscoveryRequest must not be null");
        ExecutionRecorder executionRecorder = new ExecutionRecorder();
        EngineTestKit.executeUsingLauncherOrchestration(testEngine, discoveryRequest, executionRecorder);
        return executionRecorder.getExecutionResults();
    }

    private static void executeDirectly(TestEngine testEngine, EngineDiscoveryRequest discoveryRequest, EngineExecutionListener listener) {
        UniqueId engineUniqueId = UniqueId.forEngine((String)testEngine.getId());
        TestDescriptor engineTestDescriptor = testEngine.discover(discoveryRequest, engineUniqueId);
        ExecutionRequest request = ExecutionRequest.create((TestDescriptor)engineTestDescriptor, (EngineExecutionListener)listener, (ConfigurationParameters)discoveryRequest.getConfigurationParameters(), (OutputDirectoryProvider)discoveryRequest.getOutputDirectoryProvider());
        testEngine.execute(request);
    }

    private static void executeUsingLauncherOrchestration(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest, EngineExecutionListener listener) {
        LauncherDiscoveryResult discoveryResult = new EngineDiscoveryOrchestrator(Collections.singleton(testEngine), Collections.emptySet()).discover(discoveryRequest, EngineDiscoveryOrchestrator.Phase.EXECUTION);
        TestDescriptor engineTestDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
        Preconditions.notNull((Object)engineTestDescriptor, (String)"TestEngine did not yield a TestDescriptor");
        new EngineExecutionOrchestrator().execute(discoveryResult, listener);
    }

    private static TestEngine loadTestEngine(String engineId) {
        Iterable testEngines = new ServiceLoaderTestEngineRegistry().loadTestEngines();
        return CollectionUtils.toStream((Object)testEngines).filter(engine -> engineId.equals(engine.getId())).findFirst().orElseThrow(() -> new PreconditionViolationException(String.format("Failed to load TestEngine with ID [%s]", engineId)));
    }

    private EngineTestKit() {
    }

    public static final class Builder {
        private final LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().enableImplicitConfigurationParameters(false).outputDirectoryProvider(DisabledOutputDirectoryProvider.INSTANCE);
        private final TestEngine testEngine;

        private Builder(TestEngine testEngine) {
            this.testEngine = testEngine;
        }

        public Builder selectors(DiscoverySelector ... selectors) {
            this.requestBuilder.selectors(selectors);
            return this;
        }

        @Deprecated
        @API(status=API.Status.DEPRECATED, since="1.7")
        public Builder filters(DiscoveryFilter<?> ... filters) {
            this.requestBuilder.filters(filters);
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder filters(Filter<?> ... filters) {
            this.requestBuilder.filters(filters);
            return this;
        }

        public Builder configurationParameter(String key, String value) {
            this.requestBuilder.configurationParameter(key, value);
            return this;
        }

        public Builder configurationParameters(Map<String, String> configurationParameters) {
            this.requestBuilder.configurationParameters(configurationParameters);
            return this;
        }

        @API(status=API.Status.STABLE, since="1.10")
        public Builder enableImplicitConfigurationParameters(boolean enabled) {
            this.requestBuilder.enableImplicitConfigurationParameters(enabled);
            return this;
        }

        @API(status=API.Status.EXPERIMENTAL, since="1.12")
        public Builder outputDirectoryProvider(OutputDirectoryProvider outputDirectoryProvider) {
            this.requestBuilder.outputDirectoryProvider(outputDirectoryProvider);
            return this;
        }

        public EngineExecutionResults execute() {
            LauncherDiscoveryRequest request = this.requestBuilder.build();
            ExecutionRecorder executionRecorder = new ExecutionRecorder();
            EngineTestKit.executeUsingLauncherOrchestration(this.testEngine, request, executionRecorder);
            return executionRecorder.getExecutionResults();
        }

        private static class DisabledOutputDirectoryProvider
        implements OutputDirectoryProvider {
            public static final OutputDirectoryProvider INSTANCE = new DisabledOutputDirectoryProvider();
            private static final String FAILURE_MESSAGE = "Writing outputs is disabled by default when using EngineTestKit. To enable, configure a custom OutputDirectoryProvider via EngineTestKit#outputDirectoryProvider.";

            private DisabledOutputDirectoryProvider() {
            }

            public Path getRootDirectory() {
                throw new JUnitException(FAILURE_MESSAGE);
            }

            public Path createOutputDirectory(TestDescriptor testDescriptor) {
                throw new JUnitException(FAILURE_MESSAGE);
            }
        }
    }
}

