/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apiguardian.api.API;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.testkit.engine.EngineExecutionResults;
import org.junit.platform.testkit.engine.Event;

@API(status=API.Status.MAINTAINED, since="1.7")
public class ExecutionRecorder
implements EngineExecutionListener {
    private final List<Event> events = new CopyOnWriteArrayList<Event>();

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.events.add(Event.dynamicTestRegistered(testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.events.add(Event.executionSkipped(testDescriptor, reason));
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.events.add(Event.executionStarted(testDescriptor));
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.events.add(Event.executionFinished(testDescriptor, testExecutionResult));
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.events.add(Event.reportingEntryPublished(testDescriptor, entry));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.12")
    public void fileEntryPublished(TestDescriptor testDescriptor, FileEntry file) {
        this.events.add(Event.fileEntryPublished(testDescriptor, file));
    }

    public EngineExecutionResults getExecutionResults() {
        return new EngineExecutionResults(this.events);
    }
}

