/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.testkit.engine;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestExecutionResult;

@API(status=API.Status.MAINTAINED, since="1.7")
public class TerminationInfo {
    private final boolean skipped;
    private final String skipReason;
    private final TestExecutionResult testExecutionResult;

    public static TerminationInfo skipped(String reason) {
        return new TerminationInfo(true, reason, null);
    }

    public static TerminationInfo executed(TestExecutionResult testExecutionResult) {
        Preconditions.notNull((Object)testExecutionResult, (String)"TestExecutionResult must not be null");
        return new TerminationInfo(false, null, testExecutionResult);
    }

    private TerminationInfo(boolean skipped, String skipReason, TestExecutionResult testExecutionResult) {
        boolean executed = testExecutionResult != null;
        Preconditions.condition((boolean)(skipped ^ executed), (String)"TerminationInfo must represent either a skipped execution or a TestExecutionResult but not both");
        this.skipped = skipped;
        this.skipReason = skipReason;
        this.testExecutionResult = testExecutionResult;
    }

    public boolean skipped() {
        return this.skipped;
    }

    public boolean notSkipped() {
        return !this.skipped();
    }

    public boolean executed() {
        return this.testExecutionResult != null;
    }

    public String getSkipReason() throws UnsupportedOperationException {
        if (this.skipped()) {
            return this.skipReason;
        }
        throw new UnsupportedOperationException("No skip reason contained in this TerminationInfo");
    }

    public TestExecutionResult getExecutionResult() throws UnsupportedOperationException {
        if (this.executed()) {
            return this.testExecutionResult;
        }
        throw new UnsupportedOperationException("No TestExecutionResult contained in this TerminationInfo");
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        if (this.skipped()) {
            builder.append("skipped", (Object)true).append("reason", (Object)this.skipReason);
        } else {
            builder.append("executed", (Object)true).append("result", (Object)this.testExecutionResult);
        }
        return builder.toString();
    }
}

