/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.MavenEmbedderException;
import hudson.maven.MavenEmbedderUtils;
import hudson.maven.MavenRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsConfigurationException;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenEmbedder {
    public static final String userHome = System.getProperty("user.home");
    private MavenXpp3Reader modelReader;
    private MavenXpp3Writer modelWriter;
    private final File mavenHome;
    private final PlexusContainer plexusContainer;
    private final MavenRequest mavenRequest;
    private MavenExecutionRequest mavenExecutionRequest;
    private final MavenSession mavenSession;
    public static final String DEFAULT_LOCAL_REPO_ID = "local";
    public static final String DEFAULT_LAYOUT_ID = "default";

    public MavenEmbedder(File mavenHome, MavenRequest mavenRequest) throws MavenEmbedderException {
        this(mavenHome, mavenRequest, MavenEmbedderUtils.buildPlexusContainer(mavenHome, mavenRequest));
    }

    public MavenEmbedder(ClassLoader mavenClassLoader, ClassLoader parent, MavenRequest mavenRequest) throws MavenEmbedderException {
        this(null, mavenRequest, MavenEmbedderUtils.buildPlexusContainer(mavenClassLoader, parent, mavenRequest));
    }

    private MavenEmbedder(File mavenHome, MavenRequest mavenRequest, PlexusContainer plexusContainer) throws MavenEmbedderException {
        this.mavenHome = mavenHome;
        this.mavenRequest = mavenRequest;
        this.plexusContainer = plexusContainer;
        try {
            this.buildMavenExecutionRequest();
            RepositorySystemSession rss = ((DefaultMaven)this.lookup(Maven.class)).newRepositorySession(this.mavenExecutionRequest);
            this.mavenSession = new MavenSession(plexusContainer, rss, this.mavenExecutionRequest, (MavenExecutionResult)new DefaultMavenExecutionResult());
            this.lookup(LegacySupport.class).setSession(this.mavenSession);
        }
        catch (MavenEmbedderException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public MavenEmbedder(ClassLoader mavenClassLoader, MavenRequest mavenRequest) throws MavenEmbedderException {
        this(mavenClassLoader, null, mavenRequest);
    }

    private void buildMavenExecutionRequest() throws MavenEmbedderException, ComponentLookupException {
        this.mavenExecutionRequest = new DefaultMavenExecutionRequest();
        if (this.mavenRequest.getGlobalSettingsFile() != null) {
            this.mavenExecutionRequest.setGlobalSettingsFile(this.mavenExecutionRequest.getGlobalSettingsFile());
        }
        if (this.mavenExecutionRequest.getUserSettingsFile() != null) {
            this.mavenExecutionRequest.setUserSettingsFile(new File(this.mavenRequest.getUserSettingsFile()));
        }
        try {
            this.lookup(MavenExecutionRequestPopulator.class).populateFromSettings(this.mavenExecutionRequest, this.getSettings());
            this.lookup(MavenExecutionRequestPopulator.class).populateDefaults(this.mavenExecutionRequest);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        ArtifactRepository localRepository = this.getLocalRepository();
        this.mavenExecutionRequest.setLocalRepository(localRepository);
        this.mavenExecutionRequest.setLocalRepositoryPath(localRepository.getBasedir());
        this.mavenExecutionRequest.setOffline(this.mavenExecutionRequest.isOffline());
        this.mavenExecutionRequest.setUpdateSnapshots(this.mavenRequest.isUpdateSnapshots());
        this.mavenExecutionRequest.setTransferListener(this.mavenRequest.getTransferListener());
        this.mavenExecutionRequest.setCacheNotFound(this.mavenRequest.isCacheNotFound());
        this.mavenExecutionRequest.setCacheTransferError(true);
        this.mavenExecutionRequest.setUserProperties(this.mavenRequest.getUserProperties());
        this.mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        if (this.mavenRequest.getSystemProperties() != null) {
            this.mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)this.mavenRequest.getSystemProperties());
        }
        this.mavenExecutionRequest.getSystemProperties().putAll((Map<?, ?>)this.getEnvVars());
        if (this.mavenHome != null) {
            this.mavenExecutionRequest.getSystemProperties().put("maven.home", this.mavenHome.getAbsolutePath());
        }
        if (this.mavenRequest.getProfiles() != null && !this.mavenRequest.getProfiles().isEmpty()) {
            for (String id : this.mavenRequest.getProfiles()) {
                Profile p = new Profile();
                p.setId(id);
                p.setSource("cli");
                this.mavenExecutionRequest.addProfile(p);
                this.mavenExecutionRequest.addActiveProfile(id);
            }
        }
        this.mavenExecutionRequest.setLoggingLevel(0);
        this.lookup(Logger.class).setThreshold(0);
        this.mavenExecutionRequest.setExecutionListener(this.mavenRequest.getExecutionListener()).setInteractiveMode(this.mavenRequest.isInteractive()).setGlobalChecksumPolicy(this.mavenRequest.getGlobalChecksumPolicy()).setGoals(this.mavenRequest.getGoals());
        if (this.mavenRequest.getPom() != null) {
            this.mavenExecutionRequest.setPom(new File(this.mavenRequest.getPom()));
        }
        if (this.mavenRequest.getWorkspaceReader() != null) {
            this.mavenExecutionRequest.setWorkspaceReader(this.mavenRequest.getWorkspaceReader());
        }
    }

    private Properties getEnvVars() {
        Properties envVars = new Properties();
        boolean caseSensitive = !Os.isFamily((String)"windows");
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = "env." + (caseSensitive ? entry.getKey() : entry.getKey().toUpperCase(Locale.ENGLISH));
            envVars.setProperty(key, entry.getValue());
        }
        return envVars;
    }

    public Settings getSettings() throws MavenEmbedderException, ComponentLookupException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        if (this.mavenRequest.getGlobalSettingsFile() != null) {
            settingsBuildingRequest.setGlobalSettingsFile(new File(this.mavenRequest.getGlobalSettingsFile()));
        } else {
            settingsBuildingRequest.setGlobalSettingsFile(MavenCli.DEFAULT_GLOBAL_SETTINGS_FILE);
        }
        if (this.mavenRequest.getUserSettingsFile() != null) {
            settingsBuildingRequest.setUserSettingsFile(new File(this.mavenRequest.getUserSettingsFile()));
        } else {
            settingsBuildingRequest.setUserSettingsFile(MavenCli.DEFAULT_USER_SETTINGS_FILE);
        }
        settingsBuildingRequest.setUserProperties(this.mavenRequest.getUserProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)System.getProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)this.mavenRequest.getSystemProperties());
        settingsBuildingRequest.getSystemProperties().putAll((Map<?, ?>)this.getEnvVars());
        try {
            return this.lookup(SettingsBuilder.class).build((SettingsBuildingRequest)settingsBuildingRequest).getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public ArtifactRepository getLocalRepository() throws ComponentLookupException {
        try {
            String localRepositoryPath = this.getLocalRepositoryPath();
            if (localRepositoryPath != null) {
                return this.lookup(RepositorySystem.class).createLocalRepository(new File(localRepositoryPath));
            }
            return this.lookup(RepositorySystem.class).createLocalRepository(RepositorySystem.defaultUserLocalRepository);
        }
        catch (InvalidRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getLocalRepositoryPath() {
        String path = null;
        try {
            Settings settings = this.getSettings();
            path = settings.getLocalRepository();
        }
        catch (MavenEmbedderException e) {
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        if (this.mavenRequest.getLocalRepositoryPath() != null) {
            path = this.mavenRequest.getLocalRepositoryPath();
        }
        if (path == null) {
            path = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        return path;
    }

    public Model readModel(File model) throws XmlPullParserException, FileNotFoundException, IOException {
        return this.modelReader.read((Reader)new FileReader(model));
    }

    public void writeModel(Writer writer, Model model) throws IOException {
        this.modelWriter.write(writer, model);
    }

    public MavenProject readProject(File mavenProject) throws ProjectBuildingException, MavenEmbedderException {
        List<MavenProject> projects = this.readProjects(mavenProject, false);
        return projects == null || projects.isEmpty() ? null : projects.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> readProjects(File mavenProject, boolean recursive) throws ProjectBuildingException, MavenEmbedderException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            List<ProjectBuildingResult> results = this.buildProjects(mavenProject, recursive);
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(results.size());
            for (ProjectBuildingResult result : results) {
                projects.add(result.getProject());
            }
            ArrayList<MavenProject> arrayList = projects;
            return arrayList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    public List<ProjectBuildingResult> buildProjects(File mavenProject, boolean recursive) throws ProjectBuildingException, MavenEmbedderException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            List results;
            Thread.currentThread().setContextClassLoader((ClassLoader)this.plexusContainer.getContainerRealm());
            ProjectBuilder projectBuilder = this.lookup(ProjectBuilder.class);
            ProjectBuildingRequest projectBuildingRequest = this.mavenExecutionRequest.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(this.mavenRequest.getValidationLevel());
            RepositorySystemSession repositorySystemSession = this.buildRepositorySystemSession();
            projectBuildingRequest.setRepositorySession(repositorySystemSession);
            projectBuildingRequest.setProcessPlugins(this.mavenRequest.isProcessPlugins());
            projectBuildingRequest.setResolveDependencies(this.mavenRequest.isResolveDependencies());
            List list = results = projectBuilder.build(Arrays.asList(mavenProject), recursive, projectBuildingRequest);
            return list;
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private RepositorySystemSession buildRepositorySystemSession() throws ComponentLookupException {
        DefaultMaven defaultMaven = (DefaultMaven)this.plexusContainer.lookup(Maven.class);
        return defaultMaven.newRepositorySession(this.mavenExecutionRequest);
    }

    public List<MavenProject> collectProjects(File basedir, String[] includes, String[] excludes) throws MojoExecutionException, MavenEmbedderException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        List<File> poms = this.getPomFiles(basedir, includes, excludes);
        for (File pom : poms) {
            try {
                MavenProject p = this.readProject(pom);
                projects.add(p);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Error loading " + pom, (Exception)((Object)e));
            }
        }
        return projects;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) throws MavenEmbedderException {
        try {
            RepositorySystem repositorySystem = this.lookup(RepositorySystem.class);
            return repositorySystem.createArtifact(groupId, artifactId, version, scope, type);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) throws MavenEmbedderException {
        try {
            RepositorySystem repositorySystem = this.lookup(RepositorySystem.class);
            return repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException(e.getMessage(), e);
        }
    }

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResult execute(MavenRequest mavenRequest) throws ComponentLookupException {
        Maven maven = this.lookup(Maven.class);
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.plexusContainer.getContainerRealm());
            MavenExecutionResult mavenExecutionResult = maven.execute(this.mavenExecutionRequest);
            return mavenExecutionResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public ArtifactRepository createLocalRepository(File localRepository) throws ComponentLookupException {
        return this.createLocalRepository(localRepository.getAbsolutePath(), DEFAULT_LOCAL_REPO_ID);
    }

    public ArtifactRepository createLocalRepository(Settings settings) throws ComponentLookupException {
        return this.createLocalRepository(settings.getLocalRepository(), DEFAULT_LOCAL_REPO_ID);
    }

    public ArtifactRepository createLocalRepository(String url, String repositoryId) throws ComponentLookupException {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        return this.createRepository(url, repositoryId);
    }

    public ArtifactRepository createRepository(String url, String repositoryId) throws ComponentLookupException {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        RepositorySystem repositorySystem = this.lookup(RepositorySystem.class);
        ArtifactRepositoryLayout repositoryLayout = this.lookup(ArtifactRepositoryLayout.class, DEFAULT_LAYOUT_ID);
        return repositorySystem.createArtifactRepository(repositoryId, url, repositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    private List<File> getPomFiles(File basedir, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int i = 0; i < scanner.getIncludedFiles().length; ++i) {
            poms.add(new File(basedir, scanner.getIncludedFiles()[i]));
        }
        return poms;
    }

    private void resolveParameters(WagonManager wagonManager, Settings settings) throws ComponentLookupException, ComponentLifecycleException, SettingsConfigurationException {
        Proxy proxy = settings.getActiveProxy();
        if (proxy != null && proxy.getHost() == null) {
            throw new SettingsConfigurationException("Proxy in settings.xml has no host");
        }
        for (Server server : settings.getServers()) {
            if (server.getConfiguration() == null) continue;
        }
        for (Mirror mirror : settings.getMirrors()) {
        }
    }

    public <T> T lookup(Class<T> clazz) throws ComponentLookupException {
        return (T)this.plexusContainer.lookup(clazz);
    }

    public <T> T lookup(Class<T> clazz, String hint) throws ComponentLookupException {
        return (T)this.plexusContainer.lookup(clazz, hint);
    }

    public Object lookup(String role, String hint) throws ComponentLookupException {
        return this.plexusContainer.lookup(role, hint);
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.plexusContainer.lookup(role);
    }

    private Map<String, String> propertiesToMap(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public MavenRequest getMavenRequest() {
        return this.mavenRequest;
    }
}

