/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite;

import hudson.Plugin;
import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public class FavoritePlugin
extends Plugin {
    @RequirePOST
    public void doToggleFavorite(StaplerRequest req, StaplerResponse resp, @QueryParameter String job, @QueryParameter Boolean redirect) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        User user = User.current();
        if (user != null && !FavoritePlugin.isAnonymous(user)) {
            try {
                Favorites.toggleFavorite(user, FavoritePlugin.getItem(job));
            }
            catch (Favorites.FavoriteException e) {
                throw new IOException(e);
            }
        }
        if (redirect.booleanValue()) {
            if (!job.contains("/")) {
                resp.sendRedirect(resp.encodeRedirectURL(jenkins.getRootUrl() + "job/" + job));
            } else {
                StringBuilder urlPostfix = new StringBuilder("job/");
                String[] itemNames = job.split("/");
                for (int i = 0; i < itemNames.length; ++i) {
                    urlPostfix.append(itemNames[i]);
                    if (i >= itemNames.length - 1) continue;
                    urlPostfix.append("/job/");
                }
                resp.sendRedirect(resp.encodeRedirectURL(jenkins.getRootUrl() + urlPostfix.toString()));
            }
        }
    }

    static boolean isAnonymous(@Nonnull User user) {
        return user.getFullName().equalsIgnoreCase("anonymous");
    }

    public static Item getItem(String fullName) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        Item item = jenkins.getItemByFullName(fullName);
        if (item == null) {
            throw new IllegalArgumentException("Item <" + fullName + "> does not exist");
        }
        return item;
    }
}

