/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.token;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class FavoriteUsersEmailTokenMacro
extends DataBoundTokenMacro {
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        ArrayList<String> users = new ArrayList<String>();
        AbstractProject project = context.getProject();
        for (User user : User.getAll()) {
            if (!Favorites.isFavorite(user, (Item)project)) continue;
            Mailer.UserProperty mail = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            users.add(mail.getAddress());
        }
        return StringUtils.join(users, (String)",");
    }

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("FAVORITE_USERS_EMAIL");
    }
}

