/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.user.FavoriteUserPropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class FavoriteUserProperty
extends UserProperty {
    private static final Logger LOGGER = Logger.getLogger(FavoriteUserProperty.class.getName());
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new FavoriteUserPropertyDescriptor();
    transient List<String> favorites = new ArrayList<String>();
    private ConcurrentMap<String, Boolean> data = Maps.newConcurrentMap();
    private transient long lastValidated = 0L;

    @DataBoundConstructor
    public FavoriteUserProperty() {
    }

    @Deprecated
    public List<String> getFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return ImmutableList.copyOf(Maps.filterEntries(this.data, (Predicate)new Predicate<Map.Entry<String, Boolean>>(){

            public boolean apply(@Nullable Map.Entry<String, Boolean> input) {
                return input != null && input.getValue() != false;
            }
        }).keySet());
    }

    public Set<String> getAllFavorites() {
        this.removeFavoritesWhichDoNotExist();
        return Maps.filterEntries(this.data, (Predicate)new Predicate<Map.Entry<String, Boolean>>(){

            public boolean apply(@Nullable Map.Entry<String, Boolean> input) {
                return input != null && input.getValue() != false;
            }
        }).keySet();
    }

    public void addFavorite(String job) throws IOException {
        this.data.put(job, true);
        this.user.save();
    }

    public void removeFavorite(String job) throws IOException {
        this.data.put(job, false);
        this.user.save();
    }

    public boolean toggleFavorite(String job) throws IOException {
        if (this.isJobFavorite(job)) {
            this.removeFavorite(job);
            return false;
        }
        this.addFavorite(job);
        return true;
    }

    void deleteFavourite(String job) throws IOException {
        this.data.remove(job);
        this.user.save();
    }

    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    public boolean isJobFavorite(String job) {
        Boolean favorite = (Boolean)this.data.get(job);
        return favorite != null ? favorite : false;
    }

    public boolean hasFavorite(String job) {
        return this.data.containsKey(job);
    }

    public UserPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    Object readResolve() {
        if (this.favorites != null) {
            this.data = Maps.newConcurrentMap();
            for (String job : this.favorites) {
                this.data.put(job, true);
            }
            this.favorites = null;
        }
        return this;
    }

    private void removeFavoritesWhichDoNotExist() {
        Jenkins jenkins = Jenkins.getInstance();
        for (String fullName : ImmutableSet.copyOf(this.data.keySet())) {
            if (jenkins.getItemByFullName(fullName) != null) continue;
            try {
                this.deleteFavourite(fullName);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Could not purge favorite '" + fullName + "'", e);
            }
        }
    }
}

