/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.favorite.user;

import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.favorite.Messages;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;

public class FavoriteUserPropertyDescriptor
extends UserPropertyDescriptor {
    public FavoriteUserPropertyDescriptor() {
        super(FavoriteUserProperty.class);
    }

    public UserProperty newInstance(User user) {
        return new FavoriteUserProperty();
    }

    public String getDisplayName() {
        return Messages.favoriteUserPropertyDescriptor();
    }

    public AutoCompletionCandidates doAutoCompleteJob(@QueryParameter String value) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        for (String job : jenkins.getJobNames()) {
            if (!job.toLowerCase().startsWith(value.toLowerCase())) continue;
            c.add(job);
        }
        return c;
    }

    public Item toItem(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return null;
        }
        Jenkins container = Jenkins.getInstance();
        if (container == null) {
            throw new IllegalStateException("Jenkins not started");
        }
        int start = 0;
        int index = fullName.indexOf(47, start);
        while (index != -1) {
            Item item = container.getItem(fullName.substring(start, index));
            if (item instanceof ItemGroup) {
                container = (ItemGroup)item;
                start = index + 1;
                index = fullName.indexOf(47, start);
                continue;
            }
            index = fullName.indexOf(47, index + 1);
        }
        return container.getItem(fullName.substring(start));
    }
}

