/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mjiip.v_2_2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jaxb2.maven2.RawXJC2Mojo;
import org.jvnet.mjiip.v_2_2.LoggingCodeWriter;
import org.jvnet.mjiip.v_2_2.LoggingErrorReceiver;
import org.jvnet.mjiip.v_2_2.OptionsFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class XJC22Mojo
extends RawXJC2Mojo<Options> {
    private final org.jvnet.jaxb2.maven2.OptionsFactory<Options> optionsFactory = new OptionsFactory();

    protected org.jvnet.jaxb2.maven2.OptionsFactory<Options> getOptionsFactory() {
        return this.optionsFactory;
    }

    public void doExecute(Options options) throws MojoExecutionException {
        Model model = this.loadModel(options);
        Outline outline = this.generateCode(model);
        this.writeCode(outline);
    }

    protected Model loadModel(Options options) throws MojoExecutionException {
        Model model;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Parsing input schema(s)...");
        }
        if ((model = ModelLoader.load((Options)options, (JCodeModel)new JCodeModel(), (ErrorReceiver)new LoggingErrorReceiver("Error while parsing schema(s).", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Unable to parse input schema(s). Error messages should have been provided.");
        }
        return model;
    }

    protected Outline generateCode(Model model) throws MojoExecutionException {
        Outline outline;
        if (this.getVerbose()) {
            this.getLog().info((CharSequence)"Compiling input schema(s)...");
        }
        if ((outline = model.generateCode(model.options, (ErrorReceiver)new LoggingErrorReceiver("Error while generating code.", this.getLog(), this.getVerbose()))) == null) {
            throw new MojoExecutionException("Failed to compile input schema(s)! Error messages should have been provided.");
        }
        return outline;
    }

    protected void writeCode(Outline outline) throws MojoExecutionException {
        if (this.getWriteCode()) {
            Model model = outline.getModel();
            JCodeModel codeModel = model.codeModel;
            File targetDirectory = model.options.targetDir;
            if (this.getVerbose()) {
                this.getLog().info((CharSequence)MessageFormat.format("Writing output to [{0}].", targetDirectory.getAbsolutePath()));
            }
            try {
                if (this.getCleanPackageDirectories()) {
                    if (this.getVerbose()) {
                        this.getLog().info((CharSequence)"Cleaning package directories.");
                    }
                    this.cleanPackageDirectories(targetDirectory, codeModel);
                }
                LoggingCodeWriter codeWriter = new LoggingCodeWriter(model.options.createCodeWriter(), this.getLog(), this.getVerbose());
                codeModel.build((CodeWriter)codeWriter);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write files: " + e.getMessage(), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"The [writeCode] setting is set to false, the code will not be written.");
        }
    }

    private void cleanPackageDirectories(File targetDirectory, JCodeModel codeModel) {
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JPackage _package = (JPackage)packages.next();
            File packageDirectory = _package.isUnnamed() ? targetDirectory : new File(targetDirectory, _package.name().replace('.', File.separatorChar));
            if (!packageDirectory.isDirectory()) continue;
            if (this.isRelevantPackage(_package)) {
                if (this.getVerbose()) {
                    this.getLog().info((CharSequence)MessageFormat.format("Cleaning directory [{0}] of the package [{1}].", packageDirectory.getAbsolutePath(), _package.name()));
                }
                this.cleanPackageDirectory(packageDirectory);
                continue;
            }
            if (!this.getVerbose()) continue;
            this.getLog().info((CharSequence)MessageFormat.format("Skipping directory [{0}] of the package [{1}] as it does not contain generated classes or resources.", packageDirectory.getAbsolutePath(), _package.name()));
        }
    }

    private boolean isRelevantPackage(JPackage _package) {
        if (_package.propertyFiles().hasNext()) {
            return true;
        }
        Iterator classes = _package.classes();
        while (classes.hasNext()) {
            JDefinedClass _class = (JDefinedClass)classes.next();
            if (_class.isHidden()) continue;
            return true;
        }
        return false;
    }
}

